//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Cursor.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>

struct Cursors {
	char		*name;
	unsigned 	value;
} cursors[] = {
	"X_cursor",	XC_X_cursor,
	"arrow",	XC_arrow,
	"based_arrow_down",	XC_based_arrow_down,
	"based_arrow_up",	XC_based_arrow_up,
	"boat",	XC_boat,
	"bogosity",	XC_bogosity,
	"bottom_left_corner",	XC_bottom_left_corner,
	"bottom_right_corner",	XC_bottom_right_corner,
	"bottom_side",	XC_bottom_side,
	"bottom_tee",	XC_bottom_tee,
	"box_spiral",	XC_box_spiral,
	"center_ptr",	XC_center_ptr,
	"circle",	XC_circle,
	"clock",	XC_clock,
	"coffee_mug",	XC_coffee_mug,
	"cross",	XC_cross,
	"cross_reverse",	XC_cross_reverse,
	"crosshair",	XC_crosshair,
	"diamond_cross",	XC_diamond_cross,
	"dot",	XC_dot,
	"dotbox",	XC_dotbox,
	"double_arrow",	XC_double_arrow,
	"draft_large",	XC_draft_large,
	"draft_small",	XC_draft_small,
	"draped_box",	XC_draped_box,
	"exchange",	XC_exchange,
	"fleur",	XC_fleur,
	"gobbler",	XC_gobbler,
	"gumby",	XC_gumby,
	"hand1",	XC_hand1,
	"hand2",	XC_hand2,
	"heart",	XC_heart,
	"icon",	XC_icon,
	"iron_cross",	XC_iron_cross,
	"left_ptr",	XC_left_ptr,
	"left_side",	XC_left_side,
	"left_tee",	XC_left_tee,
	"leftbutton",	XC_leftbutton,
	"ll_angle",	XC_ll_angle,
	"lr_angle",	XC_lr_angle,
	"man",	XC_man,
	"middlebutton",	XC_middlebutton,
	"mouse",	XC_mouse,
	"pencil",	XC_pencil,
	"pirate",	XC_pirate,
	"plus",	XC_plus,
	"question_arrow",	XC_question_arrow,
	"right_ptr",	XC_right_ptr,
	"right_side",	XC_right_side,
	"right_tee",	XC_right_tee,
	"rightbutton",	XC_rightbutton,
	"rtl_logo",	XC_rtl_logo,
	"sailboat",	XC_sailboat,
	"sb_down_arrow",	XC_sb_down_arrow,
	"sb_h_double_arrow",	XC_sb_h_double_arrow,
	"sb_left_arrow",	XC_sb_left_arrow,
	"sb_right_arrow",	XC_sb_right_arrow,
	"sb_up_arrow",	XC_sb_up_arrow,
	"sb_v_double_arrow",	XC_sb_v_double_arrow,
	"shuttle",	XC_shuttle,
	"sizing",	XC_sizing,
	"spider",	XC_spider,
	"spraycan",	XC_spraycan,
	"star",	XC_star,
	"target",	XC_target,
	"tcross",	XC_tcross,
	"top_left_arrow",	XC_top_left_arrow,
	"top_left_corner",	XC_top_left_corner,
	"top_right_corner",	XC_top_right_corner,
	"top_side",	XC_top_side,
	"top_tee",	XC_top_tee,
	"trek",	XC_trek,
	"ul_angle",	XC_ul_angle,
	"umbrella",	XC_umbrella,
	"ur_angle",	XC_ur_angle,
	"watch",	XC_watch,
	"xterm",	XC_xterm,
	0,		0,
};

static
compare(char *s1, char *s2, int len)
{   CVO_ENTER
	while (len-- && *s1) {
		if (*s1 == '_') {
			if (*s2 != ' ' && *s2 != '_')
				CVO_RETURN(0)
		} else if (*s2 >= 'A' && *s2 <= 'Z') {
			if (*s1 != (*s2 | 040))
				CVO_RETURN(0)
		} else if (*s1 != *s2)
			CVO_RETURN(0)
		++s1, ++s2;
	}
	CVO_RETURN((!len && !*s2) || *s1 == *s2)
}
void
Cvo_LayoutWindow::SetCursor(char *cname)
{
    SetCursor(Cvo_Cursor(this, cname));
}

void
Cvo_LayoutWindow::SetCursor(unsigned curs)
{
    SetCursor(Cvo_Cursor(this, curs));
}

void
Cvo_LayoutWindow::SetCursor(const Cvo_Cursor &nc)
{   CVO_ENTER
    if (nc == cursor)
	CVO_VOID_RETURN
    if (cursor.Empty() && parent &&
			  parent->ToLayoutWindow()->GetCursor() == nc) {
	cursor = nc;
	CVO_VOID_RETURN
    }
    cursor = nc;
    if (cursor.Full()) {
	XDefineCursor(Dpy(), Object(), cursor->CursorValue());
    }
    CVO_VOID_RETURN
}

Cvo_Cursor::Cvo_Cursor(Cvo_Object *obj, char *cname)
{   CVO_ENTER
    realcursor = 0;
    while (*cname == ' ' || *cname == '\t')
	++cname;
    for (char *e = cname; *e; ++e)
	;

    while (e > cname && (*e == ' ' || *e == '\t'))
	--e;
//  *e = 0;

    if (compare("xc_", cname, 3))
	cname += 3;

    if (!*cname) {
	CVO_VOID_RETURN
    }

    for (Cursors *cs = cursors; cs->name; ++cs) {
	if (compare(cs->name, cname, e - cname)) {
	    realcursor = _Cvo_Cursor::LoadCursor(obj, cs->value);
	    break;
	}
    }
}

Cvo_Cursor::Cvo_Cursor(Cvo_Object *obj, unsigned curs)
{
    realcursor = _Cvo_Cursor::LoadCursor(obj, curs);
}

_Cvo_Cursor *_Cvo_Cursor::root = 0;

_Cvo_Cursor *
_Cvo_Cursor::LoadCursor(Cvo_Object *obj, unsigned curs)
{   CVO_ENTER
    Cvo_Lock lock;
    Cvo_Window *w = obj->ToWindow();

    CARD32 f = (w && w->Foreground().Full()) ? w->Foreground()->Pixel()
					     : CARD32(-1);
    CARD32 b = (w && w->Background().Full()) ? w->Background()->Pixel()
					     : CARD32(-1);

    _Cvo_Cursor *cwc = root;

    while (cwc) {
	if (obj->Dpy() == cwc->dpy &&
	    f == cwc->fore && b == cwc->back && curs == cwc->index)
	    break;
        cwc = cwc->next;
    }

    if (cwc)
	CVO_RETURN(cwc->Copy())

    cwc = new _Cvo_Cursor();
    cwc->dpy = obj->Dpy();
    cwc->fore = f;
    cwc->back = b;
    cwc->refcnt = 1;

    cwc->cursor = XCreateFontCursor(cwc->dpy, cwc->index = curs);
    if (f != CARD32(-1) && b != CARD32(-1)) {
	XColor cdefs[2];
	cdefs[0].pixel = f;
	cdefs[1].pixel = b;
	XQueryColors(cwc->dpy, w->Cmap(), cdefs, 2);
	XRecolorCursor(cwc->dpy, cwc->cursor, cdefs, cdefs+1);
    }
    CVO_RETURN(cwc)
}

_Cvo_Cursor::_Cvo_Cursor()
{   CVO_ENTER
    next = root;
    root = this;
    CVO_VOID_RETURN
}

_Cvo_Cursor::~_Cvo_Cursor()
{   CVO_ENTER
    if (cursor)
	XFreeCursor(dpy, cursor);

    if (this == root)
	root = next;
    else if (root) {
	_Cvo_Cursor *c = root;
	while (c->next && c->next != this)
	    c = c->next;
	if (c->next == this)
	    c->next = next;
    }
    CVO_DONE
}
