//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Event.cc,v 1.7 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/InputContext.h++>
#include <memory.h>
#include <unistd.h>
#if	defined(cray)
#include <time.h>
#endif
#if defined(__NEED_SYSENT__)
#include <sysent.h>
#endif
#if	defined(__NEED_BZERO_DEF__)
extern "C" int bzero(char *, unsigned int);
#endif

struct FilterStack {
    Cvo_Object	*win;
    XEvent	*(*filter)(Cvo_Object *, XEvent *, void *);
    void	*data;
    FilterStack	*next;
    int		 exclusive;
};

static FilterStack *filters = 0;	// Stack of filters to use
static FilterStack *nextfilter = 0;	// Next filter to use in stack

static XEvent *
usefilters(Cvo_Object *w, XEvent *event)
{   CVO_ENTER
    FilterStack *fs = filters;

    while (fs) {
	nextfilter = fs->next;
	if (!fs->win || !w) {
	    if (!(event = (*fs->filter)(w, event, fs->data)))
		CVO_RETURN(event)
	} else {
	    Cvo_Object *p = w;

	    while (p && p != fs->win)
		p = p->Parent();
	    if (p) {
		if (!(event = (*fs->filter)(w, event, fs->data)))
		    CVO_RETURN(event)
	    }
	}
	fs = nextfilter;
    }
    CVO_RETURN(event)
}

static inline Atom
protocol(Cvo_Object *cwc, _Cvo_Protocols p)
{
    return(cwc->DisplayList()->protocols[int(p)]);
}

//
// Handle one X Event.
//
XEvent *
_Cvo_event(XEvent *event)
{   CVO_ENTER
    Cvo_Object *cwc = 0;
    Cvo_LayoutWindow *lwc;
    Cvo_Window *wwc;

    int redisp = 0;
    int one = 1;

    Cvo_Lock lock;


#if	defined(sun)
    if (_cvo_debug_print_events)
	Cvo_PrintEvent(stdout, event);
#endif

    if (_Cvo_IsCvoEvent(event)) {
	cwc = ((Cvo_AnyEvent *)event)->win;
    } else {

    	//
    	// Before we do anything else, we need to redirect any KeyPress
    	// and KeyRelease events.
    	//
	switch (event->type) {
	case KeyPress:
	case KeyRelease: {
    	    Cvo_DisplayList *dl = 0;
    	    dl = dl->FindDisplayList(event->xany.display);
    	    Cvo_Object *f = dl ? dl->Focus() : 0;

	    cwc = Cvo_FindWindow(event->xany.display, event->xany.window);
    	    if (cwc) {
		if (!f && cwc->focus && dl->ClickToType() != True) {
		    f = cwc->focus;
		    f->TakeFocus();
		}
		if (f && f->Win() != event->xany.window) {
		    XKeyEvent *ke = (XKeyEvent *)event;

		    ke->window = f->Win();
		    ke->x = ke->x_root;
		    ke->y = ke->y_root;
		    f->ComputeOriginFromRoot(&ke->x, &ke->y);
		    cwc = f;
		} else if (lwc = cwc->ToLayoutWindow()) {
		    lwc->FromXCoord(&event->xkey.x, &event->xkey.y);
		}
    	    }
    	    break;
    	  }
    	}
#if	!defined(X11R4)
	if (XFilterEvent(event, None)) {
	    CVO_RETURN(0)
	}
#endif
    	if (!cwc)
	switch (event->type) {
	case ClientMessage:
	    if (cwc = Cvo_FindWindow(event->xany.display, event->xany.window))
		break;

	    if (filters)
		event = usefilters(0, event);
	    CVO_RETURN(event)
	case DestroyNotify:
	case CirculateNotify:
	case ConfigureNotify:
	case GravityNotify:
	case MapNotify:
	case ReparentNotify:
	case UnmapNotify:
	case ConfigureRequest:
	case CirculateRequest:
	case CreateNotify:
	default:
	    if (!(cwc = Cvo_FindWindow(event->xany.display, event->xany.window))) {
		if (filters)
		    event = usefilters(0, event);
		CVO_RETURN(event)
	    }
	    break;
	}
    }

#if	defined(sun)
    if (cwc->printevents) {
	Cvo_PrintEvent(stdout, event, cwc);
    }
#endif


    //
    // Only allow certain events through if they came from the window
    // managers parent window for us.
    //
    if (event->xany.window && cwc->PWin() == event->xany.window) {
	switch(event->type) {
	case ConfigureNotify:
	    break;
	default:
	    CVO_RETURN(event)
	}
    }

    wwc = cwc->ToWindow();
    lwc = cwc->ToLayoutWindow();

    if (filters && !(event = usefilters(cwc, event))) {
	CVO_RETURN(event)
    }

    //
    // Now cope with KeyPress events and XwcLookup strings and such.
    //
    if (wwc && wwc->dokeytext
	    && event->type == KeyPress) {
	Cvo_KeyTextEvent kte;

	cwc->EventHandler(event);

	if (event->type) {
	    wwc->lookupbuf.LookupString(wwc, (XKeyEvent *)event, &kte);
	    wwc->SendEvent(&kte);
	}
	CVO_RETURN(0)
    }


    switch (event->type) {
    case NoExpose:
	cwc->FinishedCopy();
	wwc->EventHandler(event);
	break;
    case GraphicsExpose:
	//
	// It is safe to say that the exposure is finished as X guarantees
	// to make all of them contiguous.  The User's event handler will
	// only get called once all the GraphicsExpose events have been
	// handled.
	//
	cwc->FinishedCopy();
	// FALL THRU
    case Expose: {

	if (event->type == Expose) {
	    //
	    // If it's a shadow then ignore it
	    //
	    if (wwc && wwc->Shadow() == event->xexpose.window)
		break;
	    if (!cwc->InCopy())
		cwc->Flush(3);
	}

	XExposeEvent *ee = (XExposeEvent *)event;

	if (wwc)
	    wwc->exposed = True;

	int minx = ee->x;
	int miny = ee->y;
	int maxx = ee->width + ee->x;
	int maxy = ee->height + ee->y;

	if (wwc) {
	    wwc->FromXCoord(&ee->x, &ee->y);
	    if (ee->x < 0) {
		ee->width += ee->x;
		ee->x = 0;
	    }
	    if (ee->y < 0) {
		ee->height += ee->y;
		ee->y = 0;
	    }
	    if (ee->x + ee->width > cwc->width)
		    ee->width = cwc->width - ee->x;
	    if (ee->y + ee->height > cwc->height)
		    ee->height = cwc->height - ee->y;
	    wwc->Exposure(ee);
	} else {
	    if (lwc)
		lwc->FromXCoord(&ee->x, &ee->y);
	    cwc->EventHandler(event);
	}

	//
	// we read up other exposure events here
	//
	if (ee->count)  {
	    XEvent _ne;
	    XExposeEvent *ne = (XExposeEvent *)&_ne;

	    do {
		XMaskEvent(cwc->Dpy(), ExposureMask, &_ne);

		if (ne->x < minx)
		    minx = ne->x;
		if (ne->y < miny)
		    miny = ne->y;
		if (ne->x + ne->width > maxx)
		    maxx = ne->x + ne->width;
		if (ne->y + ne->height > maxy)
		    maxy = ne->y + ne->height;
			    
		if (wwc) {
		    wwc->FromXCoord(&ne->x, &ne->y);
		    if (ne->x < 0) {
			ne->width += ne->x;
			ne->x = 0;
		    }
		    if (ne->y < 0) {
			ne->height += ne->y;
			ne->y = 0;
		    }
		    if (ne->x + ne->width > cwc->width)
			    ne->width = cwc->width - ne->x;
		    if (ne->y + ne->height > cwc->height)
			    ne->height = cwc->height - ee->y;
		    wwc->Exposure(ne);
		} else {
		    event = (XEvent *)ne;
		    if (lwc)
			lwc->FromXCoord(&ne->x, &ne->y);
		    cwc->EventHandler(event);
		}
	    } while (ne->count);
	}
	if (!wwc) {
	    break;
	}

	event->xexpose.x = minx;
	event->xexpose.y = miny;
	event->xexpose.width = maxx - minx;
	event->xexpose.height = maxy - miny;

	wwc->FromXCoord(&event->xexpose.x, &event->xexpose.y);
	if (event->xexpose.x < 0) {
	    event->xexpose.width += event->xexpose.x;
	    event->xexpose.x = 0;
	}
	if (event->xexpose.y < 0) {
	    event->xexpose.height += event->xexpose.y;
	    event->xexpose.y = 0;
	}
	if (event->xexpose.x + event->xexpose.width > cwc->width)
		event->xexpose.width = cwc->width - event->xexpose.x;
	if (event->xexpose.y + event->xexpose.height > cwc->height)
		event->xexpose.height = cwc->height - event->xexpose.y;

	wwc->EventHandler(event);

	wwc->PostExposure(ee);
	break;
      }
    case ConfigureNotify: {
	XConfigureEvent *ce = (XConfigureEvent *)event;

	if (!cwc->Parent()
	    && _Cvo_QueueDeConfigure(cwc, ce->width, ce->height)) {
	    //
	    // We still have to update the position of the window, so
	    // only call the PreConfigure handler and then undo the
	    // possible change to ``configure''
	    //
	    cwc->PreConfigure(ce);
	    cwc->configured = cwc->oldconfigured;
	    break;
	}

	//
	// Check the case where we wanted to know that some other
	// window changed configuration.  In that case we only
	// need to call the function the user registered for.
	//
	if (ce->event != ce->window || ce->window == cwc->PWin()) {
		cwc->EventHandler(event);
		break;
	}

	Cvo_ResizeEvent cre;
	Cvo_MovedEvent cme;
	cre.old_width = cwc->width;
        cre.old_height = cwc->height;


	cwc->Origin(&cme.old_x, &cme.old_y);

	cwc->Flush(3);
	cwc->PreConfigure(ce);
	cwc->Configure(ce);
	cwc->EventHandler(event);
	cwc->PostConfigure(ce);

	cre.new_width = cwc->width;
        cre.new_height = cwc->height;
	cwc->Origin(&cme.new_x, &cme.new_y);

	//
	// Now generate the Cvo Moved event if it happened.
	// These only need to be generated on a TopLevel window if the
	// move/resize was not due to an internal request.
	//
	if (!cwc->Parent() || !cwc->oldconfigured) {
	    cre.tag = Cvo_CONFIGTAG;
	    cme.tag = Cvo_CONFIGTAG;
	    if (!cwc->oldconfigured || cme.new_x != cme.old_x
				    || cme.new_y != cme.old_y)
		cwc->SendEvent(CvoMovedEvent, &cme);
	    if (!cwc->oldconfigured || cre.new_width != cre.old_width
				    || cre.new_height != cre.old_height) {
		cwc->SendEvent(CvoResizeEvent, &cre);
	    }
	}

	break;
      }
    case ReparentNotify: {
	XReparentEvent *re = (XReparentEvent *)event;

	//
	// Check the case where we wanted to know that some other
	// window changed configuration.  In that case we only
	// need to call the function the user registered for.
	//
	if (re->event != re->window) {
	    cwc->EventHandler(event);
	    break;
	}
	cwc->Flush(3);
	cwc->Reparent(re);
	cwc->EventHandler(event);
	break;
      }
    case KeyPress:
    case KeyRelease:
	// if (lwc)
	//     lwc->FromXCoord(&event->xkey.x, &event->xkey.y);
	cwc->EventHandler(event);
	break;
    case MotionNotify:
	if (lwc)
	    lwc->FromXCoord(&event->xmotion.x, &event->xmotion.y);
	cwc->EventHandler(event);
	break;
    case ButtonPress: {
	_Cvo_XButtonEvent cbe;
	memcpy(&cbe, event, sizeof(XButtonEvent));

	if (lwc)
	    lwc->FromXCoord(&cbe.x, &cbe.y);
	cwc->DisplayList()->BCount(cwc, &cbe);
	cwc->EventHandler((XEvent *)&cbe);
	break;
      }
    case ButtonRelease: {
	_Cvo_XButtonEvent cbe;
	memcpy(&cbe, event, sizeof(XButtonEvent));

	if (lwc)
	    lwc->FromXCoord(&cbe.x, &cbe.y);
	cwc->DisplayList()->BRelease(cwc, &cbe);
	cwc->EventHandler((XEvent *)&cbe);
	break;
      }
    case ClientMessage:
	if (event->xclient.data.l[0] == protocol(cwc, CvoP_DELETE_WINDOW)) {
	    Cvo_DeleteWindowEvent dwe;

	    cwc->SendEvent(CvoDeleteWindowEvent, &dwe);
	    break;
	}
	cwc->EventHandler(event);
	break;
    case CvoDestroyedChildEvent:
	//
	// Don't worry about children going away when we are going away
	// as they are going away because we are.
	//
	if (cwc->deleting)
	    CVO_RETURN(0);
	cwc->EventHandler(event);
	break;
    default:
	cwc->EventHandler(event);
	break;
    }
    CVO_RETURN(0)
}

void
Cvo_Object::SendEvent(int type, Cvo_AnyEvent *ev)
{   CVO_ENTER
    Cvo_Lock lock;

    ev->type = type;
    ev->display = Dpy();
    ev->window = Object();
    ev->send_event = 1;
    if (_Cvo_IsCvoEvent((XEvent *)ev))
	ev->win = this;
    _Cvo_event((XEvent *)ev);
    CVO_VOID_RETURN
}

void
Cvo_Object::SendEvent(Cvo_AnyEvent *ev)
{   CVO_ENTER
    Cvo_Lock lock;

    ev->display = Dpy();
    ev->window = Object();
    ev->send_event = 1;
    if (_Cvo_IsCvoEvent((XEvent *)ev))
	ev->win = this;
    _Cvo_event((XEvent *)ev);
    CVO_VOID_RETURN
}

void
Cvo_Object::SendXEvent(XEvent *ev)
{   CVO_ENTER
    Cvo_Lock lock;

    ev->xany.display = Dpy();
    ev->xany.window = Object();
    ev->xany.send_event = 1;
    _Cvo_event((XEvent *)ev);
    CVO_VOID_RETURN
}

void
Cvo_Object::ScanEvents()
{   CVO_ENTER
    fd_set fdset;
    static struct timeval tv = { 0 };

    Cvo_Lock lock;

    FD_ZERO(&fdset);
    FD_SET(ConnectionNumber(Dpy()), &fdset);

    XFlush(Dpy());

    while (QLength(Dpy()) > 0) {
	XEvent ev;
	XNextEvent(Dpy(), &ev);
	_Cvo_event(&ev);
    }

    if (select(FD_SETSIZE, &fdset, 0, 0, &tv) == 1) {
	do {
	    XEvent ev;
	    XNextEvent(Dpy(), &ev);
	    _Cvo_event(&ev);
	} while (QLength(Dpy()));
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::_WaitForCopy()
{   CVO_ENTER
    while (InCopy()) {
	//
	// First check the pending events and if we still are in
	// a copy, then block for new events.
	//
	Cvo_ScanDisplays();
	if (InCopy())
	    Cvo_ScanInputs(True);
    }
    CVO_VOID_RETURN
}

void
Cvo_PushEventFilter(XEvent *(*f)(Cvo_Object *, XEvent *, void *),
		    Cvo_Object *win,
		    void *data,
		    BOOL exclusive)
{   CVO_ENTER
    FilterStack *fs = new FilterStack;
    fs->next = filters;
    fs->filter = f;
    fs->win = win;
    fs->data = data;
    fs->exclusive = exclusive;
    filters = fs;
    CVO_VOID_RETURN
}

BOOL
Cvo_ExclusiveEventFilter()
{
    FilterStack *fs = filters;
    while (fs) {
	if (fs->exclusive)
	    return(True);
	fs = fs->next;
    }
    return(False);
}

void
Cvo_PopEventFilter()
{   CVO_ENTER
    if (!filters)
	CVO_VOID_RETURN

    //
    // We must be careful if we are popping off a filter that we were
    // planning to use next...
    //
    if (filters == nextfilter)
	nextfilter = filters->next;

    FilterStack *fs = filters;

    filters = filters->next;
    delete fs;
    CVO_VOID_RETURN
}

void
Cvo_CharacterBuffer::LookupString(Cvo_Window *win, XKeyEvent *ev,
				  Cvo_KeyTextEvent *kte)
{   CVO_ENTER
#if	!defined(X11R4)
    if (win->InputContext() && win->InputContext()->InputContext()) {
	int status;
	int len = 7;

	usewide = 1;
	usenarrow = 0;

	do {
	    if (wide.maxlen - 1 <= len) {
		    delete [] wide.value;
		    wide.value = new wchar_t[wide.maxlen = len + 1];
	    }

	    len = XwcLookupString(win->InputContext()->InputContext(),
				      ev,
				      wide.value,
				      wide.maxlen - 1,
				      &kte->keysym, &status);
	} while (status == XBufferOverflow);


	switch (status) {
	case XLookupNone:
	    wide.length = 0;
	    kte->have_sym = False;
	    kte->have_text = False;
	    kte->text = 0;
	    break;
	case XLookupKeySym:
	    wide.length = 0;
	    kte->have_text = False;
	    kte->have_sym = True;
	    kte->text = 0;
	    break;
	case XLookupBoth:
	    wide.length = len;
	    wide.value[len] = 0;
	    kte->have_text = True;
	    kte->have_sym = True;
	    kte->text = this;
	    break;
	case XLookupChars:
	    wide.length = len;
	    wide.value[len] = 0;
	    kte->have_sym = False;
	    kte->have_text = True;
	    kte->text = this;
	    break;
	}
    } else
#endif
    {
        int len = 0;

        usewide = 0;
        usenarrow = 1;

        do {
            if (narrow.maxlen < len + 8) {
                    delete [] narrow.value;
                    narrow.value = new char[narrow.maxlen = len + 9];
            }

            len = XLookupString(ev, narrow.value, narrow.maxlen - 1,
				&kte->keysym, NULL);
        } while (len == narrow.maxlen - 1);

	narrow.length = len;
	narrow.value[len] = 0;
	kte->have_sym = True;

	if (len) {
	    kte->have_text = True;
	    kte->text = this;
	} else {
	    kte->have_text = False;
	    kte->text = 0;
	}
    }

    //
    // Now fill in the rest of the structure
    //
    kte->type = CvoKeyTextEvent;
    kte->serial = ev->serial;
    kte->send_event = ev->send_event;
    kte->display = ev->display;
    kte->window = ev->window;
    kte->root = ev->root;
    kte->subwindow = ev->subwindow;
    kte->time = ev->time;
    kte->x = ev->x;
    kte->y = ev->y;
    kte->x_root = ev->x_root;
    kte->y_root = ev->y_root;
    kte->state = ev->state;
    kte->keycode = ev->keycode;
    kte->same_screen = ev->same_screen ? True : False;
    CVO_VOID_RETURN
}

class _Cvo_ConfigureQueue : public Cvo_RootedList {
public:
    static _Cvo_ConfigureQueue	*root;

    Cvo_Object			*object;
    int				width;
    int				height;
    int				count;

    _Cvo_ConfigureQueue(Cvo_Object *, int, int);
    ~_Cvo_ConfigureQueue()	{ Unlink((Cvo_RootedList **)&root); }
    _Cvo_ConfigureQueue *Next()	{ return((_Cvo_ConfigureQueue*)next); }
};

_Cvo_ConfigureQueue *_Cvo_ConfigureQueue::root = 0;

_Cvo_ConfigureQueue::_Cvo_ConfigureQueue(Cvo_Object *o, int w, int h)
		   : Cvo_RootedList((Cvo_RootedList **)&root)
{
    object = o;
    width = w;
    height = h;
    count = 8;		// que up to 16 deep 
}

void
_Cvo_QueueConfigure(Cvo_Object *obj, int width, int height)
{
    new _Cvo_ConfigureQueue(obj, width, height);
}

int
_Cvo_QueueDeConfigure(Cvo_Object *obj, int width, int height)
{
    _Cvo_ConfigureQueue *q = _Cvo_ConfigureQueue::root;

    while (q) {
	if (q->object == obj &&
	    q->width == width &&
	    q->height == height) {
		delete q;
		return(1);
	}
	if (q->object == obj && q->count-- <= 0) {
	    _Cvo_ConfigureQueue *p = q;
	    q = q->Next();
	    delete p;
	} else
	    q = q->Next();
    }
    return(0);
}
