//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: GenericList.cc,v 1.8 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/GenericList.h++>

static Cvo_Default defs[] = {
    "*CvoGenericList.BorderWidth: 0",

    "*CvoGenericList.CvoFrame.list.Cursor:Top Left Arrow",
    "*CvoGenericList.CvoFrame.list.sunken: True",
    "*CvoGenericList.CvoFrame.list.Pad:2",
    "*CvoGenericList.CvoFrame.list.FontFamily:Helvetica",
};

static char *trans = "\
        <Button1>: Press(1,0)\n\
        <Button2>: Press(2,0)\n\
        <Button3>: Press(3,0)\n\
        <ButtonRelease>: Release(0)\n\
        <Button1>(2): Press(1,1)\n\
        <Button2>(2): Press(2,1)\n\
        <Button3>(2): Press(3,1)\n\
        <ButtonRelease>(2): Release(1)\n\
";

CVO_BEGIN_BIND(Cvo_GenericList)
CVO_DOBIND(Cvo_GenericList, "Press",   Down)
CVO_DOBIND(Cvo_GenericList, "Release", Up)
CVO_END_BIND(Cvo_GenericList, Cvo_ViewPort)

CONSTRUCTORS_1ARG(Cvo_GenericList, Cvo_ViewPort, "CvoGenericList", Cvo_Page *)

static void
exposure(Cvo_Object *, XEvent *, void *tp)
{
    Cvo_GenericList_PageChanged(0, 0, tp);
}

void
Cvo_GenericList::_Init(Cvo_Page *i)
{   CVO_ENTER
    type = CvoT_GenericList;

    lookAtScreenOnly = False;
    drawingscreen = False;
    partialLine = False;
    radiostyle = False;
    reselect = True;
    current = -1;

    main = new Cvo_Window("list", upper);
    main->LoadFont();
    main->ExpandFrame();

    if (GetResourceTruth("verticalScrollBar", "ScrollBar", True)) {
	AddVertical();

	vertical->Register(CvoScrollBarEvent,
		           &Cvo_GenericList_ScrollVertical, this);
    }

    if (GetResourceTruth("horizontalScrollBar", "ScrollBar", True)) {
	AddHorizontal();

	horizontal->Register(CvoScrollBarEvent,
		     	     &Cvo_GenericList_ScrollHorizontal, this);
        horizontal->SetJump(main->TextAttribute()->MWidth());
    }

    Register(CvoResizeEvent, &Cvo_GenericList_PageChanged, this);
    Register(CvoMapRequestEvent, &Cvo_GenericList_MapRequest);
    main->Register(CvoPageChangedEvent, &Cvo_GenericList_PageChanged, this);
    main->Register(Expose, &exposure, this);
    main->Register(CvoResizeEvent, &Cvo_GenericList_Resize, this);

    if (page = i) {
        page->SetWindow(main);
	vertical->SetMaximum(page->NumberLines());
    }

    firstline = 0;
    lastline = 0;
    lines = 0;
    jumptoend = 1;
    xoffset = 0;
    AddTranslations(trans);
    CVO_VOID_RETURN
}

void
Cvo_GenericList_MapRequest(Cvo_Object *obj, XEvent *, void *)
{   CVO_ENTER
    Cvo_GenericList_PageChanged(0, 0, obj);
    ((Cvo_GenericList *)obj)->EvaluateWidth();
    CVO_VOID_RETURN
}

void
Cvo_GenericList::_Create()
{   CVO_ENTER
    Cvo_ViewPort::_Create();
    CVO_VOID_RETURN
}

void
Cvo_GenericList_ScrollHorizontal(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_GenericList *tp = (Cvo_GenericList *)data;

    tp->xoffset = se->value;
    Cvo_GenericList_PageChanged(0, 0, tp);
    tp->main->Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_GenericList_ScrollVertical(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_GenericList *tp = (Cvo_GenericList *)data;

    if (tp->firstline == se->value)
	CVO_VOID_RETURN
    tp->firstline = se->value;
    Cvo_GenericList_PageChanged(0, 0, tp); 
    if (tp->lookAtScreenOnly)
    	tp->EvaluateWidth();
}

//
// This routine is called when the something changes on the Page
//
void
Cvo_GenericList_PageChanged(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_GenericList *tp = (Cvo_GenericList *)data;
    Cvo_PageChangedEvent *pce = (Cvo_PageChangedEvent *)ev;
    Cvo_PageChangedEvent _pce;

    if (!tp->page || !tp->main->Object() || tp->drawingscreen)
	CVO_VOID_RETURN;
    tp->drawingscreen = True;

    if (!ev || ev->type != CvoPageChangedEvent) {
	pce = &_pce;
	pce->newlines = True;
	pce->changedlines = True;
	pce->removedlines = True;
    } else {
	tp->EvaluateWidth((pce->changedlines || pce->removedlines) ? 0 : tp->lines);
    	tp->current = -1;
    }

    tp->lines = tp->page->NumberLines();

    if (tp->vertical && (pce->newlines || pce->removedlines))
	tp->vertical->SetMaximum(tp->lines);

    if (tp->firstline < 0)
	tp->firstline = 0;
    int from = tp->firstline;

    //
    // All the 2's in here are to make room for a chamfer
    //

    XRectangle r;
    r.y = 0;
    r.x = 0;
    r.width = tp->main->Width();
    for (int save = tp->firstline; save < from; ++save) {
	r.y += tp->page->Height(save) + 2 + 2;
    }

    r.height = tp->main->Height() - r.y;
    tp->main->ClearArea(r);

    r.x += 2;
    r.y += 2;
    r.width -= 4;
    while (from < tp->lines && r.y < tp->main->Height()) {
        r.height = tp->page->Height(from);

        if (int(r.y + r.height) > tp->main->Height())
	    r.height = tp->main->Height() - r.y;
        if (tp->current == from) {
	    int oh = r.height;
	    int ow = r.width;

	    r.y -= 2;
            r.x -= 2;
            r.width += 4;
            r.height += 4;
	
            if (int(r.y + r.height) > tp->main->Height())
	        r.height = tp->main->Height() - r.y;

            tp->main->SetClipRectangles(0, 0, &r, 1, Unsorted);
	    tp->main->SetForeground(tp->main->Background());
	    ++r.width;
	    ++r.height;
	    tp->main->FillRectangle(r);

	    r.width = tp->page->Width(from) - tp->xoffset;
	    if (int(r.width) < int(tp->main->Width() - 4))
		r.width = tp->main->Width() - 4;
	    tp->main->DrawRaisedChamfer(2, r.x + 2 - tp->xoffset, r.y + 2,
					   r.width + tp->xoffset,
					   tp->page->Height(from),
					tp->main->Background());

	    tp->main->SetClipMask(None);
	    r.y += 2;
            r.x += 2;
            r.width = ow;
            r.height = oh;
	}
        tp->page->Draw(from, r, tp->xoffset);
        r.y += 2 + 2;
        r.y += r.height;
	tp->lastline = ++from;
    }
    if (r.y >= tp->main->Height() - 2) {
	tp->partialLine = True;
	tp->lastline--;
    } else {
	tp->partialLine = False;
    }

    if (tp->vertical) {
	if (tp->vertical->GetCurrent() != tp->firstline)
	    tp->vertical->SetCurrent(tp->firstline);
	if (tp->vertical->GetVisible() != tp->lastline - tp->firstline)
	    tp->vertical->SetVisible(tp->lastline - tp->firstline);
    }

    tp->main->Flush(2);
    tp->drawingscreen = False;
    CVO_VOID_RETURN
}

//
// This routine is called with the number of lines/columns on the Screen
// change
void
Cvo_GenericList_Resize(Cvo_Object *, XEvent *, void *data)
{   CVO_ENTER
    Cvo_GenericList *tp = (Cvo_GenericList *)data;

    if (tp->drawingscreen)
	return;

    if (tp->horizontal)
	tp->horizontal->SetVisible(tp->main->Width() - 2 - 2);
    Cvo_GenericList_PageChanged(0, 0, tp);
    tp->EvaluateWidth();
    CVO_VOID_RETURN
}

void
Cvo_GenericList::EvaluateWidth(int from)
{   CVO_ENTER
    if (!page || !horizontal)
	CVO_VOID_RETURN
    int mwidth = 0;
    int s = 0;
    int e = lines;

    if (lookAtScreenOnly) {
	s = firstline;
	if (lastline < e)
	    e = lastline + (partialLine ? 1 : 0);
    } else if (s = from)
	mwidth = horizontal->GetMaximum();

    Cvo_CharacterBuffer cb;

    for (int x = s; x < e; ++x) {
	int w = page->Width(x);

	if (w > mwidth)
	    mwidth = w;
    }
    if (mwidth != horizontal->GetMaximum()) {
	horizontal->SetMaximum(mwidth);
	horizontal->Flush(2);
    }
    CVO_VOID_RETURN
}

void
Cvo_GenericList::ClearSelected()
{
    if (current >= firstline && current <= lastline)  {
	current = -1;
        Cvo_GenericList_PageChanged(0, 0, this); 
    } else
	current = -1;
}

void
Cvo_GenericList::NewPage(Cvo_Page *p)
{
    //
    // Allow the user to specify a NULL page to get the
    // list to reevaluate itself. This allows, albeit
    // manually, more than one list to contribute to a page.
    //
    if (p != NULL && p != page) {
	if (page)
	    page->SetWindow(0);
	page = p;
	page->SetWindow(main);
	vertical->SetMaximum(page->NumberLines());
    }
    current = -1;
    EvaluateWidth();
    Cvo_GenericList_PageChanged(0, 0, this); 
}

void
Cvo_GenericList::Down(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    int x = 0, y = 0;
    for (Cvo_Object *w = main; w && w != this; w = w->Parent()) {
	int ox, oy;
	w->Origin(&ox, &oy);
	x -= ox;
	y -= oy;
    }

    switch (ev->type ) {
    case ButtonPress:
    case ButtonRelease:
	x += ev->xbutton.x;
	y += ev->xbutton.y;
	break;
    case KeyPress:
    case KeyRelease:
	x += ev->xkey.x;
	y += ev->xkey.y;
	break;
    default:
	CVO_VOID_RETURN
    }

    if (x < 0 || x > main->Width() ||
        y < 0 || y > main->Height()) {
	CVO_VOID_RETURN
    }
    
    int ny = 0;
    for (int nc = firstline; nc < lastline + (partialLine ? 1 : 0); ++nc) {
        ny += page->Height(nc) + 4;
        if (y <= ny) {
            if (!page->HandlePress(nc, x - 2 + xoffset,
				       page->Height(nc) - (ny - y - 2), ev)) {
    	        Select(nc, (ac > 1) ? atoi(av[1]) : 0, (ac > 0) ? atoi(av[0]) : 0);
	    } else {
		current = -1;
	    }
	    CVO_VOID_RETURN
	}
    }

    XBell(Dpy(), 0);
    CVO_VOID_RETURN
}

void
Cvo_GenericList::Select(int nc, int count, int button)
{   CVO_ENTER
    if (nc >= lines)
	CVO_VOID_RETURN

    // XXX should have code here to make the selection visible

    Cvo_ListItemSelectedEvent lise;
    lise.oldline = current;
    lise.count = count;

    if (nc != current) {
	current = nc;
    } else if (!radiostyle && count == 0) {
    	if (reselect)
	    lise.count++;
    	else
	    current = -1;
    } else if (count == 0) {
        if (!reselect)
            CVO_VOID_RETURN
        lise.count++;
    }
    Cvo_GenericList_PageChanged(0, 0, this); 

    lise.line = current;
    lise.item = page;
    lise.button = button;
    SendEvent(CvoListItemSelectedEvent, &lise);
    CVO_VOID_RETURN
}

void
Cvo_GenericList::Up(XEvent *, int, char **)
{   CVO_ENTER
    CVO_VOID_RETURN
}
