//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//
// This code was initially contributed by Dean Johnson
//
static void USMID() { void("%Z%%M%      %I%     %G% %U%"); }
static void RSCID() { void("$Id: HelpDisplay.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }

#include <ctype.h>
#include <Cvo/Types.h++>
#include <Cvo/Text.h++>
#include <Cvo/HelpDisplay.h++>
#include <Cvo/Inform.h++>

#define	CvoT__HelpDisplay		___mktype('H','e','l','p')

static void _Cvo_HelpDisplayNotify(Cvo_Object *, XEvent *, int, char **);
static void _Cvo_HelpDisplaySelection(Cvo_Object *, XEvent *, int, char **);
static void _Cvo_HelpDisplayScroll(Cvo_Object *, XEvent *, int, char **);
static void _Cvo_HelpDisplayDumpTable(Cvo_Object *, XEvent *, int, char **);

static Cvo_Default def[] = {
    "*CvoHelpDisplay*fontFamily: courier",

    "*CvoHelpDisplay*title_text.fontFamily:helvetica",
    "*CvoHelpDisplay*title_text.fontWeight:bold",
    "*CvoHelpDisplay*title_text.fontSize:16",
    "*CvoHelpDisplay*title_text.background:",

    "*CvoHelpDisplay*lotext.fontWeight:medium",
    "*CvoHelpDisplay*lotext.background:",

    "*CvoHelpDisplay*hitext.fontWeight:medium",
    "*CvoHelpDisplay*hitext.enbolden:true",
    "*CvoHelpDisplay*hitext.underline:true",
    "*CvoHelpDisplay*hitext.background:",

    "*Color*CvoHelpDisplay*hitext.foreground:DarkGreen",
};


static Cvo_ExtHandleFunction _f1("select-entry",  _Cvo_HelpDisplaySelection);
static Cvo_ExtHandleFunction _f2("select-notify", _Cvo_HelpDisplayNotify);
static Cvo_ExtHandleFunction _f3("scroll",	  _Cvo_HelpDisplayScroll);
static Cvo_ExtHandleFunction _f4("dump-table",	  _Cvo_HelpDisplayDumpTable);

static char trans[] = "\
    ~Shift <BtnDown>:select-entry() \n\
     Shift <Btn1Down>:select-start() \n\
     Shift <Btn1Motion>:select-extend() \n\
     Shift <Btn3Down>:start-extend() \n\
     Shift <Btn3Motion>:select-extend() \n\
     Shift <BtnUp>:select-end(PRIMARY, CUT_BUFFER0) select-notify() \n\
    ~Shift <Key>Space:scroll(down, 1, page) \n\
     Shift <Key>Space:scroll(up, 1, page) \n\
    ~Shift <Key>Return:scroll(down, 1, line) \n\
     Shift <Key>Return:scroll(up, 1, line) \n\
    ~Shift <Key>Linefeed:scroll(down, 1, line) \n\
     Shift <Key>Linefeed:scroll(up, 1, line) \n\
    ~Shift <Key>Enter:scroll(down, 1, line) \n\
     Shift <Key>Enter:scroll(up, 1, line) \n\
    ~Shift <Key>KP_Enter:scroll(down, 1, line) \n\
     Shift <Key>KP_Enter:scroll(up, 1, line) \n\
     Ctrl<Key>T: dump-table() \n\
";

CONSTRUCTORS(Cvo_HelpDisplay, Cvo_TextViewPort, "CvoHelpDisplay")

void
Cvo_HelpDisplay::_Init()
{
    type = CvoT__HelpDisplay;
    use_markup = True;
    RootDir = NULL;
    help = NULL;
    page = new Cvo_TextPage();
    page->SetWindow(text);
    ((Cvo_TextPage *) page)->SetAbsoluteMax(0);
    vertical->SetMaximum(page->NumberLines());
    text->AddTranslations(trans, XLATE_REPLACE);
    text->Register(CvoBindEvent, _Cvo_ObjectAddBinding, &_f1);
    text->Register(CvoBindEvent, _Cvo_ObjectAddBinding, &_f2);
    text->Register(CvoBindEvent, _Cvo_ObjectAddBinding, &_f3);
    text->Register(CvoBindEvent, _Cvo_ObjectAddBinding, &_f4);
    ExpandFrame();

    //
    //	Set up the text attributes
    //

    lotext     = text->NewTextAttribute("lotext");
    title_text = text->NewTextAttribute("title_text");
    hitext     = text->NewTextAttribute("hitext");
}

static void
_Cvo_HelpDisplayScroll(Cvo_Object *w, XEvent *, int ac, char **av)
{
    Cvo_HelpDisplay	*hd = (Cvo_HelpDisplay *)(w->Parent()->Parent());
    int amt = 1;


    if (ac > 1) {
	amt = atoi(av[1]);
	if (amt < 0)
	    amt = -amt;
	if (amt == 0)
	    amt = 1;
    }
    if (ac > 2) {
	if (tolower(av[2][0]) == 'p')
	    amt *= hd->text->Rows() - 1;
    }

    if (ac > 0) {
	if (tolower(av[0][0]) == 'u')
	    amt = -amt;
    }

    hd->GotoLine(hd->FirstLine() + amt);
}

static void
_Cvo_HelpDisplayNotify(Cvo_Object *w, XEvent *, int, char **)
{
    Cvo_HelpDisplay	*hd = (Cvo_HelpDisplay *)(w->Parent()->Parent());
    Cvo_HelpDisplaySelectionEvent hev;
    Cvo_CRT *text = (Cvo_CRT *) hd->text;

    if (!text->Selection()) return;
    text->Selection()->SelectionRange(&(hev.start_row),&(hev.start_column),
    			 &(hev.end_row),&(hev.end_column));
    hev.start_row += hd->FirstLine();
    hev.end_row   += hd->FirstLine();
    hd->SendEvent(CvoHelpSelectionEvent, &hev);
}

static void
_Cvo_HelpDisplaySelection(Cvo_Object *w, XEvent *ev, int, char **)
{
    Cvo_HelpDisplay	*hd = (Cvo_HelpDisplay *)(w->Parent()->Parent());
    XButtonEvent	*ce = (XButtonEvent *) ev;
    int	line, column;
    char	cmd[1024];

    if (hd->HelpData() == NULL)
        return;

    line = hd->text->FindLine(ev->xbutton.y);
    column = hd->text->FindColumn(line, ev->xbutton.x);
    line += hd->FirstLine();
    for (HelpItem *t = hd->HelpData()->Xref(); t != NULL; t = t->Next()) {
	if (line != t->Line())
	    continue;
	if (column < t->Column())
	    continue;
	if (column > t->Column() + t->Length())
	    continue;

	switch (t->Type()) {
	case HelpXref: 
	    (void) hd->ReadHelpFile(t->File(),t->Tag(),1);
	    break;
	case HelpExec: 
	    strcpy(cmd,t->Tag());
	    strcat(cmd," &");
	    system(cmd);
	    break;
	}
    }
}

void 
Cvo_HelpDisplay::ForceRedisplay()
{
    DontJump();

    //
    //	Add all the different marked up areas to the buffer.
    //

    TextPage()->ClearLines(0);
    TextPage()->DisableDisplay();
    TextPage()->AppendText(HelpData()->Buffer());

    //----------------------------------------------------------//
    //		Put stuff in the buffer				//
    //----------------------------------------------------------//

    for (HelpItem *tmp = HelpData()->Xref(); tmp != NULL; tmp = tmp->Next()) {
        if (tmp->Type() == HelpIndex) continue;
        if (tmp->Type() == HelpBookmark) continue;
        if (tmp->Type() == HelpGraphic) continue;
        if (tmp->Type() == HelpComment) continue;
        if (tmp->Type() == HelpHiddenTag) continue;
        TextPage()->SetAttributes(tmp->Line(), tmp->Column(),
    			      tmp->Column() + tmp->Length() - 1,
    			      (tmp->Type() == HelpTag) 
    				    ? title_text : hitext);
    }

    TextPage()->EnableDisplay();
}

int 
Cvo_HelpDisplay::ReadHelpFile(char *filename,char *tag,int history)
{
    char	new_filename[1024];
    HelpUnit	*tmp_help;
    Cvo_HelpDisplayEvent hev;
    BOOL local_version;	// absolute pathed, rather than root path relative
    BOOL load_done = True;

    if (!filename) 
	return(0);

    local_version = (*filename == '/' || *filename == '.') ? True : False;

    new_filename[0] = '\0';
    if (local_version) {
	strcpy(new_filename,filename);
    }
    else if (RootDir) {
	strcpy(new_filename,RootDir);
	strcat(new_filename,filename);
    }
    else {
        Cvo_Inform("cannot_read",this,"Unable to find help file \"%s\"!",
		   filename);
	return(0);
    }

    if (HelpData() && !strcmp(new_filename,HelpData()->FileName())) {
	load_done = False;
    }
    else {
	tmp_help = new HelpUnit(new_filename, use_markup);
	if (tmp_help->Length() < 0) {
	    Cvo_Inform("cannot_read",this,"Unable to read help file \"%s\"!",
		       filename);
	    return(0);
	}
	load_done = True;
    }

    if (load_done) {
	delete HelpData();
	SetHelpData(tmp_help);

	if (FirstLine() != 0 && tag == NULL) {
	    //
	    // We are not at the beginning of the file, set it back
	    // to zero.
	    //
	    //	XXX - is this needed
	    //
	    GotoLine(0);
	}

	ForceRedisplay();

	//
	// Send out an event that the tags list has possibly changed.
	//

	SendEvent(CvoHelpTagsEvent, &hev);
	SendEvent(CvoHelpTitleEvent, &hev);
    }

    //
    // Look through the tags list for the tag, if necessary
    //

    if (tag != NULL && *tag != '\0' && !GotoTag(tag)) {
	GotoLine(0);
    }

    //
    // Our file has likely changed, give the user an opportunity
    // to mark the spot for a history mechanism.
    //

    if (history) {
	hev.data = (void *) tag;
	SendEvent(CvoHelpHistoryEvent,&hev);
    }
    return(1);
}

int
Cvo_HelpDisplay::GotoTag(char *tag)
{
    HelpItem *tmp;

    if (!tag)
	return(0);
    char *tagptr = tag;
    while (*tagptr && *tagptr == '\t') tagptr++;
    if (!tagptr)
	return(0);
    for (tmp = HelpData()->Xref(); tmp != NULL; tmp = tmp->Next()) {
	if (tmp->Type() != HelpTag && tmp->Type() != HelpHiddenTag)
	    continue;
	char *tn = tmp->Tag();
	if (tn == NULL)
	    continue;
	while (*tn && *tn == '\t') tn++;
	if (!strcmp(tn,tag) || !strcmp(tn,tagptr)) {
	    GotoLine(tmp->Line());
	    return(1);
	}
    }
    Cvo_Inform("no_tag",this,"Unable to locate tag \"%s\" in file \"%s\"!",
	   	tag,HelpData()->FileName());
    return(0);
}

HelpMark *
Cvo_HelpDisplay::GetMark(char *tag)
{
    if (HelpData() == NULL)
	return(NULL);
    if (HelpData()->FileName() == NULL)
	return(NULL);
    return(new HelpMark(tag,HelpData()->FileName(),FirstLine()));
}

static void
_Cvo_HelpDisplayDumpTable(Cvo_Object *w, XEvent *, int, char **)
{
    Cvo_HelpDisplay	*hd = (Cvo_HelpDisplay *)(w->Parent()->Parent());
    hd->HelpData()->PrintTable();
}

HelpMark::HelpMark(char *t,char *fn,int n)
{
    if (t) {
        tag = new char[strlen(t) + 1];
        strcpy(tag,t);
    } else {
        tag = NULL;
    }
    if (fn) {
        filename = new char[strlen(fn) + 1];
        strcpy(filename,fn);
    } else {
        filename = NULL;
    }
    line = n;
    prev = next = NULL;
}
