//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: IconGroup.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/IconGroup.h++>

Cvo_IconGroup::~Cvo_IconGroup()
{
    while (group)
	delete group;
}

Cvo_IconGroupObject *
Cvo_IconGroup::AddObject(Cvo_Object *obj)
{
    return(new Cvo_IconGroupObject(this, obj));
}

Cvo_IconGroupObject::Cvo_IconGroupObject(Cvo_IconGroup *_root, Cvo_Object *obj)
{
    root = _root;
    object = obj;

    if (!root->group) {
	root->group = next = prev = this;
    } else {
	next = root->group;
	prev = root->group->prev;
	next->prev = this;
	prev->next = this;
    }

    xreg = obj->Register(CvoDestroyedEvent, Cvo_IconGroupObject::Destroyed, this);
    ireg = obj->Register(UnmapNotify, Cvo_IconGroupObject::Iconify, this);
    dreg = obj->Register(MapNotify, Cvo_IconGroupObject::Deiconify, this);
}

Cvo_IconGroupObject::~Cvo_IconGroupObject()
{
    delete xreg;
    delete ireg;
    delete dreg;

    if (next == prev)
	root->group = 0;
    else {
	if (this == root->group)
	    root->group = next;
	next->prev = prev;
	prev->next = next;
    }
}

void
Cvo_IconGroupObject::Destroyed(Cvo_Object *, XEvent *, void *data)
{
    Cvo_IconGroupObject *go = (Cvo_IconGroupObject *)data;
    
    delete go;
}

void
Cvo_IconGroupObject::Iconify(Cvo_Object *, XEvent *, void *data)
{
    Cvo_IconGroupObject *go = (Cvo_IconGroupObject *)data;
    Cvo_IconGroupObject *o;
    
    o = go->next;
    while (o != go) {
    	o->object->Unmap();
	o = o->next;
    }
}

void
Cvo_IconGroupObject::Deiconify(Cvo_Object *, XEvent *, void *data)
{
    Cvo_IconGroupObject *go = (Cvo_IconGroupObject *)data;
    Cvo_IconGroupObject *o;
    
    o = go->next;
    while (o != go) {
    	o->object->Map();
	o = o->next;
    }
}
