//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ImageButton.cc,v 1.4 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/ImageButton.h++>
#include <string.h>

static Cvo_Default def[] = {
    "*CvoImageButton.Cursor:Top Left Arrow",
    "*CvoImageButton.Pad:2",
};

CONSTRUCTORS_1ARG(Cvo_ImageButton, Cvo_BasicButton, "CvoImageButton", char *)
CONSTRUCTORS_1ARG(Cvo_ImageButton, Cvo_BasicButton, "CvoImageButton", Cvo_Image *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_ImageButton)


void
Cvo_ImageButton::_Init(Cvo_Image *ni)
{   CVO_ENTER
    type = CvoT_ImageButton;
    image = ni;
    image->ResetWindow(this);
    local = False;
    SetMaxPixelSize(image->Width(), image->Height());
    Register(Expose, &Cvo_ImageButton::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_ImageButton::_Init(char *filename)
{   CVO_ENTER
    type = CvoT_ImageButton;
    image = new Cvo_Image(this, filename);
    local = True;
    SetMaxPixelSize(image->Width(), image->Height());
    Register(Expose, &Cvo_ImageButton::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_ImageButton::SetImage(char *f)
{   CVO_ENTER
    Cvo_Image *ni = new Cvo_Image(this, f);
    if (ni->Loaded()) {
	if (local)
	    delete image;
	image = ni;
	local = True;
	SetMaxPixelSize(image->Width(), image->Height());
	if (Mapped())
	    Redraw();
    } else
	delete ni;
    CVO_VOID_RETURN
}

void
Cvo_ImageButton::SetImage(Cvo_Image *ni)
{   CVO_ENTER
    if (ni->Loaded()) {
	if (local)
	    delete image;
	image = ni;
	image->ResetWindow(this);
	local = False;
	SetMaxPixelSize(image->Width(), image->Height());
	if (Mapped())
	    Redraw();
    }
    CVO_VOID_RETURN
}

void
Cvo_ImageButton::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (!image)
	CVO_VOID_RETURN

    if (Sunken())
	image->Select();
    else
	image->UnSelect();
    image->Show(0, 0);
    CVO_VOID_RETURN
}
