//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: InputContext.cc,v 1.9 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/InputContext.h++>

#if	!defined(X11R4)

static Cvo_Default defs[] = {
	"*CvoPreEdit*Pad:0",
	"*CvoPreEdit*InternalPad:0",
	"*CvoPreEdit*LayoutPad:0",
};

CONSTRUCTORS_1ARG(Cvo_PreEditArea, Cvo_Window, "CvoPreEdit", Cvo_InputContext *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_PreEditArea)

void
Cvo_PreEditArea::_Init(Cvo_InputContext *cic)
{   CVO_ENTER
    Register(CvoResizeEvent, &Cvo_PreEditArea::NegotiateGeometry, cic);
    CVO_VOID_RETURN
}

void
Cvo_PreEditArea::NegotiateGeometry(XEvent *, void *vcic)
{   CVO_ENTER
    Cvo_InputContext *cic = (Cvo_InputContext *)vcic;

    if (cic->required) {
	cic->Initialize();
	CVO_VOID_RETURN
    }

    if (!cic->input_context) {
	CVO_VOID_RETURN
    }

    XVaNestedList plist;
    XVaNestedList slist;

    XRectangle prearea;
    XRectangle statarea;

    prearea.width = Width() - TextAttribute()->MWidth() * 10 - 3;
    prearea.height = Height() - 2;
    prearea.x = TextAttribute()->MWidth() * 10 + 1;
    prearea.y = 0;
    ToXCoord(&prearea.x, &prearea.y);

    statarea.width = TextAttribute()->MWidth() * 10;
    statarea.height = Height() - 2;
    statarea.x = 0;
    statarea.y = 0;
    ToXCoord(&statarea.x, &statarea.y);

    plist = XVaCreateNestedList(0, XNArea, &prearea, NULL);
    slist = XVaCreateNestedList(0, XNArea, &statarea, NULL);
    XSetICValues(cic->input_context, XNPreeditAttributes, plist, 0);
    XSetICValues(cic->input_context, XNStatusAttributes, slist, 0);
    XFree(_xfree_t plist);
    XFree(_xfree_t slist);
    CVO_VOID_RETURN
}

#endif

Cvo_InputContext::Cvo_InputContext(Cvo_Object *obj)
{   CVO_ENTER
    win = obj->ToWindow();
    focused = False;

#if	!defined(X11R4)
    input_context = 0;
    statusarea = 0;
    required = False;
#endif

    if (!win)
	CVO_VOID_RETURN

    win->SetFocus(win);

#if	!defined(X11R4)
    required = True;
    Initialize();
#endif
    CVO_VOID_RETURN
}

#if	!defined(X11R4)
void
Cvo_InputContext::Initialize()
{   CVO_ENTER
    XVaNestedList list;

    if (!required)
	CVO_VOID_RETURN

    if (!win->DisplayList()->InputMethod()) {
	required = False;
	CVO_VOID_RETURN
    }

    Cvo_Object *obj = win;
    while (obj && obj->Parent())
	obj = obj->Parent();

    Window cwin;

    if (win->DisplayList()->InputStyle() & (XIMPreeditArea|XIMStatusArea)) {
	if (!statusarea) {
	    statusarea = new Cvo_PreEditArea("preedit_area", obj, this);
	    if (obj->Children())
		statusarea->PlaceBefore(obj->Children());
	    statusarea->LayOpposite();
	}

	if (obj->Mapped())
	    statusarea->Map();
	else if (obj->Object())
	    statusarea->Create();

	cwin = statusarea->Object();
    } else {
	cwin = obj->Object();
    }

    if (!cwin)
	CVO_VOID_RETURN

    required = False;

    list = XVaCreateNestedList(0, XNFontSet,
			       win->TextAttribute()->Font()->Fontset(), NULL);

    input_context = XCreateIC(win->DisplayList()->InputMethod(),
			      XNInputStyle, win->DisplayList()->InputStyle(),
			      XNClientWindow, cwin,
			      XNPreeditAttributes, list,
			      XNStatusAttributes, list,
			      NULL);

    XFree(_xfree_t list);
    if (!input_context) {
        Cvo_Failure(CvoE_WARN,
                    CvoE_NOIC,
                    "Cannot create an input context for %s\n",
                    _Cvo_Base.Locale);
	CVO_VOID_RETURN
    }

    XGetICValues(input_context, XNFilterEvents, &selectMask, NULL);

    if (statusarea)
	statusarea->NegotiateGeometry(0, this);

    CVO_VOID_RETURN
}
#endif

BOOL
Cvo_InputContext::FocusInput(Cvo_Window *nwin)
{   CVO_ENTER
#if	defined(X11R4)
    focused = True;
    CVO_RETURN(True)
#else
    if (required)
	Initialize();
    if (input_context) {
	if (nwin && nwin != win) {
	    if (nwin->IsValid()) {
		win = nwin;
		XSetICValues(input_context, XNFocusWindow, win->Win(), NULL);
	    }
	} else if (!focused) {
	    if (win->IsValid()) {
		XSetICValues(input_context, XNFocusWindow, win->Win(), NULL);
	    }
	}
	if ((win->selectMask & selectMask) != selectMask) {
	    win->selectMask |= selectMask;
	    XSelectInput(win->Dpy(), win->Win(), win->selectMask);
	}
	XSetICFocus(input_context);
	focused = True;
	CVO_RETURN(True)
    }
    CVO_RETURN(False)
#endif
}

void
Cvo_InputContext::LoseFocus()
{
#if	defined(X11R4)
    focused = False;
#else
    if (input_context && focused) {
	XUnsetICFocus(input_context);
	focused = False;
    }
#endif
}

#if	!defined(X11R4)
CARD16
Cvo_PreEditArea::CalculateWidth()
{
    return(TextAttribute()->MWidth() * 20);
}

CARD16
Cvo_PreEditArea::CalculateHeight()
{
    return(TextAttribute()->MHeight()+6);
}
#endif

void
Cvo_Object::FocusInput()
{
    if (input_context)
	input_context->FocusInput(this->ToWindow());
}

void
Cvo_Object::LoseFocus()
{
    if (input_context)
	input_context->LoseFocus();
}

void
Cvo_Window::Outline()
{
    if (parent && !haveoutline) {
        horizontalPad += 1;
        verticalPad += 1;
        haveoutline = True;
        drawoutline = False;
    }   
}

void
Cvo_Window::NeedInputContext()
{
    Outline();
    Cvo_LayoutWindow::NeedInputContext();
}

void
Cvo_Object::NeedInputContext()
{   CVO_ENTER
    Cvo_Object *obj = this;

    SetFocus(this);

    if (input_context)
	CVO_VOID_RETURN

    while (obj && obj->Parent())
	obj = obj->Parent();
    if (obj->input_context)
	input_context = obj->input_context;
    else
	input_context = obj->input_context = new Cvo_InputContext(this);
    if (!obj->focus)
	obj->focus = this;
    CVO_VOID_RETURN
}

void
Cvo_Window::InitializeFocus()
{

    Cvo_LayoutWindow::InitializeFocus();

    if (Parent() && haveoutline) {
	Register(CvoFocusInEvent, &Cvo_Window::HandleFocusIn);
	Register(CvoFocusOutEvent, &Cvo_Window::HandleFocusOut);
    }
}

void
Cvo_Window::HandleFocusIn(XEvent *, void *)
{
    if (haveoutline) {
	drawoutline = True;
	_drawChamfer();
    }
}

void
Cvo_Window::HandleFocusOut(XEvent *, void *)
{
    if (haveoutline) {
	drawoutline = False;
	_drawChamfer();
    }
}

void
Cvo_Object::InitializeFocus()
{   CVO_ENTER
    if (!Parent()) {
	Register(EnterNotify, &Cvo_Object::RootEnterHandler);
	Register(LeaveNotify, &Cvo_Object::RootLeaveHandler);

	Register(FocusIn, &Cvo_Object::RootEnterHandler);
	Register(FocusOut, &Cvo_Object::RootLeaveHandler);
    }

    CVO_VOID_RETURN
}

void
Cvo_Object::RootEnterHandler(XEvent *ev, void *)
{
    if (!ClickToType()) {
	XFocusChangeEvent *fce = (XFocusChangeEvent *)ev;
    	if (ev->type == FocusIn && fce->detail == NotifyNonlinear) {
	    DisplayList()->MakeClickToType();
    	} else {
	    XCrossingEvent *cev = (XCrossingEvent *)ev;
	    if (cev->detail == NotifyInferior)
		return;
    	}
    } else if (ev->type != FocusIn)
	return;

    if (focus && focus->Object()) {
	focus->TakeFocus();
    } else
	focus = 0;
}

void
Cvo_Object::RootLeaveHandler(XEvent *ev, void *)
{
    if (!ClickToType()) {
	XCrossingEvent *cev = (XCrossingEvent *)ev;
	if (cev->detail == NotifyInferior)
	    return;
    } else if (ev->type != FocusOut)
	return;

    DisplayList()->OutFocus();
}

void
Cvo_Object::SetFocus(Cvo_Object *_focus)
{   CVO_ENTER
    Cvo_Lock lock;

    delete enterreg;

    if (Parent()) {
	int ev = ClickToType() ? ButtonPress : EnterNotify;

	// XXX -- what if _focus goes away?

	enterreg = Register(ev, &Cvo_Object::FocusInHandler, _focus);
	enterreg->MoveUp();
    }
    focus = _focus;

    CVO_VOID_RETURN
}

void
Cvo_Object::FocusInHandler(XEvent *ev, void *vobj)
{   CVO_ENTER
    Cvo_Object *obj = (Cvo_Object *)vobj;

    if (ClickToType() && ev->type == EnterNotify && !ev->xcrossing.focus)
	CVO_VOID_RETURN
    if (ev->type == FocusIn && ev->xfocus.detail == NotifyPointer)
	CVO_VOID_RETURN
    if (ev->type == FocusIn && ev->xfocus.detail == NotifyNonlinear)
	CVO_VOID_RETURN

    obj->TakeFocus();

    CVO_VOID_RETURN
}
