//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: Iwin.cc,v 1.10 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <X11/Xatom.h>
#include <Cvo/Window.h++>
#include <Cvo/Pixmap.h++>

#include <Cvo/Iwin.h++>
#include <Cvo/ViewPort.h++>

#include <math.h>


#define POINTER_MASK (unsigned int)(ButtonPressMask \
				    | ButtonReleaseMask \
				    | ExposureMask \
				    | FocusChangeMask \
				    | PointerMotionMask)

static Cvo_Default defs[] = {
    "*CvoIwin.Sunken:True",
};

char *trans = "\
            <Btn1Down>(2): execute-icons(primary) \n\
            <Btn2Down>(2): execute-icons(primary) \n\
            <Btn3Down>(2): execute-icons(secondary) \n\
      ~Shift<ButtonPress>(1): select-icons(select) \n\
       Shift<ButtonPress>(1): select-icons(append) \n\
	    <ButtonMotion>: move-icons() \n\
	    <ButtonRelease>: drop-icons() \n\
";

//	    <Key>o: iwinprocess(organize) \n\
//	    <Key>u: iwinprocess(up) \n\
//	    <Key>d: iwinprocess(down) \n\
//	    <Key>l: iwinprocess(left) \n\
//	    <Key>r: iwinprocess(right) \n\
//	    <Key>a: iwinprocess(reorganize) \n\
//	    <Key>z: iwinprocess(z) \n\

CONSTRUCTORS_1ARG(Cvo_Iwin, Cvo_Window, "CvoIwin", Cvo_ViewPort *)

CVO_BEGIN_BIND(Cvo_Iwin)
CVO_DOBIND(Cvo_Iwin, "execute-icons",  ExecuteIcons)
CVO_DOBIND(Cvo_Iwin, "select-icons",  SelectIcons)
CVO_DOBIND(Cvo_Iwin, "move-icons",  MoveIcons)
CVO_DOBIND(Cvo_Iwin, "drop-icons",  DropIcons)
CVO_DOBIND(Cvo_Iwin, "process",  Process)
CVO_END_BIND(Cvo_Iwin, Cvo_Window)

CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Iwin)

inline void
Cvo_Iwin::getgrid(Cvo_IwinItem *item, int &x, int &y)
{
    x -= offset.x;
    y -= offset.y;

    if (item) {
	x += item->W() / 2;
	y += item->H() / 2;
    } else {
	x += iwidth / 2;
	y += iheight / 2;
    }

    x /= iwidth;
    y /= iheight;
}

void 
Cvo_Iwin::_Init(Cvo_ViewPort *vp)
{
    unsigned long valuemask;
    XGCValues values;

    pixmap = 0;

    offset.x = offset.y = 20;
    next = offset;
    origin.x = 0;
    origin.y = 0;

    iwidth = 64 + offset.x;
    iheight = 64 + offset.y + FontHeight();

    useStagger = 0;
    
    output = True;

    dirty = False;
    realdirty = False;
    dirtypix = False;

    pretty = True;
    cute = False;

    moving = False;
    haveMoved = False;
    autoPlace = False;
    allowIntraMv = True;
    needResize = False;
    movingIcons = 0;
    moveCount = 0;
    offsets = 0;
    rects = 0;

    items = 0;
    selected = 0;
    selectedItems = 0;

    if (viewPort = vp) {
	viewPort->AddMain(this);
	viewPort->AddHorizontal();
	viewPort->AddVertical();

    	viewPort->Horizontal()->Register(CvoScrollBarEvent,
					&Cvo_Iwin::ScrollEvent, this);
    	viewPort->Vertical()->Register(CvoScrollBarEvent,
					&Cvo_Iwin::ScrollEvent, this);
    }

    valuemask = GCFunction | GCForeground | GCLineWidth | GCSubwindowMode;
    values.foreground = (((unsigned long) 1) << Depth()) - 1;
    values.function = GXxor;
    values.line_width = 0;
    values.subwindow_mode = IncludeInferiors;
    boxGC = XCreateGC(Dpy(), RootWindow(Dpy(), XScreen()), valuemask, &values);
    Register(CvoResizeEvent, &Cvo_Iwin::DoResizeEvent);

    AddTranslations(trans);
}

void
Cvo_Iwin::ScrollEvent(Cvo_Object *, XEvent *ev, void *vi)
{
    Cvo_Iwin *i = (Cvo_Iwin *)vi;
    Cvo_ScrollBarEvent *sbe = (Cvo_ScrollBarEvent *)ev;

    i->ScrollTo(i->viewPort->Horizontal()->GetCurrent(),
	        i->viewPort->Vertical()->GetCurrent());
}

void
Cvo_Iwin::_Create()
{
    if (Object()) 
	return;
    Cvo_Window::_Create();

    pixmap = new Cvo_Pixmap(this, Width(), Height());


    if (autoPlace == True) {
	Organize();
    } else {
	RecalcSize();
	Redisplay();
    }

    dirty = True;

    if (viewPort && pixmap) {
	viewPort->Horizontal()->SetValues(0, pixmap->Width(), origin.x, Width());
	viewPort->Vertical()->SetValues(0, pixmap->Height(), origin.y, Height());
    }
}

CARD16
Cvo_Iwin::CalculateWidth()
{
    if (!viewPort && pixmap)
	return(pixmap->Width());
    else
	return(iwidth);
}

CARD16
Cvo_Iwin::CalculateHeight()
{
    if (!viewPort && pixmap)
	return(pixmap->Height());
    else
	return(iheight);
}

void
Cvo_Iwin::Exposure(XExposeEvent *ev)
{
    int ex = dirtypix ? 0 : ev->x;
    int ey = dirtypix ? 0 : ev->y;
    int ew = dirtypix ? width : ev->width;
    int eh = dirtypix ? height : ev->height;

    dirtypix = False;

    if (ex < 0) {
        ew += ex;
        ex = 0;
    }
    if (ey < 0) {
        eh += ey;
        ey = 0;
    }

    if (ew > 0 && eh > 0) {
        pixmap->CopyAreaTo(this, ex + origin.x, ey + origin.y, ew, eh, ex, ey);
    }

    Cvo_Window::Exposure(ev);
}
void
Cvo_Iwin::Flush(int r)
{
    if (dirtypix && pixmap) {
        pixmap->CopyAreaTo(this, origin.x, origin.y, width, height, 0, 0);
        dirtypix = False;
    }
    Cvo_Window::Flush(r);
}

void
Cvo_Iwin::ScrollTo(int x, int y)
{
    if (!pixmap)
	return;
    if (x + Width() > pixmap->Width())
	x = pixmap->Width() - Width();

    if (y + Height() > pixmap->Height())
	y = pixmap->Height() - Height();

    if (x < 0)
	x = 0;
    if (y < 0)
	y = 0;
    if (x == origin.x && y == origin.y)
	return;
    pixmap->CopyAreaTo(this, origin.x = x, origin.y = y, Width(), Height(), 0, 0);
    dirtypix = False;
}

void 
Cvo_Iwin::SelectIcons(XEvent *bev, int ac, char **av)
{
    Cvo_IwinItem *item;

    BOOL o = DisableOutput();

    if (ac < 1 || strcasecmp("append", av[0])) {
	dirty = True;
	UnselectAll();
    }

    if ((item = LocateIcon(bev->xbutton.x + origin.x,
			   bev->xbutton.y + origin.y)) == NULL) {
	SelectionBox(bev);
	UngrabPointer();
	EnableOutput(o);
	return;
    }

    if (!item->selected) {
	item->Select();
	dirty = True;
	EvalSelected();
    }
    InitMove(bev->xbutton.x + origin.x, bev->xbutton.y + origin.y);
    EnableOutput(o);
}

void 
Cvo_Iwin::ExecuteIcons(XEvent *bev, int ac, char **av)
{
    Cvo_IwinItem *item;

    if ((item = LocateIcon(bev->xbutton.x + origin.x,
			   bev->xbutton.y + origin.y)) == NULL)
	return;

    int request = CvoIwinPrimaryEvent;

    if (ac > 0) {
	 if (!strcasecmp("primary", av[0]))
	    request = CvoIwinPrimaryEvent;
	 else if (!strcasecmp("secondary", av[0]))
	    request = CvoIwinSecondaryEvent;
    }

    Cvo_IwinEvent iev;

    iev.item = item;
    iev.client_data = item->Data();

    SendEvent(request, &iev);

    if (Selected()) {
	BOOL o = DisableOutput();
        dirty = True;
        UnselectAll();
	EnableOutput(o);
    }
}

void 
Cvo_Iwin::Process(XEvent *, int, char **av)
{
    if (!av[0])
	return;
    else if (!strcasecmp(av[0], "organize"))
	Organize();
    else if (!strcasecmp(av[0], "reorganize"))
	ReOrganize();
    else if (!strcasecmp(av[0], "up"))
	ScrollTo(origin.x, origin.y + 20);
    else if (!strcasecmp(av[0], "down"))
	ScrollTo(origin.x, origin.y - 20);
    else if (!strcasecmp(av[0], "left"))
	ScrollTo(origin.x + 20, origin.y);
    else if (!strcasecmp(av[0], "right"))
	ScrollTo(origin.x - 20, origin.y);
}

void 
Cvo_Iwin::DropIcons(XEvent *bev, int, char **)
{
    Window root_window = DefaultRootWindow(Dpy());

    BOOL o = DisableOutput();

    if (Selected() <= 0) {
	fprintf(stderr, "Box: No Items Selected in Window!\n");
	EndMove();
	UngrabPointer();
	EnableOutput(o);
	return;		// No items where selected
    }

    Window twin = DefaultRootWindow(Dpy());
    Window child;
    int dx, dy;
    int rx, ry;

    dx = bev->xbutton.x_root;
    dy = bev->xbutton.y_root;

    Window current = twin;
    do {
	XTranslateCoordinates(Dpy(), twin, current,
			      dx, dy, &rx, &ry, &child);
	dx = rx;
	dy = ry;
	twin = current;
	current = child; 
    } while (current != None);

    if (twin == (Window) NULL) {
	EndMove();
	EnableOutput(o);
	return;		// No window to drop to
    }

    if (twin == Win()) {
	if (allowIntraMv == False) {
	    EndMove();
	    EnableOutput(o);
	    return;
	}
	    
	//
	// Released in the same window, just move the icon(s).
	//
	Cvo_IwinItem *item;

	Cvo_IwinItem **ivec = selectedItems;

    	pretty = False;
    	cute = False;
	ToXCoord(&bev->xbutton.x, &bev->xbutton.y);
	for (int i=0; item = *ivec++; i++) {
    	    SetLocation(item, bev->xbutton.x - offsets[i].x + origin.x,
	    		      bev->xbutton.y - offsets[i].y + origin.y);
    	    item->Unlink((Cvo_RootedList **)&items);
    	    item->Insert((Cvo_RootedList **)&items, &Cvo_IwinItem::Prepend);
	}
	
	RecalcSize();
    } else {
	Cvo_IwinDropEvent imev;

        imev.selections = selectedItems;
        imev.count = selected;
        imev.refx = bev->xbutton.x_root + origin.x;
        imev.refy = bev->xbutton.y_root + origin.y;
        imev.offx = offsets[0].x;
        imev.offy = offsets[0].y;
        imev.time = bev->xbutton.time;
        SendEvent(CvoIwinDropEvent, &imev);
    }

    EndMove();
    EnableOutput(o);

    dirty = True;
    realdirty = True;

    Redisplay();
}

void
Cvo_Iwin::InitMove(int x, int y)
{
    moving = True;
    haveMoved = False;

    movingIcons = SelectedInWindow(&moveCount);

    if (!movingIcons)
	return;

    offsets = new XPoint[moveCount];
    rects = new XRectangle[2 * moveCount];

    ToXCoord(&x, &y);

    for (int i = 0; i < moveCount; i++) {
	//
	// locate the <x, y> of the widget.
	// 
	offsets[i].x = x - movingIcons[i]->X();
	offsets[i].y = y - movingIcons[i]->Y();
    }
}

void 
Cvo_Iwin::MoveIcons(XEvent *bev, int, char **)
{
    if (!moving)
	return;

    int nrects = haveMoved ? moveCount : 0;
    XEvent rep;

    while (XCheckTypedEvent(Dpy(), MotionNotify, &rep)) {
	FromXCoord(&rep.xmotion.x, &rep.xmotion.y);
	bev = &rep;
    }

    for (int i = 0; i < moveCount; i++) {
	rects[nrects].x = bev->xbutton.x_root - offsets[i].x;
	rects[nrects].y = bev->xbutton.y_root - offsets[i].y;
	rects[nrects].width = movingIcons[i]->W();
	rects[nrects].height = movingIcons[i]->H();
	nrects++;
    }

    DrawRectangles(DefaultRootWindow(Dpy()), BoxGC(), rects, nrects);

    if (haveMoved) {
	for (i = 0; i < moveCount; i++)
	    rects[i] = rects[i+moveCount];
    }
    haveMoved = True;
}

void
Cvo_Iwin::EndMove()
{
    if (!moving || movingIcons == 0) {
	moving = False;
	movingIcons = 0;
	return;
    }

    if (haveMoved)
	DrawRectangles(DefaultRootWindow(Dpy()), BoxGC(), rects, moveCount);

    delete [] movingIcons;
    delete [] offsets;
    delete [] rects;
    moveCount = 0;
    movingIcons = 0;
    offsets = 0;
    rects = 0;
    haveMoved = False;
}

void
Cvo_Iwin::Redisplay()
{
    if (!pixmap || !output)
	return;

    if (dirty) {
	if (realdirty)
	    pixmap->ClearWindow();
	    
    	if (items) {
	    Cvo_IwinItem *item = items->Prev();
    	    do {
		DisplayIcon(item, realdirty);
    	    } while ((item = item->Prev()) != items->Prev());
    	}

	dirty = False;
	realdirty = False;
    }

    if (dirtypix && Mapped()) {
        pixmap->CopyAreaTo(this, origin.x, origin.y, width, height, 0, 0);
	dirtypix = False;
    }
}

void
Cvo_Iwin::RecalcSize()
{
    int minx, miny;
    int maxx, maxy;

    if (!items)
	return;

    maxx = minx = items->X();
    maxy = miny = items->Y();

    for (Cvo_IwinItem *item = items; item; item = item->Next()) {
	int x, y, nx, ny, w, h, nw, nh;

    	x = item->X();
    	nx = item->NX();
    	y = item->Y();
    	ny = item->NY();
    	w = item->W();
    	nw = item->NW();
    	h = item->H();
    	nh = item->NH();

    	if (x + w > nx + nw)
	    w = x + w;
    	else
	    w = nx + nw;
	if (nx < x)
	    x = nx;

    	if (y + h > ny + nh)
	    h = y + h;
    	else
	    h = ny + nh;
	if (ny < y)
	    y = ny;

    	if (!viewPort && pixmap) {
	    int moved = 0;
	    if (x < 0) {
		dirty = realdirty = True;
		x = item->X() - x;
		moved = 1;
    	    } else if (w > pixmap->Width()) {
		dirty = realdirty = True;
		x = item->X() - (w - pixmap->Width());
		maxx = pixmap->Width();
		moved = 1;
    	    } else
	    	x = item->X();

	    if (y < 0) {
		dirty = realdirty = True;
		y = item->Y() - y;
		moved = 1;
    	    } else if (h > pixmap->Height()) {
		dirty = realdirty = True;
		y = item->Y() - (h - pixmap->Height());
		maxy = pixmap->Height();
		moved = 1;
    	    } else
		y = item->Y();

    	    if (moved)
		SetLocation(item, x, y);
    	} else if (pixmap) {
	    if (minx > x)
		minx = x;

	    if (miny > y)
		miny = y;

	    if (maxx < w)
		maxx = w;

	    if (maxy < h)
		maxy = h;
    	}
    }

    if (viewPort) {
	if (minx > offset.x)
	    minx -= offset.x;

	if (miny > offset.y)
	    miny -= offset.y;

	if (minx < 0 || minx > offset.x || miny < 0 || miny > offset.y) {
	    realdirty = True;
	    dirty = True;

	    if (minx < 0 || minx > offset.x)
		origin.x -= minx;
	    if (miny < 0 || miny > offset.y)
		origin.y -= miny;

	    for (Cvo_IwinItem *item = items; item; item = item->Next()) {
		int x = item->X();
		int y = item->Y();

		if (minx < 0 || minx > offset.x)
		    x -= minx;
		if (miny < 0 || miny > offset.y)
	    	    y -= miny;
		SetLocation(item, x, y);
	    }
	    if (minx < 0 || minx > offset.x)
		maxx -= minx;

	    if (miny < 0 || miny > offset.y)
		maxy -= miny;
	}

	if (pixmap && (maxx != pixmap->Width() || maxy != pixmap->Height())) {
	    nwidth = maxx;
	    nheight = maxy;

	    DoResize();
	}
    }
}

void
Cvo_Iwin::DoResize()
{
    if (output) {
	if (pixmap) {
	    pixmap->Resize(nwidth, nheight);
	    if (dirty)
		Redisplay();
	    if (viewPort && pixmap) {
		viewPort->Horizontal()->SetValues(0, pixmap->Width(), origin.x, Width());
		viewPort->Vertical()->SetValues(0, pixmap->Height(), origin.y, Height());
	    }
	    needResize = False;
    	}
    } else {
	needResize = True;
    }
}

void
Cvo_Iwin::DoResizeEvent(XEvent *ev, void *)
{
    Cvo_ResizeEvent *re = (Cvo_ResizeEvent *)ev;

    if (pixmap && (pixmap->Width() < Width() || pixmap->Height() < Height()))
	pixmap->Resize(pixmap->Width() < Width() ? Width()
						 : pixmap->Width(),
	               pixmap->Height() < Height() ? Height()
						   : pixmap->Height());
    if (viewPort && pixmap) {
    	viewPort->Horizontal()->SetValues(0, pixmap->Width(), origin.x, Width());
    	viewPort->Vertical()->SetValues(0, pixmap->Height(), origin.y, Height());
    }
    if (autoPlace)
	Organize();
    Redisplay();
}

Cvo_IwinItem *
Cvo_Iwin::LocateIcon(int dx, int dy)
{
    for (Cvo_IwinItem *item = items; item; item = item->Next()) {
	if (item->IntersectP(dx, dy))
	    return(item);
    }
    return(NULL);
}

Cvo_IwinItem **
Cvo_Iwin::SelectedInWindow(int *cnt)
{
    Cvo_IwinItem **nvec;
    Cvo_IwinItem **vec;
    Cvo_IwinItem **ivec = selectedItems;

    vec = nvec = new Cvo_IwinItem *[selected + 1];

    if (ivec) {
	Cvo_IwinItem *item;

	while (item = *ivec++) {
	    if (item->IntersectP(origin.x, origin.y, Width() + origin.x, Height() + origin.y)) {
		*vec++ = item;
    		++*cnt;
	    }
	}
    }

    *vec = 0;
    return(nvec);
}

void 
Cvo_Iwin::SelectionBox(XEvent *bev)
{
    XEvent rep;
    Window root_window = Win();
    XRectangle rects[4];
    int nrects = 0;
    int anc_x;
    int anc_y;

    GrabPointer(PointerMotionMask);

    anc_x = bev->xbutton.x;
    anc_y = bev->xbutton.y;
    nrects = 0;
    for (;;) {
	XMaskEvent(Dpy(), POINTER_MASK, &rep);
	switch(rep.type) {
	case ButtonRelease: {
	    DrawRectangles(root_window, BoxGC(), rects, nrects);
	    UngrabPointer();

	    int tx = rep.xbutton.x;
	    int ty = rep.xbutton.y;

	    if (tx < 0)
		tx = 0;
	    else if (tx >= width)
		tx = width - 1;

	    if (ty < 0)
		ty = 0;
	    else if (ty >= height)
		ty = height - 1;

	    SelectInBox(anc_x + origin.x, anc_y + origin.x,
			tx + origin.x, ty + origin.x);
	    return;
	  }
	case MotionNotify:
	    while (XCheckTypedEvent(Dpy(), MotionNotify, &rep))
		;
	    //
	    // do new window
	    //
	    if (rep.xbutton.x < anc_x) {
		rects[nrects].x = rep.xbutton.x;
		rects[nrects].width = anc_x - rep.xbutton.x;
	    } else {
		rects[nrects].x = anc_x;
		rects[nrects].width = rep.xbutton.x - anc_x;
	    }
	    if (rep.xbutton.y < anc_y) {
		rects[nrects].y = rep.xbutton.y;
		rects[nrects].height = anc_y - rep.xbutton.y;
	    } else {
		rects[nrects].y = anc_y;
		rects[nrects].height = rep.xbutton.y - anc_y;
	    }
	    nrects++;
	    //
	    // Do it!
	    //
	    DrawRectangles(root_window, BoxGC(), rects, nrects);
	    rects[0].x = rects[nrects-1].x;
	    rects[0].y = rects[nrects-1].y;
	    rects[0].width = rects[nrects-1].width;
	    rects[0].height = rects[nrects-1].height;
	    nrects = 1;
	    break;
	default:
	    _Cvo_event(&rep);
	    break;
	}
    }
}

Cvo_IwinItem * 
Cvo_Iwin::AddIcon(char *name, int x, int y,
		  Cvo_Image *p, Cvo_Image *s, Pixmap m, void *cd, int orient)
{
    Cvo_IwinItem *item = new Cvo_IwinItem(&items, name, cd, orient);

    item->namewidth = StringWidth(item->Tag());
    item->nameheight = FontHeight();

    item->primary = p;
    item->secondary = s;
    item->mask = m;

    item->namewidth = StringWidth(name);

    if (x != Cvo_IwinTooBig && y != Cvo_IwinTooBig) {
	SetLocation(item, x, y);
    } else {
	Organize(item);
    }

    dirty = True;

    item->displayed = False;

    DisplayIcon(item, 1);
	
    RecalcSize();
    Redisplay();
    return(item);
}

void 
Cvo_Iwin::DisplayIcon(Cvo_IwinItem *icon, int clean)
{
    if (!pixmap) {
	icon->displayed = False;
	return;
    }

    if (clean)
	icon->displayed = False;
    else if (icon->displayed && icon->selected == icon->highlighed)
	return;

    icon->displayed = True;
    dirtypix = True;

    if (!clean && icon->highlighed == True) {
	pixmap->ClearArea(icon->X(), icon->Y(), icon->W(), icon->H());
    }

    icon->highlighed = icon->selected;

    if (icon->highlighed == False && icon->mask) {
	pixmap->SetClipMask(icon->mask);
	pixmap->SetClipOrigin(icon->X(), icon->Y());
    } 

    Pixmap pm;

    if (icon->highlighed) {
    	if (icon->secondary) {
	    pm = icon->secondary->GetPixmap(pixmap->Depth());
    	} else {
	    icon->primary->Select();
	    pm = icon->primary->GetPixmap(pixmap->Depth());
    	}
    } else {
	icon->primary->UnSelect();
	pm = icon->primary->GetPixmap(pixmap->Depth());
    }

    pixmap->CopyInPixmap(pm, icon->X(), icon->Y(), icon->W(), icon->H());

    if (icon->highlighed == False && icon->mask)
	pixmap->SetClipMask(None);

    int xpos, ypos;

    xpos = icon->NX();
    ypos = icon->NY();

    if (icon->orientation == Cvo_VERTICAL)
	ypos += 1;
    else
	ypos += 5;

    pixmap->DrawString(xpos, ypos, icon->Tag());
}

#define	dPW	(pixmap ? pixmap->Width() : layout.desired.width \
					  ? layout.desired.width : 250)

void
Cvo_Iwin::Organize(Cvo_IwinItem *icon)
{
    icon->displayed = False;
    dirty = realdirty = True;

    if (pretty) {
    	int x = next.x;
    	int y = next.y;

    	getgrid(icon, x, y);

    	next.x = x * iwidth + offset.x;
    	next.y = y * iheight + offset.y;

    	if (next.x > offset.x && next.x + icon->FW() > dPW) {
    	    next.x = offset.x;
    	    next.y += iheight;

    	}

	SetLocation(icon, next.x, next.y + (useStagger & x) * FontHeight());
    	next.x += iwidth;
	return;
    }

    int x = icon->X();
    int y = icon->Y();

    getgrid(icon, x, y);

    SetLocation(icon, x * iwidth + offset.x,
    		      y * iheight + offset.y + (useStagger & x) * FontHeight());

    Cvo_IwinItem *item = items;

    while (item) {
	if (item == icon)
	    break;
    	if (item->Collide(*icon)) {
	    if (!cute) {
		cute = True;
	    	next = offset;
    	    }
	    x = next.x;
	    y = next.y;

	    getgrid(icon, x, y);

    	    next.x = x * iwidth + offset.x;
    	    next.y = y * iheight + offset.y;

    	    SetLocation(icon, next.x, next.y + (useStagger & x) * FontHeight());

    	    if (pixmap && (next.x += iwidth) + icon->FW() > dPW) {
	    	next.y += iheight;
		next.x = offset.x;
    	    }
	    item = items;
	} else
	    item = item->Next();
    }
}

void
Cvo_Iwin::Organize()
{
    pretty = True;
    next = offset;

    Cvo_RootedList_Sort((Cvo_RootedList **)&items, &Cvo_IwinItem::Sort);
    for (Cvo_IwinItem *item = items; item; item = item->Next())
	Organize(item);
    RecalcSize();
    Redisplay();
}

void
Cvo_Iwin::ReOrganize()
{
    pretty = False;

    Cvo_RootedList_Sort((Cvo_RootedList **)&items, &Cvo_IwinItem::Sort);
    for (Cvo_IwinItem *item = items; item; item = item->Next())
	Organize(item);
    RecalcSize();
    Redisplay();
}

void
Cvo_Iwin::Reset()
{
    BOOL o = DisableOutput();

    while (items)
	delete items;

    if (pixmap) {
	pixmap->Resize(Width(), Height());
	pixmap->ClearWindow();
    }

    dirty = True;
    realdirty = True;
    dirtypix = True;
    pretty = True;
    cute = False;

    selected = 0;

    next = offset;
    origin.x = 0;
    origin.y = 0;

    EnableOutput(o);
}

void
Cvo_Iwin::DrawRectangles(Window win, GC gc, XRectangle *rects, int nrects)
{
    int i;

    if (nrects > 0) {
	for (i = 0; i < nrects; i++)
	    ToXCoord(&rects[i].x, &rects[i].y);

	XDrawRectangles(Dpy(), win, gc, rects, nrects);

	for (i = 0; i < nrects; i++)
	    FromXCoord(&rects[i].x, &rects[i].y);
    }
}

int
Cvo_Iwin::FontHeight()
{
    return(pixmap ? pixmap->TextAttribute()->MHeight()	
		  : TextAttribute()->MHeight());
}

void
Cvo_Iwin::SelectAll()
{
    BOOL o = DisableOutput();
    selected = 0;
    for (Cvo_IwinItem *i = items; i; i = i->Next()) {
	dirty = True;
	i->Select();
	selected++;
    }
    EnableOutput(o);
}

void
Cvo_Iwin::UnselectAll()
{
    BOOL o = DisableOutput();
    selected = 0;

    for (Cvo_IwinItem *i = items; i; i = i->Next()) {
	if (i->selected) {
	    i->Unselect();
	    dirty = True;
	}
    }
    BuildSelectionList();
    EnableOutput(o);
}

void
Cvo_Iwin::EvalSelected()
{
    BOOL o = DisableOutput();
    selected = 0;

    for (Cvo_IwinItem *i = items; i; i = i->Next())
	if (i->selected)
	    selected++;
    BuildSelectionList();
    EnableOutput(o);
}

void
Cvo_Iwin::SelectByTag(char *tag)
{
    BOOL o = DisableOutput();
    for (Cvo_IwinItem *i = items; i; i = i->Next()) {
	if (!strcmp(tag, i->Tag())) {
	    if (!i->selected) {
		selected++;
		i->Select();
		dirty = True;
	    }
	}
    }
    BuildSelectionList();
    EnableOutput(o);
}

void
Cvo_Iwin::SelectInBox(int x1, int y1, int x2, int y2)
{
    BOOL o = DisableOutput();
    for (Cvo_IwinItem *item = items; item; item = item->Next()) {
	if (item->IntersectP(x1 + origin.x, y1 + origin.y, x2 + origin.x, y2 + origin.y)) {
	    if (!item->selected) {
		item->Select();
		dirty = True;
		selected++;
	    }
	}
    }
    BuildSelectionList();
    EnableOutput(o);
}

void
Cvo_Iwin::BuildSelectionList()
{
    delete [] selectedItems;
    selectedItems = 0;
    int j = 0;

    if (selected < 1)
	return;
    selectedItems = new Cvo_IwinItem * [selected + 1];

    for (Cvo_IwinItem *i = items; i; i = i->Next())
	if (i->selected) {
	    if (j == selected) {
		fprintf(stderr, "Overwrote selectedItems array\n");
		abort();
	    }
	    selectedItems[j++] = i;
	}
    selectedItems[j] = 0;
}

int
Cvo_IwinItem::Sort(Cvo_RootedList *r1, Cvo_RootedList *r2)
{
    Cvo_IwinItem *i1 = (Cvo_IwinItem *)r1;
    Cvo_IwinItem *i2 = (Cvo_IwinItem *)r2;

    if (i1->location < i2->location)
	return(-1);
    if (i1->location > i2->location)
	return(1);
    if (i1->x < i2->x)
	return(-1);
    if (i1->x > i2->x)
	return(1);
    if (i1->y < i2->y)
	return(-1);
    if (i1->y > i2->y)
	return(1);
    return(0);
}

int
Cvo_IwinItem::Prepend(Cvo_RootedList *, Cvo_RootedList *)
{
    return(-1);
}

Cvo_IwinItem::Cvo_IwinItem(Cvo_IwinItem **r, char *name, void *cd, int orient)
	    : Cvo_RootedList((Cvo_RootedList **)r)
{
    root = r;

    next = NULL;

    tag = 0;
    SetTag(name);
    SetX(Cvo_IwinTooBig);
    SetY(Cvo_IwinTooBig);
    SetLocation(0);

    orientation = orient;
    highlighed = False;
    displayed = False;
    selected = False;
    client_data = cd;
}

Cvo_IwinItem::~Cvo_IwinItem()
{
    delete [] tag;
    Unlink((Cvo_RootedList **)root);
}

BOOL
Cvo_IwinItem::Collide(Cvo_IwinItem &other)
{
#if full_check
    return (IntersectP(other.X(), other.Y(),
		       other.X() + other.W(), other.Y() + other.H()) ||
            IntersectN(other.X(), other.Y(),
		       other.X() + other.W(), other.Y() + other.H()) ||
            IntersectP(other.NX(), other.NY(),
		       other.NX() + other.NW(), other.NY() + other.NH()) ||
            IntersectN(other.NX(), other.NY(),
		       other.NX() + other.NW(), other.NY() + other.NH()));
#else
    return (IntersectP(other.X(), other.Y(),
		       other.X() + other.W(), other.Y() + other.H()));
#endif
}

int
Cvo_IwinItem::IntersectP(int x1, int y1, int x2, int y2)
{
    if (x1 > x2) {
	int t = x1;
	x1 = x2;
	x2 = t;
    }
    if (y1 > y2) {
	int t = y1;
	y1 = y2;
	y2 = t;
    }

    int x = X();
    int y = Y();
    int ex = x + W();
    int ey = y + H();
    
    return((((x >= x1 && x <= x2) || (ex >= x1 && ex <= x2)) &&
	    ((y >= y1 && y <= y2) || (ey >= y1 && ey <= y2))) ||
    	   (((x1 >= x && x1 <= ex) || (x2 >= x && x2 <= ex)) &&
    	    ((y1 >= y && y1 <= ey) || (y2 >= y && y2 <= ey))));
}

int
Cvo_IwinItem::IntersectN(int x1, int y1, int x2, int y2)
{
    if (x1 > x2) {
	int t = x1;
	x1 = x2;
	x2 = t;
    }
    if (y1 > y2) {
	int t = y1;
	y1 = y2;
	y2 = t;
    }

    int x = NX();
    int y = NY();
    int ex = x + NW();
    int ey = y + NH();

    if (orientation == Cvo_VERTICAL)
	ey += 1;
    else
	ex += 5;
    
    return((((x >= x1 && x <= x2) || (ex >= x1 && ex <= x2)) &&
	    ((y >= y1 && y <= y2) || (ey >= y1 && ey <= y2))) ||
    	   (((x1 >= x && x1 <= ex) || (x2 >= x && x2 <= ex)) &&
    	    ((y1 >= y && y1 <= ey) || (y2 >= y && y2 <= ey))));
}

void
Cvo_IwinItem::SetTag(char *t)
{
    delete [] tag;
    tag = new char[strlen(t) + 1];
    strcpy(tag, t);
}

#if defined(__IRIX_IS_BRAINDEAD__)
void
Cvo_Iwin::EnableOutput(BOOL o)
{
    if (output = o) {
	if (needResize)
	    DoResize(); 
	else if (dirty)
	    Redisplay();
    }
}
#endif
