//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: MenuEntry.cc,v 1.9 1994/09/27 18:41:00 prb Exp $"); }
#include <Cvo/Menu.h++>
#include <Cvo/MenuLabel.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Application.h++>

static void
callme(Cvo_Object *, XEvent *, void *vm)
{
    ((Cvo_MenuEntry *)vm)->Select();
}

static void
dome(Cvo_Object *, XEvent *, void *vm)
{
    ((Cvo_MenuEntry *)vm)->Call();
}

Cvo_MenuEntry::Cvo_MenuEntry(Cvo_Menu *m, Cvo_MenuItem *mi,
				   Cvo_MenuEntry *p)
{
    if (mi->flags & CvoM_SEPARATOR) {
	if (!mi->resource) {
	    _Init(m, new Cvo_Separator(m), p, 0, 0, mi->flags);
	    mi->entry = this;
	    return;
	}
	new Cvo_MenuEntry(m, new Cvo_Separator(m), p, CvoM_SEPARATOR);
    }

    _Init(m, new Cvo_MenuLabel(mi->resource, m, mi->resource, mi->flags),
				    p, mi->func, mi->data,
	  (mi->flags & ~CvoM_SEPARATOR) | CvoM_MENU_LABEL);

    wchar_t *a = ((Cvo_MenuLabel *)label)->QuickKey();
    KeyCode key;
    CARD state;

    if (a && Cvo_ParseAccelerator(label, a, key, state))
	label->DisplayList()->AddAccelerator(label, key, state, dome, this);
    mi->entry = this;
}

void
Cvo_MenuEntry::_Init(Cvo_Menu *m, Cvo_Window *w, Cvo_MenuEntry *p,
		       Cvo_MenuFunc f, void *d, int F)
{
    if (!m)
	Cvo_Failure(CvoE_FATAL, CvoE_BADMENU,
		    "Bad menu in menu item creation\n");

    if (this->next = p) {
	if (!p->menu || p->menu != m)
	    Cvo_Failure(CvoE_FATAL, CvoE_BADPREV,
			"Bad menu item passed to menu item creation\n");
	w->PlaceBefore(p->label);
	if (this->prev = p->prev)
	    this->prev->next = this;
	p->prev = this;

	if (p == m->items) {
	    m->items = this;
    	} else {
	    
    	}
    } else if (!(p = m->items)) {
	this->prev = 0;
	m->items = this;
    } else {
	while (p->next)
	    p = p->next;
	p->next = this;
	this->prev = p;
    }
    this->menu = m;
    this->label = w;
    this->data = d;
    this->func = f;
    this->ifunc = 0;
    this->flags = F;
    this->cascade = 0;
    m->InsertItem(label, F);
    label->Register(CvoMenuDoCascadeEvent, callme, this);

    Cvo_NewMenuItemEvent nmie;
    nmie.item = this;
    m->SendEvent(CvoNewMenuItemEvent, &nmie);
}

Cvo_MenuEntry::~Cvo_MenuEntry()
{
    Cvo_NewMenuItemEvent dmie;
    dmie.item = this;
    menu->SendEvent(CvoDelMenuItemEvent, &dmie);

    if (menu && menu->items == this)
	menu->items = next;

    if (next)
	next->prev = prev;
    if (prev)
	prev->next = next;

    delete label;
}

Cvo_MenuSessionFilterResponse
Cvo_MenuEntry::Select()
{
    if (flags & CvoM_CASCADE)
	return(Cascade());

    return(CvoMenuSessionFilterFinished);
}

void
Cvo_MenuEntry::Call()
{
    if (flags & CvoM_MENU_LABEL) {
	Cvo_MenuLabel *ml = (Cvo_MenuLabel *)label;
	ml->Selected();
    }   

    if (ifunc || func) {
	Cvo_MenuEvent me;
    	Cvo_Window *win = menu->owner;
    	if (!win)
	    win = label;

	me.menu = menu;
	me.item = this;
	me.type = CvoMenuEvent;
	me.serial = 0;
	me.send_event = True;
	me.display = win->Dpy();
	me.window = win->Win();
	me.win = win;

    	if (ifunc)
	    (*ifunc)(win, (XEvent *)&me, data);
    	if (func)
	    (*func)(win, (XEvent *)&me, data);
    }
}

Cvo_MenuSessionFilterResponse
Cvo_MenuEntry::Cascade()
{
    if (!(flags & CvoM_CASCADE))
	return(CvoMenuSessionFilterReturn);

    if (func) {
	Cvo_MenuEvent me;
    	Cvo_Window *win = menu->owner;
    	if (!win)
	    win = label;
 
	me.menu = menu;
	me.item = this;
	me.type = CvoMenuCascadeEvent;
	me.serial = 0; 
	me.send_event = True;
	me.display = win->Dpy();
	me.window = win->Win(); 
	me.win = win;

	(*func)(win, (XEvent *)&me, data);
    }
    if (!cascade) {
    	if (!data) {
	    // XXX - This is really an error, we can't cascade...
	    return(CvoMenuSessionFilterReturn);
	}
	cascade = new Cvo_Menu("cascade", Cvo_MAINWINDOW,
				  (Cvo_MenuItem *)data);
	cascade->Create();
    }
    cascade->StartCascade(-1, label);
    cascade->cascadefrom = menu;
    menu->cascade = cascade;
    return(CvoMenuSessionFilterProcessed);
}
