//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
#include <Cvo/Menu.h++>
#include <Cvo/MenuLabel.h++>
#include <Cvo/BasicButton.h++>

static Cvo_Default defaults[] = {
        "*CvoMenuLabel*FontFamily:Helvetica",
        "*CvoMenuLabel*TabStop:8",
	"*CvoMenuLabel*FontWeight:Bold",
	"*CvoMenuLabel*AcceleratorGap: 20",
};

CONSTRUCTORS_2ARG(Cvo_MenuLabel, Cvo_Window, "CvoMenuLabel", char *, int)
CONSTRUCTORS_2ARG(Cvo_MenuLabel, Cvo_Window, "CvoMenuLabel", wchar_t *, int)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_MenuLabel)

void
Cvo_MenuLabel::_Init(char *s, int f)
{   CVO_ENTER
    type = CvoT_Label;
    LoadFont();

    gap = GetResourceInt("acceleratorGap", "AcceleratorGap", 20);

    accel = 0;
    compact = False;
    part1 = part2 = part3 = part4 = 0;
    nattr = TextAttribute();
    uattr = NewTextAttribute();
    uattr->Underline(True);

    SetText(GetResource(_Qlabel, _QLabel, s ? s : "Menu"));

    Register(Expose, &Cvo_MenuLabel::ExposureHandler);

    arrow = 0;
    cascade = (f & CvoM_CASCADE) ? True : False;
    toggle = (f & CvoM_TOGGLE) ? True : False;
    state = 0;
    if (f & CvoM_ALWAYSFLAT)
	Flatten();

    if (cascade) {
	arrow = new Cvo_InputOnly(this);
	arrow->DontLayout();
	arrow->DontMap();
    }

    CVO_VOID_RETURN
}

void
Cvo_MenuLabel::_Init(wchar_t *s, int f)
{   CVO_ENTER
    type = CvoT_Label;
    LoadFont();

    gap = GetResourceInt("acceleratorGap", "AcceleratorGap", 20);

    accel = 0;
    part1 = part2 = part3 = part4 = 0;
    nattr = TextAttribute();
    uattr = NewTextAttribute();
    uattr->Underline(True);

    //
    // Note that `s' and `mbl' are of different types.
    //
    char *mbl = GetResource(_Qlabel, _QLabel);
    if (mbl)
	SetText(mbl);
    else
	SetText(s);

    arrow = 0;
    cascade = (f & CvoM_CASCADE) ? True : False;
    toggle = (f & CvoM_TOGGLE) ? True : False;
    state = 0;
    if (f & CvoM_ALWAYSFLAT)
	Flatten();

    if (cascade) {
	arrow = new Cvo_InputOnly(this);
	arrow->DontLayout();
	arrow->DontMap();
    }

    Register(Expose, &Cvo_MenuLabel::ExposureHandler);

    CVO_VOID_RETURN
}

void
Cvo_MenuLabel::SetText(char *s)
{   CVO_ENTER
    Cvo_CharacterBuffer cb;

    cb.Set(s);

    SetText((wchar_t *)cb);
    CVO_VOID_RETURN
}

void
Cvo_MenuLabel::SetText(wchar_t *s)
{   CVO_ENTER
    wchar_t *t;

    accel = 0;
    delete [] part1;
    delete [] part2;
    delete [] part3;
    delete [] part4;
    part1 = part2 = part3 = part4 = 0;

    //
    // Find Part1 (everything before the _) if there is one
    //
    t = s;
    while (*t && *t != '_' && *t != '+') {
	++t;
    }
    if (t > s) {
	part1 = new wchar_t[(t + 1) - s];
	for (int i = 0; i < t - s; ++i)
	    part1[i] = s[i];
	part1[i] = 0;
	s = t;
    }

    //
    // Okay, if the next character is a '_' then we have a Part2
    //
    if (*s == '_') {
	++s;

	if (*s) {
	    part2 = new wchar_t[2];
	    part2[0] = *s++;
	    part2[1] = 0;

	    Cvo_CharacterBuffer cb;
	    cb.Set(part2, 1);
	    KeySym ks = XStringToKeysym((char *)cb);
	    if (ks != NoSymbol)
		accel = XKeysymToKeycode(Dpy(), ks);
	}
    }

    //
    // Okay, if the next character is not a '+' then we have a Part3
    //
    if (*s && *s != '+') {
	t = s;
	while (*t && *t != '+') {
	    ++t;
	}

	if (t > s) {
	    part3 = new wchar_t[(t + 1) - s];
	    for (int i = 0; i < t - s; ++i)
		part3[i] = s[i];
	    part3[i] = 0;
	    s = t;
	}
    }

    if (part2 && !accel) {
	int tlen = 0;

	if (t = part1) {
	    while (*t++)
		++tlen;
	}
	if (t = part2) {
	    while (*t++)
		++tlen;
	}
	if (t = part3) {
	    while (*t++)
		++tlen;
	}
	
	wchar_t *np1 = new wchar_t[tlen + 1];
	wchar_t *q = np1;

	if (t = part1) {
	    while (*q = *t++)
		++q;
	}
	if (t = part2) {
	    while (*q = *t++)
		++q;
	}
	if (t = part2) {
	    while (*q = *t++)
		++q;
	}
	delete [] part1;
	delete [] part2;
	delete [] part3;
	part1 = np1;
	part2 = 0;
	part3 = 0;
    }

    //
    // Finally, if the next character is a '+' we have a Part4
    //
    if (*s == '+') {
	++s;

	if (*s) {
	    t = s;
	    while (*t++)
		;

	    part4 = new wchar_t[t - s];
	    t = part4;
	    while (*t++ = *s++)
		;
	}
    }

    SetMinPixelSize(CalculateWidth(), CalculateHeight());
    Redraw();
    CVO_VOID_RETURN
}

void
cascade_enter(Cvo_Object *, XEvent *, void *vdata)
{
    Cvo_MenuLabel *m = (Cvo_MenuLabel *)vdata;

    Cvo_AnyEvent ae;
    if (m->Mapped() && m->Parent()->Mapped())
	m->SendEvent(CvoMenuDoCascadeEvent, &ae);
}

void
Cvo_MenuLabel::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (!Object() || !set())
	CVO_VOID_RETURN

    XRectangle log;
    SetGC(CurrentBackground(), CurrentForeground());

    unsigned short w = (!compact || toggle) ? Height() : 0;

    if (part1) {
	nattr->DrawStrings(Cvo_LEFT_JUSTIFY, w, 0,
			   Width() - w, Height(), part1, -1);
        nattr->StringsExtents(part1, -1, log);
	w += log.width;
    }
    if (part2) {
	uattr->DrawStrings(Cvo_LEFT_JUSTIFY, w, 0,
			   Width() - w, Height(), part2, -1);
        uattr->StringsExtents(part2, -1, log);
	w += log.width;
    }
    if (part3) {
	nattr->DrawStrings(Cvo_LEFT_JUSTIFY, w, 0,
			   Width() - w, Height(), part3, -1);
        nattr->StringsExtents(part3, -1, log);
	w += log.width;
    }
    if (part4) {
	nattr->DrawStrings(Cvo_RIGHT_JUSTIFY, w, 0,
			   Width() - w - Height(), Height(), part4, -1);
        // nattr->StringsExtents(part4, -1, log);
    }

    if (toggle) {
    	int inset = Height() >> 4;
    	if (inset < 2)
	    inset = 2;

    	int ipad = inset * 2;

	if (state) {
	    if (Monochrome()) {
		SetForeground(foreground);  
		FillRectangle(ipad, ipad,
			      Height() - ipad * 2, Height() - ipad * 2);
		DrawRectangle(ipad, ipad,
			      Height() - ipad * 2 - 1, Height() - ipad * 2 - 1);
	    } else {
		SetForeground(background->Select());
		FillRectangle(ipad, ipad,
			      Height() - ipad * 2, Height() - ipad * 2);
		DrawLoweredChamfer(inset, ipad, ipad,
				   Height() - ipad * 2, Height() - ipad * 2);
	    }
	} else {
	    if (Monochrome()) {    
		SetForeground(background);
		FillRectangle(ipad, ipad,
			      Height() - ipad * 2, Height() - ipad * 2);
		SetForeground(foreground);
		DrawRectangle(ipad, ipad,
			      Height() - ipad * 2 - 1, Height() - ipad * 2 - 1);
	    } else {          
		SetForeground(background);
		FillRectangle(ipad, ipad,
			      Height() - ipad * 2, Height() - ipad * 2);
		DrawRaisedChamfer(inset, ipad, ipad,
			          Height() - ipad * 2, Height() - ipad * 2);
	    }                      
	}   
    }
    if (cascade) {
        log.width -= TextAttribute()->MHeight();
        DrawRightArrow(width - (Height() - 4), 2, Height() - 4);
    	if (arrow && !arrow->Mapped()) {
    	    arrow->Create();
    	    arrow->ForceResizeWindow(XHeight(), XHeight());
    	    int o = (XWidth() - Width()) / 2;
    	    arrow->ForceMoveWindow(XWidth() - XHeight() - o, 0 - o);
    	    arrow->Map();
    	    arrow->Register(EnterNotify, cascade_enter, this);
	}
    }
    CVO_VOID_RETURN
}

CARD16
Cvo_MenuLabel::CalculateWidth()
{   CVO_ENTER
    XRectangle log;

    unsigned short w = 0;
    unsigned short h = 0;

    if (part1) {
        nattr->StringsExtents(part1, -1, log);
	w += log.width;
	if (h < log.height)
	    h = log.height;
    }
    if (part2) {
        uattr->StringsExtents(part2, -1, log);
	w += log.width;
	if (h < log.height)
	    h = log.height;
    }
    if (part3) {
        nattr->StringsExtents(part3, -1, log);
	w += log.width;
	if (h < log.height)
	    h = log.height;
    }
    if (part4) {
	w += gap;
        nattr->StringsExtents(part4, -1, log);
	w += log.width;
	if (h < log.height)
	    h = log.height;
    }

    if (!compact)
	w += 2 * h;		// Leave room for toggle and cascade arrow
    else if (toggle && cascade)
	w += 2 * h;
    else if (toggle || cascade)
	w += h;

    CVO_RETURN(w)
}

CARD16
Cvo_MenuLabel::CalculateHeight()
{   CVO_ENTER
    XRectangle log;

    unsigned short h = 0;
    if (part1) {
        nattr->StringsExtents(part1, -1, log);
	if (h < log.height)
	    h = log.height;
    }
    if (part2) {
        uattr->StringsExtents(part2, -1, log);
	if (h < log.height)
	    h = log.height;
    }
    if (part3) {
        nattr->StringsExtents(part3, -1, log);
	if (h < log.height)
	    h = log.height;
    }
    if (part4) {
        nattr->StringsExtents(part4, -1, log);
	if (h < log.height)
	    h = log.height;
    }
    CVO_RETURN(h)
}

void
Cvo_MenuLabel::Selected()
{
    if (toggle) {
	state ^= 1;

	Cvo_ButtonEvent bev;
	bev.value = state;

	SendEvent(state ? CvoButtonDownEvent : CvoButtonUpEvent, &bev);

	ExposureHandler();
    }
}

void
Cvo_MenuLabel::ForceOn()
{
    if (toggle) {
	state = 1;

	Cvo_ButtonEvent bev;
	bev.value = state;
	SendEvent(CvoButtonDownEvent, &bev);

	ExposureHandler();
    }
}

void
Cvo_MenuLabel::ForceOff()
{
    if (toggle) {
	state = 0;

	Cvo_ButtonEvent bev;
	bev.value = state;
	SendEvent(CvoButtonUpEvent, &bev);

	ExposureHandler();
    }
}

void
Cvo_MenuLabel::GetText(Cvo_CharacterBuffer &cb)
{
    wchar_t ws[2];
    ws[1] = 0;

    cb.Truncate(0);
    if (part1)
	cb.Append(part1);
    if (part2) {
    	ws[0] = '_';
	cb.Append(ws, 1);
	cb.Append(part2);
    }
    if (part3)
	cb.Append(part3);
    if (part4) {
    	ws[0] = '+';
	cb.Append(ws, 1);
	cb.Append(part4);
    }
}
