//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: NullLayout.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>

int
Cvo_LayoutWindow::NullLayoutFunction(int force, int child, int, int)
{   CVO_ENTER
    if (force == -1)
	CVO_RETURN(0)

    //
    // If we have been called from outside the layout manager, we will
    // have to compute the layout sizes for our children.
    //
    if (!child)
	ComputeLayoutSize(force);

    //
    // Okay, now we are ready to call the function to layout our children.
    // Our size has been fixed, as it always must be prior to calling
    // the LayoutChildren method.
    //
    for (int o = 0; o < Cvo_NOVERLAYS; ++o)
	LayoutChildren(force, o);
    CVO_RETURN(0)
}

void
Cvo_LayoutWindow::NullLayoutChildren(int, int)
{   CVO_ENTER
    //
    // This function is installed when the children should simply not be
    // layed out within a window.
    //
    CVO_VOID_RETURN
}

int
Cvo_LayoutWindow::NullComputeLayoutSize(int)
{   CVO_ENTER
    layout.minimum.width = XWidth();
    layout.minimum.height = XHeight();
    layout.desired.width = XWidth();
    layout.desired.height = XHeight();
    layout.maximum.width = XWidth();
    layout.maximum.height = XHeight();

    CVO_RETURN(CheckLayout())
}
