//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Object.cc,v 1.13 1994/09/07 20:46:54 prb Exp $"); }
#include <Cvo/Window.h++>
#include <X11/Xatom.h>
#include <memory.h>
#include <string.h>
#if	!defined(X11R4)
#include <X11/Xlocale.h>
#endif

Cvo_Object *Cvo_Object::hashList[Cvo_HASHSIZE] = { 0, };

static Cvo_Default def[] = {
    "*Chamfer:2",

    "*Foreground:black",

    "*FontFamily:Clean",
    "*FontWeight:Medium",
    "*FontSlant:r",
    "*FontSize:14",

    "*LayoutPad: 3",
    "*InternalPad: 3",

    "*Foreground:black",
    ".Cursor: Diamond Cross",

    "*Color*Background:gray",
    "*Color*DontSink:",

    // Below are Mono options

    "*Background:white",
    "*DontSink:True",
};

CVO_INIT_BIND(Cvo_Object)

Cvo_Object		*Cvo_Object::selectOwner = 0;
Cvo_Registration	*Cvo_Object::selectRe = 0;
Cvo_CharacterBuffer	 Cvo_Object::selectBuf;

Cvo_Object::Cvo_Object(char *_name, char *_class, Cvo_Object *_parent)
          : Cvo_BasicObject(_parent)
{   CVO_ENTER
    Cvo_Lock lock;

    parent = _parent;
    _Init(_name, _class);
    CVO_VOID_RETURN
}

Cvo_Object::Cvo_Object(char *_name, char *_class, Display *_display)
          : Cvo_BasicObject(_display)
{   CVO_ENTER
    Cvo_Lock lock;

    parent = 0;

    _Init(_name, _class);
    CVO_VOID_RETURN
}

void
Cvo_Object::InsertIntoHashList()
{   CVO_ENTER
    nextObject = hashList[window & (Cvo_HASHSIZE-1)];
    hashList[window & (Cvo_HASHSIZE-1)] = this;
    CVO_VOID_RETURN
}

Cvo_Object *
Cvo_Object::RootObject()
{
    Cvo_Object *obj = this;

    while (obj->Parent())
	obj = obj->Parent();
    return(obj);
}

Cvo_Object *
Cvo_FindWindow(Display *_display, Window _window)
{   CVO_ENTER
    Cvo_Lock lock;
    static Cvo_Object *last_obj = 0;
    static Window last_win = 0;
    static Display *last_disp = 0;
    static long last_serial = 0;
    Cvo_Object *obj;
    Cvo_Window *wwc;

    //
    // Try the hash list first
    //
    obj = Cvo_Object::hashList[_window & (Cvo_HASHSIZE-1)];
    while (obj) {
	if (obj->Dpy() == _display && obj->Win() == _window)
	    CVO_RETURN(last_obj = obj)
	obj = obj->NextObject();
    }

    //
    // Fastest case, this is the same as the last window we found
    //
    if (_window == last_win && _display == last_disp && last_obj &&
	last_obj->Serial() == last_serial) {
	    CVO_RETURN(last_obj)
    }

    //
    // Check out the parent and shadow
    //
    Cvo_BasicObject *cwc = Cvo_BasicObject::base;
    while (cwc) {
	if ((obj = cwc->ToObject()) &&
	    (obj->PWin() == _window || ((wwc = obj->ToWindow()) &&
					 wwc->Shadow() == _window)) &&
	     obj->Dpy() == _display) {
	    last_win = _window;
	    last_disp = _display;
	    last_serial = obj->Serial();
	    CVO_RETURN(last_obj = obj)
	}
	cwc = cwc->Next();
    }

    //
    // Next fastest, try JUST the window and display
    //
    cwc = Cvo_BasicObject::base;
    while (cwc) {
	if (cwc->Dpy() == _display && cwc->Win() == _window) {
	    last_win = _window;
	    last_disp = _display;
	    last_serial = cwc->Serial();
	    CVO_RETURN(last_obj = cwc->ToObject())
	}
	cwc = cwc->Next();
    }
    CVO_RETURN(0)
}

void
Cvo_Object::_Init(char *_name, char *_class)
{   CVO_ENTER

    _cvo_debug(CvoDebug_New, "_Init(%s, %s)\n", _name, _class);
    cvo_level = _CVO_BASIC_WINDOW;

    children = 0;
    elder = 0;
    sibling = 0;
    nextObject = 0;
    pwindow = 0;
    selectMask = 0;
    memset(&position, 0, sizeof(position));
    borderWidth = 0;
    translations = 0;
    registration = 0;
#if	!defined(X11R4)
    input_context = 0;
#endif
    focusreg = 0;
    enterreg = 0;
    focus = 0;
    deleting = False;
    deleted = False;
    dontsink = False;

    qname = XrmStringToQuark(_name);
    qclass = XrmStringToQuark(_class);
    type = CvoT_Object;

    if (parent) {
	parent->newchildren = True;
	if (parent->children) {
	    elder = parent->children->elder;
	    elder->sibling = this;
	} else
	    parent->children = this;
	parent->children->elder = this;
	depth = parent->depth;
	monochrome = parent->monochrome;
    } else {
	DisplayList()->GetGroup(this);		// If we are the first object
						// then we are the main object
	if (GetResourceTruth(_Qmonochrome, _QMonochrome))
	    monochrome = True;
    }
    //
    // Allow the resources to override Color monoitors.
    // But note that once a monochrome window, all children
    // will be monochrome as well...
    // Also note you cannot force color on a monochrome machine.
    //

    dontsink = GetResourceTruth(_QdontSink, _QDontSink, dontsink);

    if (_cvo_debug_mode)
	printevents = GetResourceTruth(_QprintEvents, _QPrintEvents, False);

    if (!parent) {
	Register(MapNotify, &Cvo_Object::MappedEvent);
	Register(UnmapNotify, &Cvo_Object::UnmappedEvent);
    }
    CVO_VOID_RETURN
}

Cvo_Object::~Cvo_Object()
{   CVO_ENTER
    Cvo_Lock lock;

    _cvo_debug(CvoDebug_New, "~Cvo_Object(%s, %s)\n", Name(), Class());

    if (magic != Cvo_MAGIC)
	CVO_VOID_RETURN

    if (type) {
	if (window)
	    LoseFocus();

	if (!deleting) {
	    deleting = True;
	    Cvo_DestroyedEvent d;
	    SendEvent(CvoDestroyedEvent, &d);
	    //
	    // It should probably be noted that it is possible to have
	    // one object deleted twice as when a child's CvoDestroyedEvent
	    // handler deletes a parent.  This is needed because the
	    // parent will actually destroy the childs X window when it
	    // destroys its own window.  This means we must let the parent
	    // call XDestroyWindow for us, even though we were going to do
	    // it later anyhow.
	    //
	}
	if (deleted)
	    CVO_VOID_RETURN
	deleted = True;
    }

    if (window) {
	if (this == hashList[window & (Cvo_HASHSIZE-1)])
	    hashList[window & (Cvo_HASHSIZE-1)] = nextObject;   
	else {
	    Cvo_Object *obj = hashList[window & (Cvo_HASHSIZE-1)];
	    while (obj->nextObject && obj->nextObject != this)
		obj = obj->nextObject;
	    if (obj->nextObject)
		obj->nextObject = nextObject;
	}
    }


    if (type) {
	if (parent) {
		Cvo_Object *obj = parent;
		while (obj->parent)
		    obj = obj->parent;
		if (obj->focus == this)
			obj->focus = 0;

		if (parent->children == this) {
		    if (parent->children = sibling)
			sibling->elder = elder;
		} else {
		    if (elder->sibling = sibling) {
			sibling->elder = elder;
		    } else {
			parent->children->elder = elder;
		    }
		}
		sibling = elder = 0;
	}

	//
	// Close all the children.  Note that the children remove themselves
	// from our list, so we only need to look at the first element of the
	// list repeatedly until is becomes null.
	//
	while (children)
		delete children;

	if (registration) {
	    for (int x = 0; x <= Cvo_MaxEvent; ++x) {
		while (registration[x])
		    delete registration[x];
	    }
	    (*registration)->FreeArray(registration);
	    registration = 0;
	}
	while (regreferences)
	    delete regreferences->reg;

	//
	// Only delete the windows if it is at least a LayoutWindow
	// If it is only a Cvo_Object, then it probably is an external
	// window we should not be messing around with.
	//
	if (ToLayoutWindow()) {
	    Cvo_Window *w = ToWindow();
	    if (w && w->shadow) {
		XDestroyWindow(Dpy(), w->shadow);
		w->shadow = 0;
	    }

	    if (Object()) {
		XDestroyWindow(Dpy(), Object());
		XFlush(Dpy());
		window = 0;
	    }
	}
	Cvo_Object *obj = parent;

	while (obj) {
	    Cvo_AnyEvent cev;
	    obj->SendEvent(CvoDestroyedChildEvent, &cev);

	    if (!obj->ToLayoutWindow() && !obj->ToLayoutWindow()->LayoutBackward())
		break;
	    obj = obj->Parent();
	}

    }
    CVO_DONE
}

void
Cvo_Object::Map(int r)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Map, "Cvo_Map(%s, %s)\n", Name(), Class());

    if (mapped) {
	CVO_VOID_RETURN
    }

    Cvo_Lock lock;

    Cvo_LayoutWindow *lw = ToLayoutWindow();
    Cvo_Window *ww = ToWindow();

    BOOL needlayout = (r || !lw) ? False : True;

    if (!Object()) {
	//
	// Creating the parent window causes ReLayout to be called
	// so there is no need to call it in this routine.
	//
	if (!parent)
	    needlayout = False;
	if (lw)
	    lw->Create();
	else
	    CVO_VOID_RETURN
    }

    if (Object()) {
	//
	// Go ahead and map the children which want to be.
	//

	mapped = True;
	do {
	    Cvo_Object *w = children;
	    newchildren = False;

	    while (w) {
		if (!w->dontmap && !w->Mapped()) {
		    w->Map(1);
		    if (newchildren)
			break;
		}
		w = w->sibling;
	    }
	} while (newchildren);

	Cvo_AnyEvent cev;
	SendEvent(CvoPreMapRequestEvent, &cev);

	if (needlayout) {
	    while (lw->Parent() && lw->Parent()->ToLayoutWindow() &&
		   lw->LayoutBackward()) {
		lw = lw->Parent()->ToLayoutWindow();
	   }
	   lw->ReLayout(1);
	}

	SendEvent(CvoMapRequestEvent, &cev);

	XMapWindow(Dpy(), Object());
	if (ww && ww->shadow)
	    XMapWindow(Dpy(), ww->shadow);
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::CreateAll(int r)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Map, "Cvo_CreateAll(%s, %s)\n", Name(), Class());
    if (mapped)
	CVO_VOID_RETURN

    Cvo_Lock lock;

    Cvo_LayoutWindow *lw = ToLayoutWindow();
    Cvo_Window *ww = ToWindow();

    if (!Object()) {
	if (lw)
	    lw->Create();
	else
	    CVO_VOID_RETURN
    }

    if (Object()) {
	//
	// Go ahead and map the children which want to be.
	//

	do {
	    Cvo_Object *w = children;
	    newchildren = False;

	    while (w) {
		if (!w->dontmap) {
		    w->CreateAll(1);
		    if (newchildren)
			break;
		}
		w = w->sibling;
	    }
	} while (newchildren);

	if (lw && !r) {
	    while (lw->Parent() && lw->Parent()->ToLayoutWindow() &&
		   lw->LayoutForeward())
		lw = lw->Parent()->ToLayoutWindow();
	   lw->ReLayout(1);
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::Unmap()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Map, "Cvo_Unmap(%s, %s)\n", Name(), Class());
    if (!mapped)
	CVO_VOID_RETURN
    Cvo_Window *ww = ToWindow();

    Cvo_Lock lock;
    mapped = False;

    Cvo_AnyEvent cev;
    SendEvent(CvoUnmapRequestEvent, &cev);

    if (ww && ww->shadow)
	XUnmapWindow(Dpy(), ww->shadow);
    XUnmapWindow(Dpy(), Object());
    configured = False;
    CVO_VOID_RETURN
}

void
Cvo_Object::MappedEvent(XEvent *ev, void *)
{
    if (ev->xmap.window == Object())
	mapped = True;
}

void
Cvo_Object::UnmappedEvent(XEvent *ev, void *)
{
    if (ev->xunmap.window == Object())
	mapped = False;
}

//
// The Flush() routine takes an optional argument.  The value of
// that argument means:
//
//	0:  Flush this and children and display
//	1:  Flush this and children
//	2:  Flush this and display
//	3:  Flush this
//
void
Cvo_Object::Flush(int r)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Flush, "Cvo_Flush(%s, %s)\n", Name(), Class());
    Cvo_Lock lock;

    Cvo_Object *w = children;

    if (!(r & 2)) {
	while (w) {
	    w->Flush(r | 1);
	    w = w->sibling;
	}
    }

    if (!(r & 1) && Dpy() && !InEventLoop()) {
	XFlush(Dpy());
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::SetNormalHints(int w, int h)
{   CVO_ENTER
    XSizeHints xsh;

    if (!Object() || parent)
	CVO_VOID_RETURN

    xsh.flags = 0;
    XGetNormalHints(Dpy(), Object(), &xsh);

    xsh.flags |= PSize;
    xsh.width = w;
    xsh.height = h;


    Cvo_LayoutWindow *lw = ToLayoutWindow();
    if (lw) {
	xsh.width += 2 * lw->horizontalPad;
	xsh.height += 2 * lw->verticalPad;
	xsh.min_height = lw->layout.minimum.height - 2 * borderWidth;
	xsh.min_width = lw->layout.minimum.width - 2 * borderWidth;
	xsh.flags |= PMinSize;
	if (lw->layout.maximum.height && lw->layout.maximum.width) {
	    xsh.max_height = lw->layout.maximum.height - 2 * borderWidth;
	    xsh.max_width = lw->layout.maximum.width - 2 * borderWidth;
	    xsh.flags |= PMaxSize;
	}
    }

    XSetNormalHints(Dpy(), Object(), &xsh);
    CVO_VOID_RETURN
}

void
Cvo_Object::Bind()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Bind, "Cvo_Bind(%s, %s)\n", Name(), Class());
    if (!translations)
	    CVO_VOID_RETURN

    CVO_DOBIND(Cvo_Object, "help-notify", HelpHandler)
    CVO_DOBIND(Cvo_Object, "HelpNotify",  HelpHandler)
    CVO_DOBIND(Cvo_Object, "Iconify",	  Iconify)
    CVO_DOBIND(Cvo_Object, "Deiconify",	  Deiconify)
    CVO_DOBIND(Cvo_Object, "Dismiss",     Dismiss)
    CVO_DOBIND(Cvo_Object, "Quit",        Quit)
    CVO_DOBIND(Cvo_Object, "ignore",	  NullHandler)
    CVO_DOBIND(Cvo_Object, "Unmap",	  UnmapHandle)

    Cvo_BindEvent d;
    SendEvent(CvoBindEvent, &d);

    translations->Verify();
    translations->Install(this);
    CVO_VOID_RETURN
}

static void
_SetTitle(Cvo_Object *obj, XEvent *, void *v)
{
    char *s = (char *)v;
    XTextProperty win_name;

    XStringListToTextProperty(&s, 1, &win_name);
    XSetWMName(obj->Dpy(), obj->Object(), &win_name);
    XFree(_xfree_t win_name.value);
    delete [] s;
}

void
Cvo_Object::SetTitle(char *s)
{   CVO_ENTER
    Cvo_Lock lock;

    s = ExpandName(s);

    if (Object()) {
	_SetTitle(this, 0, s);
    } else {
	new Cvo_OneTimeRegistration(this, CvoCreatedEvent, _SetTitle, s);
    }
    CVO_VOID_RETURN
}

static void
_SetIconTitle(Cvo_Object *obj, XEvent *, void *v)
{
    char *s = (char *)v;
    XTextProperty icon_name;

    XStringListToTextProperty(&s, 1, &icon_name);
    XSetWMIconName(obj->Dpy(), obj->Object(), &icon_name);
    XFree(_xfree_t icon_name.value);
    delete [] s;
}

void
Cvo_Object::SetIconTitle(char *s)
{   CVO_ENTER
    Cvo_Lock lock;

    s = ExpandName(s);

    if (Object()) {
	_SetTitle(this, 0, s);
    } else {
	new Cvo_OneTimeRegistration(this, CvoCreatedEvent, _SetIconTitle, s);
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::Reparent(Cvo_Object *np)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Reparent, "Cvo_Reparent(%s, %s -> %s, %s)\n",
	    Name(), Class(), np->Name(), np->Class());
    //
    // XXX - This does not work if the windows have already been
    // created!!!!
    //
    if (parent) {
	    if (sibling)
		sibling->elder = elder;
	    if (this == parent->children)
		parent->children = sibling;
	    else if (elder)
		elder->sibling = sibling;
	    if (this == parent->children->elder)
		parent->children->elder = elder;
    }

    sibling = 0;

    parent->newchildren = True;
    parent = np;
    parent->newchildren = True;
    if (parent->children) {
	    elder = parent->children->elder;
	    elder->sibling = this;
    } else
	    parent->children = this;
    parent->children->elder = this;
    CVO_VOID_RETURN
}

void
Cvo_Object::PlaceBefore(Cvo_Object *np)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Reparent, "Cvo_PlaceBefore(%s, %s -> %s, %s)\n",
	       Name(), Class(), np->Name(), np->Class());

    if (np == this)
	CVO_VOID_RETURN

    if (Dpy() != np->Dpy())
	CVO_VOID_RETURN

    if (!np->parent)
	CVO_VOID_RETURN

    if (np->parent != parent) {
	Reparent(np->parent);
    }

    //
    // Check to see if we are alread just before np
    //
    if (np->parent->children != np && np->elder == this)
	CVO_VOID_RETURN

    parent->newchildren = True;
    //
    // Okay, we must move , first remove us from the list
    //
    if (sibling)
	sibling->elder = elder;
    if (this == parent->children)
	parent->children = sibling;
    else if (elder)
	elder->sibling = sibling;
    if (this == parent->children->elder)
	parent->children->elder = elder;

    //
    // Now insert before np.
    //

    if (parent->children == np)
	parent->children = this;
    else
	np->elder->sibling = this;

    elder = np->elder;
    sibling = np;
    np->elder = this;
    CVO_VOID_RETURN
}

void
Cvo_Object::PlaceAfter(Cvo_Object *np)
{   CVO_ENTER
    _cvo_debug(CvoDebug_Reparent, "Cvo_PlaceAfter(%s, %s -> %s, %s)\n",
	       Name(), Class(), np->Name(), np->Class());

    if (np == this)
	CVO_VOID_RETURN

    if (Dpy() != np->Dpy())
	CVO_VOID_RETURN

    if (!np->parent)
	CVO_VOID_RETURN

    if (np->parent != parent)
	Reparent(np->parent);

    //
    // Check to see if we are alread just after np
    //
    if (np->sibling == this)
	CVO_VOID_RETURN

    parent->newchildren = True;
    //
    // Okay, we must move , first remove us from the list
    //
    if (sibling)
	sibling->elder = elder;
    if (this == parent->children)
	parent->children = sibling;
    else if (elder)
	elder->sibling = sibling;
    if (this == parent->children->elder)
	parent->children->elder = elder;

    //
    // Now insert after np.
    //

    if (parent->children->elder == np) {
	parent->children->elder = this;
	sibling = 0;
	np->sibling = this;
	elder = np;
    } else {
	sibling = np->sibling;
	sibling->elder = this;
	np->sibling = this;
	elder = np;
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::NullHandler(XEvent *, int, char **)
{   CVO_ENTER
    CVO_VOID_RETURN
}

char *
Cvo_Object::ExpandName(char *n)
{   CVO_ENTER
    char buf[1024];
    char *b = buf;

    while (*n) {
	if (*n == '%') {
	    char *t;
	    switch (*++n) {
	    case '%':
		t = "%";
		break;
	    case 'I':
		t = _Cvo_Base.InstanceName;
		break;
	    case 'P':
		t = _Cvo_Base.ProgramName;
		break;
	    case 'C':
		t = _Cvo_Base.ClassName;
		break;
	    case 'R':
		t = _Cvo_Base.ResourceName;
		break;
	    case 'D':
		t = _Cvo_Base.DisplayName;
		break;
	    case 'L':
		t = _Cvo_Base.Locale;
		break;
	    case 'n':
		t = Name();
		break;
	    case 'c':
		t = Class();
		break;
	    default:
		t = "";
		break;
	    }
	    while (*b = *t++)
		++b;
	    ++n;
	} else 
	    *b++ = *n++;
    }
    *b++ = 0;
    b = new char [b - buf];
    if (!b) {
	Cvo_Failure(CvoE_FATAL, CvoE_NOMEM,
		    "Out of memory in routine ``%s''\n",
		    "Cvo_Object::ExpandName");
    }
    strcpy(b, buf);
    CVO_RETURN(b)
}

void
Cvo_Object::ComputeOriginAtRoot(int *x, int *y)
{   CVO_ENTER
    Cvo_Object *obj = this;

    while (obj) {
        *x += obj->position.x;
        *y += obj->position.y;
        obj = obj->Parent();
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::ComputeOriginFromRoot(int *x, int *y)
{   CVO_ENTER
    Cvo_Object *obj = this;

    while (obj) {
        *x -= obj->position.x;
        *y -= obj->position.y;
        obj = obj->Parent();
    }
    CVO_VOID_RETURN
}

void
Cvo_Object::QueryMouseLocation(int *x, int *y, int *rx, int *ry)
{   CVO_ENTER
    Window w;
    int t;
    unsigned int m;

    if (!x)
	x = &t;
    if (!y)
	y = &t;
    if (!rx)
	rx = &t;
    if (!ry)
	ry = &t;

    XQueryPointer(Dpy(), Win(), &w, &w, rx, ry, x, y, &m);

    Cvo_LayoutWindow *lw = ToLayoutWindow();

    if (lw)
	lw->FromXCoord(x, y);
    CVO_VOID_RETURN
}

//
// Generate a window name for unnamed windows
//
char *
_Cvo_GenerateName()
{
    static char name[32];
    static cnt = 0;

    sprintf(name, "noname-%d", ++cnt);
    return(name);
}


Cvo_CharacterBuffer *
Cvo_Object::GetSelection(Cvo_CharacterBuffer *cb)
{
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long leftover;
    unsigned char *data;
    int nbytes = 0;

    Atom sel = DisplayData()[CvoA_SELECTION];

#if 0
    if (selectregistered == False) {
        Register(SelectionNotify, &Cvo_Object::SelectNotify);
        selectregistered = True;
    }

    selectnotify = False;
    XConvertSelection(Dpy(),
		      DisplayData()[CvoA_PRIMARY],
		      DisplayData()[CvoA_STRING],
		      sel, Object(), CurrentTime);
    while (selectnotify == False) {
        Cvo_ScanDisplays();
        if (selectnotify == False)
            Cvo_ScanInputs(True);
    }
#endif

    if (XGetWindowProperty(Dpy(), Root(), sel, 0L, 10000000L,
                           False, XA_STRING,
                           &actual_type, &actual_format, &nitems,
                           &leftover, &data) != Success)
        CVO_RETURN(0)

    if ((char *) data == NULL)
        CVO_RETURN(0)

    if ((actual_type != XA_STRING) || (actual_format != 8)) {
        XFree (_xfree_t data);
        CVO_RETURN(0)
    }

    cb->Set((char *)data, int(nitems));
    XFree (_xfree_t data);

    CVO_RETURN(cb)
}

void
Cvo_Object::SelectNotify(XEvent *, void *)
{   CVO_ENTER
    selectnotify = True;
    CVO_VOID_RETURN
}

void
Cvo_Object::AddTranslations(char *table, int mode)
{   CVO_ENTER

    if (notranslations)
        CVO_VOID_RETURN
    Cvo_Translation *t = Cvo_LoadTranslation(table, mode);

    if (translations)
        translations = Cvo_LoadTranslation(translations, t);
    else
        translations = t;
    CVO_VOID_RETURN
}

void
_Cvo_ObjectAddBinding(Cvo_Object *obj, XEvent *, void *map)
{
    obj->translations->Bind((Cvo_HandleFunction *)map);
}

void
Cvo_Object::Dismiss(XEvent *, int, char **)
{   CVO_ENTER
    extern void Cvo_MenuDismiss(Cvo_Object *, XEvent *, void *);
    Cvo_MenuDismiss(this, 0, 0);
    CVO_VOID_RETURN
}

void
Cvo_Object::Quit(XEvent *, int, char **)
{   CVO_ENTER
    extern void Cvo_MenuQuit(Cvo_Object *, XEvent *, void *);
    Cvo_MenuQuit(this, 0, 0);
    CVO_VOID_RETURN
}

void
Cvo_Object::Iconify(XEvent *, int, char **)
{   CVO_ENTER
    Cvo_Object *w = RootObject();

    if (!w->Win())
	CVO_VOID_RETURN
    XIconifyWindow(w->Dpy(), w->Win(), w->XScreen());
    CVO_VOID_RETURN
}

void
Cvo_Object::UnmapHandle(XEvent *, int, char **)
{   CVO_ENTER
    Cvo_Object *w = RootObject();

    w->Unmap();
    CVO_VOID_RETURN
}

static Cvo_Atom wm_change_state;
#define	WMCS	DisplayData()[wm_change_state]

void
Cvo_Object::Deiconify(XEvent *, int, char **)
{   CVO_ENTER
    Cvo_Object *w = RootObject();

    if (!w->Win())
	CVO_VOID_RETURN
#if 1
    XMapWindow(Dpy(), Object());
#else
    XClientMessageEvent ev;

    if (Atom(wm_change_state) == Atom(-1)) {
	wm_change_state = "WM_CHANGE_STATE";
    }
    if (!long(WMCS))
        WMCS = XInternAtom(Dpy(), "WM_CHANGE_STATE", False);
    if (!(ev.message_type = WMCS))
	return;

    ev.type = ClientMessage;
    ev.window = w->Win();
    ev.format = 32;
    ev.data.l[0] = NormalState;

    XSendEvent(w->Dpy(), w->Root(), False,
	       SubstructureRedirectMask | SubstructureNotifyMask,
	       (XEvent *) &ev);
#endif
}
