//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: OpenFile.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/OpenFile.h++>
#include <Cvo/Label.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Button.h++>
#include <Cvo/Confirm.h++>
#include <Cvo/Inform.h++>
#include <Cvo/Separator.h++>

#include <sys/types.h>
#include <dirent.h>
#if     !defined(S_ISDIR)
#include <sys/stat.h>
#endif
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/wait.h>

static char *glob(char *);

CONSTRUCTORS_2ARG(Cvo__OpenFile, Cvo_Window, "CvoOpenFile", void *, BOOL)
CONSTRUCTORS_2ARG_PASS(Cvo__SaveFile, Cvo__OpenFile, "CvoSaveFile", void *, BOOL)

void
Cvo_OpenFile(Cvo_Object *w, XEvent *, void *data)
{   CVO_ENTER
    Cvo_OpenFileInfo *ofi = (Cvo_OpenFileInfo *)data;

    w = w->RootObject();

    if (!ofi->of) {
	ofi->of = new Cvo__OpenFile(ofi->name, Cvo_MAINWINDOW, ofi->data);
        ofi->of->Register(CvoDestroyedEvent, Cvo_OpenFileDestroyed, ofi);
	if (w->ToLayoutWindow()) {
	    int x, y;
	    w->ToLayoutWindow()->XOrigin(&x, &y);
	    ofi->of->ForceMoveWindow(x + 20, y + 20);
	}
	ofi->of->MakeTransient(w);
	if (ofi->file)
	    ofi->of->SetFullName(ofi->file);
	if (ofi->filter)
	    ofi->of->SetFilter(ofi->filter);
    } else
	ofi->of->RereadDirectory();
    if (!ofi->of->Mapped()) {
	ofi->of->Map();
	ofi->of->pin->ForceOff();
    }
    ofi->of->Flush();
    CVO_VOID_RETURN
}

void 
Cvo_OpenFileDestroyed(Cvo_Object *, XEvent *, void *d)
{    
    Cvo_OpenFileInfo *ofi = (Cvo_OpenFileInfo *) d;
    ofi->of = NULL; 
}    

void
Cvo_SaveFile(Cvo_Object *w, XEvent *, void *data)
{   CVO_ENTER
    Cvo_SaveFileInfo *sfi = (Cvo_SaveFileInfo *)data;

    w = w->RootObject();

    if (!sfi->sf) {
	sfi->sf = new Cvo__SaveFile(sfi->name, Cvo_MAINWINDOW, sfi->data);
        sfi->sf->Register(CvoDestroyedEvent, Cvo_OpenFileDestroyed, sfi);
	if (w->ToLayoutWindow()) {
	    int x, y;
	    w->ToLayoutWindow()->XOrigin(&x, &y);
	    sfi->sf->ForceMoveWindow(x + 20, y + 20);
	}
	sfi->sf->MakeTransient(w);
	if (sfi->file)
	    sfi->sf->SetFullName(sfi->file);
    } else
	sfi->sf->RereadDirectory();
    if (!sfi->sf->Mapped()) {
	sfi->sf->Map();
	sfi->sf->pin->ForceOff();
    }
    sfi->sf->Flush();
    CVO_VOID_RETURN
}

void 
Cvo_SaveFileDestroyed(Cvo_Object *, XEvent *, void *d)
{    
    Cvo_SaveFileInfo *sfi = (Cvo_SaveFileInfo *) d;
    sfi->sf = NULL; 
}    

void
Cvo__OpenFile::_Init(void *_data, BOOL _savefile)
{   CVO_ENTER
    type = CvoT_OpenFile;

    VerticalChildren();
    Cvo_Label *lab;
    Cvo_Frame *lists;
    Cvo_Frame *frame;
    Cvo_Frame *buttons;
    Cvo_Button *b;

    filename = directory;
    directory[0] = 0;
    accept = 0;
    acceptlen = 0;
    savefile = _savefile;
    data = _data;
    dirtydir = False;

    dirpage = new Cvo_TextPage;
    dirpage->SetAbsoluteMax(0);
    filepage = new Cvo_TextPage;
    filepage->SetAbsoluteMax(0);

    frame = new Cvo_Frame("title_frame", this);
    frame->HorizontalChildren();
    pin = new Cvo_Pin("pin", frame);
    lab = new Cvo_Label("filter_label", frame, "Open File");
    lab->ExpandFrame();

    char *t = GetResource(_QTitle, _Qtitle, savefile ? "Save" : "Open");
    t = ExpandName(t);
    lab->SetText(t);
    delete [] t;

    new Cvo_Separator(this);

    lab = new Cvo_Label("dirfile_label", this, "Directory and File name:");
    lab->SetGravity(Cvo_WEST);

    file = new Cvo_Input("file", this);

    lab->SetFocus(file);	// Default text to the main input window

    if (!savefile) {
	lab = new Cvo_Label("filter_label", this, "File Filter:");
	lab->SetGravity(Cvo_WEST);

	filter = new Cvo_Input("filter", this);
	filter->SetText("*");
  	lab->SetFocus(filter);
    } else
	filter = 0;

    lists = new Cvo_Frame("lists", this);
    lists->ExpandFrame();

    frame = new Cvo_Frame("dirframe", lists);
    frame->ExpandFrame();
    frame->VerticalChildren();

    lab = new Cvo_Label("dir_label", frame, "Directories:");
    lab->SetGravity(Cvo_WEST);
    
    dirs = new Cvo_List("directories", frame, dirpage);
    dirs->UseRadioStyle();
    dirs->ExpandFrame();
    dirs->SetMinSize(16,8);
    dirs->Text()->Register(CvoCreatedEvent, Cvo__OpenFileCreatedDirectory, this);

    frame = new Cvo_Frame("fileframe", lists);
    frame->ExpandFrame();
    frame->VerticalChildren();

    lab = new Cvo_Label("file_label", frame, "Files:");
    lab->SetGravity(Cvo_WEST);

    files = new Cvo_List("files", frame, filepage);
    files->UseRadioStyle();
    files->ExpandFrame();
    files->SetMinSize(16,8);
    files->Text()->Register(CvoCreatedEvent, Cvo__OpenFileCreatedFiles, this);

    buttons = new Cvo_Frame("buttons", this);

    b = new Cvo_Button(savefile ? "save" : "open", buttons);
    b->SetDefaultText(savefile ? "Save" : "Open");
    b->ExpandFrame();
    b->SetMinSize(15, 1);
    b->Register(CvoButtonUpEvent, &Cvo__OpenFile_Okay, this);

    b = new Cvo_Button("dismiss", buttons);
    b->SetDefaultText("Dismiss");
    b->ExpandFrame();
    b->SetMinSize(15, 1);
    b->Register(CvoButtonUpEvent, &Cvo__OpenFile_Cancel, this);
    pin->Register(CvoButtonUpEvent, &Cvo__OpenFile_Cancel, this);

    if (filter)
	filter->Register(CvoInputEnteredEvent, &Cvo__OpenFile_NewFilter, this);
    file->Register(CvoInputEnteredEvent, &Cvo__OpenFile_UseFile, this);
    dirs->Register(CvoListItemSelectedEvent, &Cvo__OpenFile_NewDir, this);
    files->Register(CvoListItemSelectedEvent, &Cvo__OpenFile_NewFile, this);
    CVO_VOID_RETURN
}

void
Cvo__OpenFileCreatedDirectory(Cvo_Object *, XEvent *, void *v)
{
    Cvo__OpenFile *of = (Cvo__OpenFile *)v;

    of->dirgray = of->dirs->Text()->NewTextAttribute();
    of->dirgray->SetForeground(of->dirgray->Foreground()->Grayed());
    if (of->files->Text()->Object()) {
	of->dirstat.st_ino = 0;
	of->NewDirectory();
    }
}

void
Cvo__OpenFileCreatedFiles(Cvo_Object *, XEvent *, void *v)
{
    Cvo__OpenFile *of = (Cvo__OpenFile *)v;

    of->filegray = of->files->Text()->NewTextAttribute();
    of->filegray->SetForeground(of->filegray->Foreground()->Grayed());
    if (of->dirs->Text()->Object()) {
	of->dirstat.st_ino = 0;
	of->NewDirectory();
    }
}

void
Cvo__OpenFile::NewFilter()
{   CVO_ENTER
    CVO_VOID_RETURN
}

int
Cvo__OpenFile::NewDirectory(char *dir)
{   CVO_ENTER
    char tdir[MAXPATHLEN];

    struct stat sb;
    DIR *dirp;
    char *pat;

    static char *cwd = 0;		// Current working directory
    static int cwdlen = 0;

    if (!dir && !(dir = cwd)) {
	if ((directory)&&(strlen(directory))) {
	    dir = directory;
	} else {
	    cwd = new char [cwdlen = 256];

	    while ((dir = getcwd(cwd, cwdlen)) == 0 && errno == ERANGE) {
		delete [] cwd;
		cwd = new char [cwdlen += 256];
	    }
	    if (!dir) {
		delete [] cwd;
		dir = cwd = "/";
	    }
	}
    } else {
	strncpy(tdir, dir, MAXPATHLEN);
	dir = tdir;
    }
    dir = glob(dir);

    for (pat = dir; *pat; ++pat)
	;

    if (stat(dir, &sb) == 0 && S_ISDIR(sb.st_mode)) {
	if (pat[-1] != '/')
	    *pat++ = '/';
	    *pat = '\0';
    } else {
	while (--pat >= dir && *pat != '/')
	    ;
	if (pat >= dir) {
	    *++pat = '\0';
	} else {
	    dir = "/";
	}
	if (stat(dir, &sb) || !S_ISDIR(sb.st_mode)) {
	    XBell(Dpy(), 0);
	    CVO_RETURN(0)
	}
    }

    if (sb.st_ino == dirstat.st_ino &&
	sb.st_dev == dirstat.st_dev &&
	sb.st_mtime == dirstat.st_mtime &&
	sb.st_size == dirstat.st_size
	&& !dirtydir) {

	//
	// This is the case that we are re-reading the same directory
	// but it has not changed since the last time we read it...
	//
	CVO_RETURN(1)
    }
    dirtydir = False;
    dirstat = sb;

    dirp = opendir(dir);
    if (!dirp) {
	dirstat.st_ino = 0;
	perror(dir);
	XBell(Dpy(), 0);
	CVO_RETURN(0)
    }
    if (directory != dir) {
	strcpy(directory, dir);
	filename = directory;
	while (*filename)
	    ++filename;
	while (filename > directory && filename[-1] == '/')
	    --filename;
	*filename++ = '/';
	*filename = '\0';
    }

    file->SetText(directory);
    file->Flush(2);

    dirpage->DeleteEntry();
    filepage->DeleteEntry();

    struct dirent *dp;

    if (filter) {
	pat = filter->GetText();
	char *epat = pat;
	while (*epat)
	    ++epat;
	while (epat > pat && epat[-1] == ' ')
	    --epat;
	*epat = 0;

	if (!*pat)
	    pat = "*";
    } else
	pat = "*";

    while (dp = readdir(dirp)) {

	strcpy(filename, dp->d_name);
	if (stat(directory, &sb) == -1)
	    continue;

	if (S_ISDIR(sb.st_mode)) {
	    if (strcmp(dp->d_name, ".") && access(directory, X_OK|R_OK) == 0)
		dirpage->InsertText(dp->d_name, 0);
	} else if (Cvo_FileFilter(pat, dp->d_name)) {
  	    Cvo_TextAttribute *a = access(directory, savefile ? W_OK : R_OK)
			? filegray : files->Text()->TextAttribute();
	    filepage->SetAttribute(a);
	    filepage->InsertText(dp->d_name, 0);
	}
    }
    
    dirpage->InsertText((char *)0, 1);
    filepage->InsertText((char *)0, 1);
    *filename = '\0';
    closedir(dirp);
    CVO_RETURN(1)
}

void
Cvo__OpenFile_NewFilter(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;
    of->dirtydir = True;
    of->NewDirectory(of->directory);
    CVO_VOID_RETURN
}

void
Cvo__OpenFile_Cancel(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;

    of->pin->ForceOff();
    of->Unmap();

    if (of->transient) {
        Cvo_OpenFileEvent ofse;
        ofse.filename = 0;
        ofse.data = of->data;
        of->transient->SendEvent(CvoOpenFileEvent, &ofse);
    }
    CVO_VOID_RETURN
}

void
Cvo__OpenFile_Okay(Cvo_Object *obj, XEvent *, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;
    char *s = glob(of->file->GetText());
    struct stat sb;

    obj = obj->RootObject();

    if (stat(s, &sb) < 0) {
	if (of->savefile)
	    goto okay;
	XBell(of->Dpy(), 0);
	Cvo_Inform("nosuchfile", obj);
	CVO_VOID_RETURN
    }

    if (S_ISDIR(sb.st_mode)) {
	of->NewDirectory(s);
    } else if (access(s, of->savefile ? W_OK : R_OK)) {
	XBell(of->Dpy(), 0);
	Cvo_Inform(of->savefile ? "nowriteaccess" : "noreadaccess", obj);
	CVO_VOID_RETURN
    } else {
	if (of->savefile && !Cvo_Confirm("reallywrite", obj))
	    CVO_VOID_RETURN
okay:
	int x = strlen(s) + 1;
	if (of->acceptlen < x) {
	    of->acceptlen = (x + 0x20) & ~0x1f;
	    delete [] of->accept;
	    of->accept = new char[of->acceptlen];
	}
	strcpy(of->accept, s);

	if (!of->pin->Pressed()) {
	    of->Unmap();
	}

	if (of->transient) {
	    Cvo_OpenFileEvent ofse;
	    ofse.filename = of->accept;
	    ofse.data = of->data;
	    of->transient->SendEvent(of->savefile ? CvoSaveFileEvent
						  : CvoOpenFileEvent, &ofse);
	}
    }
    CVO_VOID_RETURN
}

void
Cvo__OpenFile::SetFullName(char *dir)
{   CVO_ENTER
    char *f = strrchr(dir, '/');
    if (!f) {
	SetFilename(dir);
    } else {
	*f = 0;
	if (SetDirectory(dir)) {
	    SetFilename(f+1);
	}
	*f = '/';
    }
    CVO_VOID_RETURN
}

void
Cvo__OpenFile::SetFilter(char *filt)
{   CVO_ENTER
    if (!filter)
	CVO_VOID_RETURN
    filter->SetText(filt);
    NewDirectory();
    CVO_VOID_RETURN
}

void
Cvo__OpenFile::SetFilename(char *s)
{   CVO_ENTER
    struct stat sb;
    if (s)
	strcpy(filename, s);
    else
	*filename = 0;

    char *f = filename;
    while (*f)
	++f;
    while (f > filename && f[-1] == ' ')
	--f;
    *f = 0;

    if (stat(directory, &sb) < 0 || S_ISDIR(sb.st_mode))
	*filename = 0;
    file->SetText(directory);
    file->Flush();
    CVO_VOID_RETURN
}

void
Cvo__OpenFile_UseFile(Cvo_Object *obj, XEvent *ev, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;
    Cvo_InputEnteredEvent *iee = (Cvo_InputEnteredEvent *)ev;
    struct stat sb;

    obj = obj->RootObject();

    char *s = glob(iee->text);

    if (stat(s, &sb) < 0) {
	if (of->savefile)
	    goto okay;
	XBell(of->Dpy(), 0);
	Cvo_Inform("nosuchfile", obj);
	CVO_VOID_RETURN
    }
    if (S_ISDIR(sb.st_mode)) {
	of->NewDirectory(s);
    } else if (access(s, of->savefile ? W_OK : R_OK)) {
	XBell(of->Dpy(), 0);
	Cvo_Inform(of->savefile ? "nowriteaccess" : "noreadaccess", obj);
	CVO_VOID_RETURN
    } else if (s == iee->text) {
	if (of->savefile && !Cvo_Confirm("reallywrite", obj))
	    CVO_VOID_RETURN
okay:
	int x = strlen(s) + 1;
	if (of->acceptlen < x) {
	    of->acceptlen = (x + 0x20) & ~0x1f;
	    delete [] of->accept;
	    of->accept = new char[of->acceptlen];
	}
	strcpy(of->accept, s);

	if (!of->pin->Pressed()) {
	    of->Unmap();
	}

	if (of->transient) {
	    Cvo_OpenFileEvent ofse;
	    ofse.filename = of->accept;
	    ofse.data = of->data;
	    of->transient->SendEvent(of->savefile ? CvoSaveFileEvent
						  : CvoOpenFileEvent, &ofse);
	}
    } else {
	of->file->SetText(s);
	of->file->Flush(2);
    }
    CVO_VOID_RETURN
}

void
Cvo__OpenFile_NewDir(Cvo_Object *, XEvent *ev, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;
    
    Cvo_ListItemSelectedEvent *lise = (Cvo_ListItemSelectedEvent *)ev;

    if (lise->line < 0)
	CVO_VOID_RETURN

    char *file = 0;
    if (lise->item)
	file = (char *)((Cvo_Page *)lise->item)->GetLine(lise->line);

    if (!file)
	return;

    if (strcmp(file, "..")) {
	strcpy(of->filename, file);
	while (*of->filename)
	    ++of->filename;
	*of->filename++ = '/';
    } else if (of->filename == of->directory) {
	*of->filename++ = '/';
    } else if (!strcmp(of->directory, "/")) {
	of->filename = of->directory + 1;
    } else {
	--of->filename;
	while (--of->filename >= of->directory && *of->filename != '/')
	    ;
	if (of->filename < of->directory)
	    of->filename = of->directory;
	*of->filename++ = '/';
    }
    *of->filename = '\0';
    of->NewDirectory(of->directory);
    CVO_VOID_RETURN
}

void
Cvo__OpenFile_NewFile(Cvo_Object *obj, XEvent *ev, void *w)
{   CVO_ENTER
    Cvo__OpenFile *of = (Cvo__OpenFile *)w;

    Cvo_ListItemSelectedEvent *lise = (Cvo_ListItemSelectedEvent *)ev;

    if (lise->count > 0) {
	Cvo__OpenFile_Okay(obj, ev, w);
	CVO_VOID_RETURN
    }

    char *file = 0;
    if (lise->item)
	file = (char *)((Cvo_Page *)lise->item)->GetLine(lise->line);

    if (lise->line >= 0 && file)
	strcpy(of->filename, file);
    else
	of->filename[0] = 0;
    of->file->SetText(of->directory);
    of->file->Flush(2);

    CVO_VOID_RETURN
}

static char *
glob(char *s)
{   CVO_ENTER
    while (*s == ' ' || *s == '\t')
	++s;
    char *e = s;
    while (*e)
	++e;
    while (e > s && (e[-1] == ' ' || e[-1] == '\t'))
	--e;
    *e = 0;

    if (!strpbrk(s, "~[*?${"))
	CVO_RETURN(s)

    static char *SHELL = 0;

    if (!SHELL) {
	SHELL = getenv("SHELL");
	if (!SHELL) {
	    struct passwd *pw = getpwuid(getuid());
	    if (pw && access(pw->pw_shell, X_OK) == 0) {
		SHELL = new char [strlen(pw->pw_shell) + 1];
	        strcpy(SHELL, pw->pw_shell);
	    } else {
		SHELL = "/bin/sh";
	    }
	}
    }

    int p[2];

    if (pipe(p)) {
	// XXX - should be a real error message
	perror("pipe");
	CVO_RETURN(s)
    }

    static char *buf = 0;
    static int buflen = 0;

    int len = strlen(s);

    if (buflen < len + 8) {
	delete [] buf;
	buf = new char[buflen = len + 64];
    }
    sprintf(buf, "echo %s", s);

    pid_t pid;

    switch (pid = fork()) {
    case -1:
	// XXX - should be a real error message
	perror("fork");
	CVO_RETURN(s)
    case 0:
	close(p[0]);
	close(1);
	close(2);
	dup(p[1]);
	dup(p[1]);
	close(p[1]);
	execl(SHELL, "cvo-glob", "-c", buf, 0);
	exit(1);
    default:
	close(p[1]);
	break;
    }

    struct llist {
	char	str[256];
	int	used;
	llist	*next;
    };
    static llist *base = 0;

    llist *list;

    if (!(list = base)) {
	base = list = new llist;
	list->next = 0;
    }
    list->used = 0;

    int total = 0;

    for (;;) {
	char *b = list->str + list->used;
	int amt = sizeof(list->str) - list->used;

	if (amt == 0) {
	    if (!list->next)
		list->next =  new llist;
	    list = list->next;
	    list->used = 0;
	    list->next = 0;
	    b = list->str;
	    amt = sizeof(list->str);
	}
	amt = read(p[0], b, amt);
	if (amt < 1)
	    break;

	list->used += amt;
	total += amt;
    }
    if (list->next)
	list->next->used = 0;

    int status = -1;

    while (waitpid(pid, &status, 0) == -1 && errno == EINTR)
		;

    if (!WIFEXITED(status) || WEXITSTATUS(status))
	CVO_RETURN(s)

    static char *result;
    static int reslen = 0;

    if (reslen < total + 2) {
	delete [] result;
	result = new char[reslen = total+16];
    }
    char *pr = result;

    list = base;
    while (list && list->used) {
	strncpy(pr, list->str, list->used);
	pr += list->used;
	list = list->next;
    }

    while (pr > result && (pr[-1] == '\r' || pr[-1] == '\n')) {
	--pr;
    }
    *pr = 0;

    if (!strcmp(result, s))
	CVO_RETURN(s)

    //
    // Only ever take the first file found when file expansion is used...
    //
    pr = result;
    while (*pr != ' ' && *pr)
	++pr;
    *pr = '\0';
    CVO_RETURN(result)
}
