//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Paint.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Paint.h++>

static Cvo_Default def[] = {
    "*CvoPaint.Sunken:True",
};

CVO_BEGIN_BIND(Cvo_Paint)
CVO_DOBIND(Cvo_Paint, "Move", Move)
CVO_END_BIND(Cvo_Paint, Cvo_Window)

// static char *trans = "\
//        <Button2>: Move()\n\
// ";

CONSTRUCTORS_2ARG(Cvo_Paint, Cvo_Window, "CvoPaint", int, int)
CONSTRUCTORS(Cvo_Paint, Cvo_Window, "CvoPaint")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Paint) 

void
Cvo_Paint::_Init(int maxx, int maxy)
{   CVO_ENTER
    type = CvoT_Paint;
    LoadFont();
    pwidth = maxx > 0 ? maxx : 0;
    pheight = maxy > 0 ? maxy : 0;
    dirty = 0;
    realdirty = 0;
    pixmap = 0;
    altmap = 0;
    xoffset = 0;
    yoffset = 0;
    selectMask |= ButtonMotionMask;
    SetDefPixelSize(pwidth, pheight);
    Register(CvoResizeEvent, &Cvo_Paint::DoResize);
//  AddTranslations(trans);
    CVO_VOID_RETURN
}

void
Cvo_Paint::ResetCanvas(int maxx, int maxy, BOOL copy)
{   CVO_ENTER
    if (maxx > 0)
	pwidth = maxx;
    if (maxy > 0)
	pheight = maxy;

    int w = pwidth ? pwidth : Width();
    int h = pheight ? pheight : Height();

    Cvo_PaintChangedSizeEvent pcse;

    pcse.old_pwidth = altmap->Width();
    pcse.old_pheight = altmap->Height();

    if (altmap->Width() != w || altmap->Height() != h) {
	pixmap->Resize(w, h, copy);
	if (altmap != pixmap)
	    altmap->Resize(w, h, copy);

	if (xoffset < 0)
	    xoffset = 0;
	if (yoffset < 0)
	    yoffset = 0;

	if (xoffset + width > altmap->Width())
	    xoffset = altmap->Width() - width;
	if (yoffset + height > altmap->Height())
	    yoffset = altmap->Height() - height;

	if (xoffset < 0 || yoffset < 0)
	    Cvo_Window::Erase();

	if (xoffset < 0)
	    xoffset /= 2;
	if (yoffset < 0)
	    yoffset /= 2;
	realdirty = 1;
    }

    //
    // Need to generate the event as the window size might have changed
    // even if our pixmap did not.
    //
    pcse.pwidth = w;
    pcse.pheight = h;
    pcse.width = width;
    pcse.height = height;
    SendEvent(CvoPaintChangedSizeEvent, &pcse);

    CVO_VOID_RETURN
}

void
Cvo_Paint::_Create()
{   CVO_ENTER
    if (Object())
		CVO_VOID_RETURN
    Cvo_Window::_Create();

    int w = pwidth ? pwidth : width;
    int h = pheight ? pheight : height;

    pixmap = new Cvo_Pixmap(this, w, h);
    altmap = pixmap;

    Cvo_PaintChangedSizeEvent pcse;
    pcse.pwidth = w;
    pcse.pheight = h;
    pcse.old_pwidth = 0;
    pcse.old_pheight = 0;
    pcse.width = width;
    pcse.height = height;
    SendEvent(CvoPaintChangedSizeEvent, &pcse);
    CVO_VOID_RETURN
}

void
Cvo_Paint::DoResize(XEvent *, void *)
{   CVO_ENTER
    if (!altmap)
	CVO_VOID_RETURN

    ResetCanvas(pwidth, pheight);
    CVO_VOID_RETURN
}

void
Cvo_Paint::Exposure(XExposeEvent *ev)
{   CVO_ENTER
    int ex = realdirty ? 0 : ev->x;
    int ey = realdirty ? 0 : ev->y;
    int ew = realdirty ? width : ev->width;
    int eh = realdirty ? height : ev->height;

    if (ex < 0) {
	ew += ex;
	ex = 0;
    }
    if (ey < 0) {
	eh += ey;
	ey = 0;
    }

    if (xoffset + ex + ew > altmap->Width())
	ew = altmap->Width() - (xoffset + ex);

    if (yoffset + ey + eh > altmap->Height())
	eh = altmap->Height() - (yoffset + ey);

    if (ew > 0 && eh > 0) {
	altmap->CopyAreaTo(this, xoffset + ex, yoffset + ey, ew, eh, ex, ey);
	realdirty = 0;
    }
    Cvo_Window::Exposure(ev);
    CVO_VOID_RETURN
}

void
Cvo_Paint::Flush(int r)
{   CVO_ENTER
    if (dirty) {
	if (pixmap != altmap)
	    altmap->CopyTo(pixmap);
	dirty = 0;
	realdirty = 1;
    }

    if (realdirty) {
	int w = width;
	int h = height;
	if (xoffset + w > altmap->Width())
	    w = altmap->Width() - xoffset;

	if (yoffset + h > altmap->Height())
	    h = altmap->Height() - yoffset;

	altmap->CopyAreaTo(this, xoffset, yoffset, w, h, 0, 0);
	realdirty = 0;
    }
    Cvo_Window::Flush(r);
    CVO_VOID_RETURN
}

void
Cvo_Paint::ConvertCoord(int *x, int *y)
{   CVO_ENTER
    *x += xoffset;
    *y += yoffset;
    CVO_VOID_RETURN
}

void
Cvo_Paint::Erase()
{   CVO_ENTER
    altmap->ClearWindow();
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::EraseArea(int x, int y, int w, int h)
{   CVO_ENTER
    altmap->ClearArea(x, y, w, h);
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::SetWidth(int width)
{   CVO_ENTER
    altmap->SetLineAttributes(width, LineSolid, CapButt, JoinMiter);
    CVO_VOID_RETURN
}

void
Cvo_Paint::Fill(const Cvo_Color &color)
{   CVO_ENTER
    altmap->SetForeground(color);
    altmap->FillRectangle(0, 0, altmap->Width(), altmap->Height());
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::FillArea(int x, int y, int w, int h, const Cvo_Color &color)
{   CVO_ENTER
    altmap->SetForeground(color);
    altmap->FillRectangle(x, y, w, h);
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::DrawRectangle(int x, int y, int w, int h, const Cvo_Color &color)
{   CVO_ENTER
    altmap->SetForeground(color);
    altmap->DrawRectangle(x, y, w, h);
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::DrawLine(int x0, int y0, int x1, int y1, const Cvo_Color &color)
{   CVO_ENTER
    altmap->SetForeground(color);
    altmap->DrawLine(x0, y0, x1, y1);
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::DrawArc(int x, int y, int w, int h, int a1, int a2, const Cvo_Color &color)
{   CVO_ENTER
    altmap->SetForeground(color);
    altmap->DrawArc(x, y, w, h, a1, a2);
    dirty = 1;
    CVO_VOID_RETURN
}

void
Cvo_Paint::DrawShape(int x, int y, int shape, int size, const Cvo_Color &color)
{   CVO_ENTER
    if (shape < 0 || shape > CVOP_LAST_SHAPE)
        CVO_VOID_RETURN

    altmap->SetForeground(color);
    switch (shape) {
    case CVOP_CIRCLE_SHAPE:
        altmap->DrawArc(x - size/2, y - size/2, size, size, 0, 360 * 64);
        dirty = 1;
        break;
    case CVOP_DISC_SHAPE:
        altmap->DrawArc(x - size/2, y - size/2, size, size, 0, 360 * 64);
        altmap->FillArc(x - size/2, y - size/2, size, size, 0, 360 * 64);
        dirty = 1;
        break;
    case CVOP_POINT_SHAPE:
        altmap->DrawPoint(x, y);
        dirty = 1;
        break;
    case CVOP_BOX_SHAPE:
        altmap->DrawRectangle(x - size/2, y - size/2, size, size);
        dirty = 1;
        break;
    case CVOP_SQUARE_SHAPE:
        altmap->FillRectangle(x - size/2, y - size/2, size+1, size+1);
        dirty = 1;
        break;
    case CVOP_X_SHAPE: {
        XSegment seg[2];

        seg[0].x1 = x - size/2;
        seg[0].x2 = x + size/2;
        seg[0].y1 = y - size/2;
        seg[0].y2 = y + size/2;

        seg[1].x1 = x - size/2;
        seg[1].x2 = x + size/2;
        seg[1].y1 = y + size/2;
        seg[1].y2 = y - size/2;
        altmap->DrawSegments(seg, 2);
        dirty = 1;
        break;
      }
    default:
        break;
    }
    CVO_VOID_RETURN
}

void
Cvo_Paint::PanTo(int x, int y)
{
    if (!altmap)
	return;

    if (pwidth && pwidth > Width()) {
	if (x > pwidth - Width())
	    x = pwidth - Width();
    } else
	x = xoffset;

    if (pheight && pheight > Height()) {
	if (y > pheight - Height())
	    y = pheight - Height();
    } else
	y = yoffset;

    if (altmap->Width() < Width())
	x = -(Width() - altmap->Width())/2;
    if (altmap->Height() < Height())
	y = -(Height() - altmap->Height())/2;

    if (x == xoffset && y == yoffset)
	return;
    xoffset = x;
    yoffset = y;
    realdirty = 1;
}

void
Cvo_Paint::Move(XEvent *, int, char **)
{   CVO_ENTER
    if (altmap->Width() <= width && altmap->Height() <= height)
	CVO_VOID_RETURN

    int x, y;
    int ox, oy;

    QueryMouseLocation(&ox, &oy);

    for (;;) {
	XEvent ev;

	XMaskEvent(Dpy(),
		   ExposureMask |
		   PointerMotionHintMask |
		   ButtonMotionMask |
		   ButtonReleaseMask,
		   &ev);

	if (ev.type == ButtonRelease || ev.type == MotionNotify) {
	    QueryMouseLocation(&x, &y);

	    if (altmap->Width() > width) {
		xoffset += ox - x;
		if (xoffset < 0)
		    xoffset = 0;
		if (xoffset + width > altmap->Width())
		    xoffset = altmap->Width() - width;
		ox = x;
	    }
	    if (altmap->Height() > height) {
		yoffset += oy - y;
		if (yoffset < 0)
		    yoffset = 0;
		if (yoffset + height > altmap->Height())
		    yoffset = altmap->Height() - height;
		oy = y;
	    }
	    realdirty = 1;
	    Flush(2);

	    if (ev.type == ButtonRelease)
		CVO_VOID_RETURN
	} else {
	    _Cvo_event(&ev);
	}
    }
}
