//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: PinUp.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/PinUp.h++>
#include <Cvo/Pin.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>

CONSTRUCTORS_1ARG(Cvo_PinUp, Cvo_Window, "CvoPinUp", char *)

Cvo_PinUp::Cvo_PinUp(char *res, char *title)
	 : Cvo_Window(res, "CvoPinUp", Cvo_MAINWINDOW)
{
    _Init(title);
}

void
Cvo_PinUp::_Init(char *title)
{   CVO_ENTER

    if (!title)
	title = Name();

    VerticalChildren();
    Cvo_Frame *frame = new Cvo_Frame("title_frame", this);
    frame->HorizontalChildren();
    pin = new Cvo_Pin("pin", frame);
    pin->Register(CvoButtonUpEvent, _Cvo_PinUp_Dismiss, this);

    label = new Cvo_Label("title", frame, title);
    label->ExpandFrame();

    new Cvo_Separator(this);
    
    CVO_VOID_RETURN
}

void
Cvo_PinUp::Used()
{
    if (!pin->Pressed())
	delete (Cvo_PinUp *)this;
}

void
Cvo_PinUp::Pinned(BOOL v)
{
    if (v)
	pin->ForceOn();
    else
	pin->ForceOff();
}

void
Cvo_PinUp::SetText(char *s)
{
    label->SetText(s);
}


void
Cvo_PinUp::SetText(wchar_t *s)
{
    label->SetText(s);
}

void
_Cvo_PinUp_Dismiss(Cvo_Object *, XEvent *, void *d)
{   CVO_ENTER
    Cvo_PinUp *pu = (Cvo_PinUp *) d;
    Cvo_AnyEvent ev;

    pu->SendEvent(CvoDismissedEvent, &ev);
    delete pu;
    CVO_VOID_RETURN
}
