//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Pixmap.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Pixmap.h++>
#include <Cvo/Window.h++>

Cvo_Pixmap::Cvo_Pixmap(Cvo_Window *p, int _width, int _height, int _depth)
	  : Cvo_BasicObject(p)
{   CVO_ENTER
    if (!(width = _width))
	width = 1;
    if (!(height = _height))
	height = 1;
    if (!(depth = _depth))
	depth = p->Depth();
    awidth = aheight = 0;

    // XXX - should check for success here.

    window = XCreatePixmap(p->Dpy(), p->Root(), width, height, depth);


    background = p->CurrentBackground();
    foreground = p->CurrentForeground();

    textAttribute = 0;
    new Cvo_TextAttribute(&textAttribute, this, p->TextAttribute()->Font());

    XGCValues xgcv;
    xgcv.graphics_exposures = False;
    gc = XCreateGC(Dpy(), Object(), GCGraphicsExposures, &xgcv);
    SetBackground(background);

    ClearWindow();
    SetForeground(foreground);
    CVO_VOID_RETURN
}

Cvo_Pixmap::Cvo_Pixmap(Cvo_Pixmap *p, int _width, int _height, int _depth)
	  : Cvo_BasicObject(p)
{   CVO_ENTER
    width = _width;
    height = _height;
    if (!(depth = _depth))
	depth = p->Depth();

    // XXX - should check for success here.

    window = XCreatePixmap(p->Dpy(), p->Root(), width, height, depth);

    background = p->Background();
    foreground = p->Foreground();

    textAttribute = 0;
    new Cvo_TextAttribute(&textAttribute, this, p->TextAttribute()->Font());

    gc = p->SaveGC();

    ClearWindow();
    SetForeground(foreground);
    CVO_VOID_RETURN
}

void
Cvo_Pixmap::AllowPartials()
{
    if (awidth)
	return;
    awidth = width;
    aheight = height;
}

void
Cvo_Pixmap::Resize(int nw, int nh, BOOL copy)
{   CVO_ENTER
    if (!nw || !nh)
	return;

    if (nw == width && nh == height)
	CVO_VOID_RETURN

    if (nw <= awidth && nh <= aheight) {
	width = nw;
	height = nh;
	CVO_VOID_RETURN
    }

    Pixmap op = Object();

    if (!copy)
	XFreePixmap(Dpy(), op);

    window = XCreatePixmap(Dpy(), Root(), nw, nh, depth);
    if (awidth) {
	awidth = nw;
	aheight = nh;
    }

    if (!copy) {
	SetForeground(foreground);
	width = nw;
	height = nh;
	CVO_VOID_RETURN
    }

    if (nw > width || nh > height) {
	width = nw;
	height = nh;
	ClearWindow();
    } else {
	width = nw;
	height = nh;
    }
    SetForeground(foreground);
    XCopyArea(Dpy(), op, Object(), gc, 0, 0, width, height, 0, 0);
    XFreePixmap(Dpy(), op);
    width = nw;
    height = nh;
    CVO_VOID_RETURN
}

GC
Cvo_Pixmap::SaveGC()
{   CVO_ENTER
	Cvo_Lock lock;

	GC ngc = XCreateGC(Dpy(), Object(), 0, 0);
	XCopyGC(Dpy(), gc, 0xffff, ngc);
	CVO_RETURN(ngc)
}

void
Cvo_Pixmap::RestoreGC(GC ogc)
{   CVO_ENTER
	Cvo_Lock lock;

	XCopyGC(Dpy(), ogc, 0xffff, gc);
	XFreeGC(Dpy(), ogc);
    CVO_VOID_RETURN
}

//
// The functions are supposed to be inlined, but the compiler won't do it
//
int Cvo_Pixmap::StringWidth(char *str, int len)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringWidth(str, len))
}
int Cvo_Pixmap::StringWidth(wchar_t *str, int len)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringWidth(str, len))
}

int Cvo_Pixmap::StringHeight(char * s, int i)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringHeight(s, i))
}
int Cvo_Pixmap::StringHeight(wchar_t *s, int i)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringHeight(s, i))
}

int
Cvo_Pixmap::StringsExtents(char *s, int n, XRectangle &log)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringsExtents(s, n, log))
}

int
Cvo_Pixmap::StringsExtents(wchar_t *s, int n, XRectangle &log)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringsExtents(s, n, log))
}
