//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: PrintEvent.cc,v 1.4 1994/08/10 18:26:36 prb Exp $"); }
#include <stdio.h>
#include <Cvo/BasicButton.h++>
#include <Cvo/CRT.h++>
#include <Cvo/EventTypes.h++>
#include <Cvo/Help.h++>
#include <Cvo/Input.h++>
#include <Cvo/List.h++>
#include <Cvo/Menu.h++>
#include <Cvo/Object.h++>
#include <Cvo/OpenFile.h++>
#include <Cvo/Page.h++>
#include <Cvo/RadioBox.h++>
#include <Cvo/ScrollBar.h++>

int _cvo_full_names = 1;

void
PrintGeneric(FILE *fp, XEvent *ev, char *name, Cvo_Object *obj)
{   CVO_ENTER
    fprintf(fp, "Event type %s (%04x)%s\n", name, ev->xany.type,
		ev->xany.send_event ? "[SendEvent]" : "");

    if (!_Cvo_IsCvoEvent(ev) && !obj)
	    obj = Cvo_FindWindow(ev->xany.display, ev->xany.window);
    if (_Cvo_IsCvoEvent(ev) || obj) {
	if (!obj)
	    obj = ((Cvo_AnyEvent *)ev)->win;
	fprintf(fp, "    Object: %s\n", _cvo_full_names ? obj->FullName()
							: obj->Name());
    }

    fprintf(fp, "    Serial: %8x  Window: %8x  Display: %8x\n",
		ev->xany.serial, ev->xany.window, ev->xany.display);
    CVO_VOID_RETURN
}

static BOOL (*EventFilter)(Cvo_Object *, XEvent *) = 0;

void
Cvo_SetPrintEventFilter(BOOL (*ef)(Cvo_Object *, XEvent *))
{
    EventFilter = ef;
}

void
Cvo_PrintEvent(FILE *fp, XEvent *ev, Cvo_Object *obj)
{   CVO_ENTER

    if (EventFilter && EventFilter(obj, ev) == False)
	return;

    switch(ev->type) {
    case ButtonPress:
	PrintGeneric(fp, ev, "ButtonPress", obj);
	goto L1;
    case ButtonRelease:
	PrintGeneric(fp, ev, "ButtonRelease", obj);
    L1: {
	XButtonEvent *be = (XButtonEvent *)ev;
	fprintf(fp, "    Root: %8x  Subwindow: %8x  Time: %8x\n",
		be->root, be->subwindow, be->time);
	fprintf(fp, "    (%d,%d) [%d,%d]\n", be->x, be->y, be->x_root, be->y_root);
	fprintf(fp, "    State: %8x  Button: %d%s\n",
			be->state, be->button,
			be->same_screen ? "  [Same Screen]" : "");
      }
	break;

    case CirculateNotify:
	PrintGeneric(fp, ev, "CirculateNotify", obj);
	goto L2;
    case CirculateRequest:
	PrintGeneric(fp, ev, "CirculateRequest", obj);
    L2: {
	XCirculateEvent *cn = (XCirculateEvent *)ev;
	fprintf(fp, "  Restacked %8x %s (%d)\n",
		cn->window,
		cn->place == PlaceOnTop ? "PlaceOnTop"
		: cn->place == PlaceOnBottom ? "PlaceOnBottom"
		: "UnknownPlace",
		cn->place);
      }
	break;
    case ClientMessage:
	PrintGeneric(fp, ev, "ClientMessage", obj);
	break;
    case ColormapNotify:
	PrintGeneric(fp, ev, "ColormapNotify", obj);
	break;
    case ConfigureNotify:
	PrintGeneric(fp, ev, "ConfigureNotify", obj);
      {
	XConfigureEvent *ce = (XConfigureEvent *)ev;
	fprintf(fp, "    Configure %8x above %8x %s\n",
		ce->window, ce->above,
		ce->override_redirect ? "[Override Redirect]" : "");
	fprintf(fp, "    (%d,%d) %dx%d [%d]\n",
		ce->x, ce->y, ce->width, ce->height, ce->border_width);
      }
	break;
    case ConfigureRequest:
	PrintGeneric(fp, ev, "ConfigureRequest", obj);
      {
	XConfigureRequestEvent *ce = (XConfigureRequestEvent *)ev;
	fprintf(fp, "    Configure %8x above %8x  Detail: %s (%d)\n",
		ce->window, ce->above,
		ce->detail == Above ? "Above" :
		ce->detail == Below ? "Below" :
		ce->detail == TopIf ? "TopIf" :
		ce->detail == BottomIf ? "BottomIf" :
		ce->detail == Opposite ? "Opposite" : "Unknown",
		ce->detail);
	fprintf(fp, "    (%d,%d) %dx%d [%d]\n",
		ce->x, ce->y, ce->width, ce->height, ce->border_width);
	fprintf(fp, "    Value Mask: %8x\n", ce->value_mask);
      }
	break;
    case CreateNotify:
	PrintGeneric(fp, ev, "CreateNotify", obj);
      {
	XCreateWindowEvent *ce = (XCreateWindowEvent *)ev;
	fprintf(fp, "    Create %8x %s\n",
		ce->window, ce->override_redirect ? "[Override Redirect]" : "");
	fprintf(fp, "    (%d,%d) %dx%d [%d]\n",
		ce->x, ce->y, ce->width, ce->height, ce->border_width);
      }
	break;
    case DestroyNotify:
	PrintGeneric(fp, ev, "DestroyNotify", obj);
      {
	XCreateWindowEvent *ce = (XCreateWindowEvent *)ev;
	fprintf(fp, "    Destroy %8x\n", ce->window);
      }
	break;
    case EnterNotify:
	PrintGeneric(fp, ev, "EnterNotify", obj);
    	goto L7;
    case LeaveNotify:
	PrintGeneric(fp, ev, "LeaveNotify", obj);
    L7: {
	XCrossingEvent *ce = (XCrossingEvent *)ev;
	fprintf(fp, "    Root: %8x  Subwindow: %8x  Time: %8x  State: %8x\n",
		ce->root, ce->subwindow, ce->time, ce->state);
	fprintf(fp, "    (%d,%d) [%d,%d]\n", ce->x, ce->y, ce->x_root, ce->y_root);
	fprintf(fp, "    Mode: %s (%d)  Detail: %s (%d)  Focus: %s\n",
			ce->mode == NotifyNormal ? "NotifyNormal" :
			ce->mode == NotifyGrab ? "NotifyGrab" :
			ce->mode == NotifyUngrab ? "NotifyUngrab" :
			"Unknown",
			ce->mode,
			ce->detail == NotifyAncestor ? "NotifyAncestor" :
			ce->detail == NotifyVirtual ? "NotifyVirtual" :
			ce->detail == NotifyInferior ? "NotifyInferior" :
			ce->detail == NotifyNonlinear ? "NotifyNonlinear" :
			ce->detail == NotifyNonlinearVirtual ? "NotifyNonlinearVirtual" :
			"Unknown",
			ce->detail,
			ce->focus ? "True" : "False");
      }
	break;
    case Expose:
	PrintGeneric(fp, ev, "Expose", obj);
      {
	XExposeEvent *ce = (XExposeEvent *)ev;
	fprintf(fp, "    (%d,%d) %dx%d [%d]\n",
		ce->x, ce->y, ce->width, ce->height, ce->count);
      }
	break;
    case FocusIn:
	PrintGeneric(fp, ev, "FocusIn", obj);
	goto L9;
    case FocusOut:
	PrintGeneric(fp, ev, "FocusOut", obj);
    L9: {
	XFocusChangeEvent *ce = (XFocusChangeEvent *)ev;
	fprintf(fp, "    Mode: %s (%d)  Detail: %s (%d)\n",
			ce->mode == NotifyNormal ? "NotifyNormal" :
			ce->mode == NotifyGrab ? "NotifyGrab" :
			ce->mode == NotifyUngrab ? "NotifyUngrab" :
			"Unknown",
			ce->mode,
			ce->detail == NotifyAncestor ? "NotifyAncestor" :
			ce->detail == NotifyVirtual ? "NotifyVirtual" :
			ce->detail == NotifyInferior ? "NotifyInferior" :
			ce->detail == NotifyNonlinear ? "NotifyNonlinear" :
			ce->detail == NotifyNonlinearVirtual ? "NotifyNonlinearVirtual" :
			ce->detail == NotifyPointer ? "NotifyPointer" :
			ce->detail == NotifyPointerRoot ? "NotifyPointerRoot" :
			ce->detail == NotifyDetailNone ? "NotifyDetailNone" :
			"Unknown",
			ce->detail);
      }
	break;
    case GraphicsExpose:
	PrintGeneric(fp, ev, "GraphicsExpose", obj);
      {
	XGraphicsExposeEvent *ce = (XGraphicsExposeEvent *)ev;
	fprintf(fp, "    (%d,%d) %dx%d [%d]\n",
		ce->x, ce->y, ce->width, ce->height, ce->count);
	fprintf(fp, "    Major: %s (%d)  Minor: %d\n",
		ce->major_code == 62 ? "CopyArea" :
		ce->major_code == 63 ? "CopyPlane" :
		"(extension defined)",
		ce->major_code, ce->minor_code);
      }
	break;
    case NoExpose:
	PrintGeneric(fp, ev, "NoExpose", obj);
      {
	XNoExposeEvent *ce = (XNoExposeEvent *)ev;
	fprintf(fp, "    Major: %s (%d)  Minor: %d\n",
		ce->major_code == 62 ? "CopyArea" :
		ce->major_code == 63 ? "CopyPlane" :
		"(extension defined)",
		ce->major_code, ce->minor_code);
      }
	break;
    case GravityNotify:
	PrintGeneric(fp, ev, "GravityNotify", obj);
      {
	XGravityEvent *ce = (XGravityEvent *)ev;
	fprintf(fp, "    Moved: %8x  To: (%d,%d)\n",
		ce->window, ce->x, ce->y);
      }
	break;
    case KeymapNotify:
	PrintGeneric(fp, ev, "KeymapNotify", obj);
	break;
    case KeyPress:
	PrintGeneric(fp, ev, "KeyPress", obj);
	goto Ld;
    case KeyRelease:
	PrintGeneric(fp, ev, "KeyRelease", obj);
    Ld: {
	XKeyEvent *ce = (XKeyEvent *)ev;
	fprintf(fp, "    Root: %8x  Subwindow: %8x  Time: %8x  State: %8x\n",
		ce->root, ce->subwindow, ce->time, ce->state);
	fprintf(fp, "    Keycode: %8x\n", ce->keycode);
	fprintf(fp, "    (%d,%d) [%d,%d]\n", ce->x, ce->y, ce->x_root, ce->y_root);
      }
	break;
    case MapNotify:
	PrintGeneric(fp, ev, "MapNotify", obj);
      {
	XMapEvent *ce = (XMapEvent *)ev;
	fprintf(fp, "    Map: %8x%s\n",
		ce->window, ce->override_redirect ? "  [Override Redirect]" : "");
      }
	break;
    case UnmapNotify:
	PrintGeneric(fp, ev, "MapNotify", obj);
      {
	XUnmapEvent *ce = (XUnmapEvent *)ev;
	fprintf(fp, "    Unmap: %8x%s\n",
		ce->window, ce->from_configure ? "  [From Configure]" : "");
      }
	break;
    case MapRequest:
	PrintGeneric(fp, ev, "MapRequest", obj);
      {
	XMapRequestEvent *ce = (XMapRequestEvent *)ev;
	fprintf(fp, "    Request: %8x\n", ce->window);
      }
	break;
    case MappingNotify:
	PrintGeneric(fp, ev, "MappingNotify", obj);
	break;
    case MotionNotify:
	PrintGeneric(fp, ev, "MotionNotify", obj);
      {
	XMotionEvent *ce = (XMotionEvent *)ev;
	fprintf(fp, "    Root: %8x  Subwindow: %8x  Time: %8x  State: %8x\n",
		ce->root, ce->subwindow, ce->time, ce->state);
	fprintf(fp, "    (%d,%d) [%d,%d]\n", ce->x, ce->y, ce->x_root, ce->y_root);
      }
	break;
    case PropertyNotify:
	PrintGeneric(fp, ev, "PropertyNotify", obj);
	break;
    case ReparentNotify:
	PrintGeneric(fp, ev, "ReparentNotify", obj);
	break;
    case ResizeRequest:
	PrintGeneric(fp, ev, "ResizeRequest", obj);
	break;
    case SelectionClear:
	PrintGeneric(fp, ev, "SelectionClear", obj);
	break;
    case SelectionNotify:
	PrintGeneric(fp, ev, "SelectionNotify", obj);
	break;
    case SelectionRequest:
	PrintGeneric(fp, ev, "SelectionRequest", obj);
	break;
    case VisibilityNotify:
	PrintGeneric(fp, ev, "VisibilityNotify", obj);
	break;

    case CvoKeyTextEvent:
	PrintGeneric(fp, ev, "CvoKeyTextEvent", obj);
      {
	Cvo_KeyTextEvent *ce = (Cvo_KeyTextEvent *)ev;
	fprintf(fp, "    Root: %8x  Subwindow: %8x  Time: %8x  State: %8x\n",
		ce->root, ce->subwindow, ce->time, ce->state);
	fprintf(fp, "    Keycode: %8x\n", ce->keycode);
	fprintf(fp, "    (%d,%d) [%d,%d]\n", ce->x, ce->y, ce->x_root, ce->y_root);
	fprintf(fp, "    Have Symbol: %s  Have Text: %s\n",
		ce->have_sym ? "True" : "False",
		ce->have_text ? "True" : "False");
      }
	break;
    case CvoHelpEvent:
	PrintGeneric(fp, ev, "CvoHelpEvent", obj);
	break;
    case CvoDestroyedEvent:
	PrintGeneric(fp, ev, "CvoDestroyedEvent", obj);
	break;
    case CvoResizeEvent:
	PrintGeneric(fp, ev, "CvoResizeEvent", obj);
      {
	Cvo_ResizeEvent *ce = (Cvo_ResizeEvent *)ev;
	fprintf(fp, "    Old: %dx%d  New: %dx%d\n",
		ce->old_width, ce->old_height, ce->new_width, ce->new_height);
      }
	break;
    case CvoMovedEvent:
	PrintGeneric(fp, ev, "CvoMovedEvent", obj);
      {
	Cvo_MovedEvent *ce = (Cvo_MovedEvent *)ev;
	fprintf(fp, "    Old: %d,%d  New: %d,%d\n",
		ce->old_x, ce->old_y, ce->new_x, ce->new_y);
      }
	break;
    case CvoFocusInEvent:
	PrintGeneric(fp, ev, "CvoFocusInEvent", obj);
	break;
    case CvoFocusOutEvent:
	PrintGeneric(fp, ev, "CvoFocusOutEvent", obj);
	break;
    case CvoMapRequestEvent:
	PrintGeneric(fp, ev, "CvoMapRequestEvent", obj);
	break;
    case CvoUnmapRequestEvent:
	PrintGeneric(fp, ev, "CvoUnmapRequestEvent", obj);
	break;

    case CvoButtonDownEvent:
	PrintGeneric(fp, ev, "CvoButtonDownEvent", obj);
	goto Lk;
    case CvoButtonUpEvent:
	PrintGeneric(fp, ev, "CvoButtonUpEvent", obj);
    Lk: {
	Cvo_ButtonEvent *ce = (Cvo_ButtonEvent *)ev;
	fprintf(fp, "    Button: %d  Value %d\n", ce->button, ce->value);
      }
	break;
    case CvoTextChangedSizeEvent:
	PrintGeneric(fp, ev, "CvoTextChangedSizeEvent", obj);
      {
	Cvo_TextChangedSizeEvent *ce = (Cvo_TextChangedSizeEvent *)ev;
	fprintf(fp, "    Old: %dx%d  New: %dx%d\n",
		ce->oldwidth, ce->oldrows, ce->width, ce->rows);
      }
	break;
    case CvoInputEnteredEvent:
	PrintGeneric(fp, ev, "CvoInputEnteredEvent", obj);
	break;
    case CvoListItemSelectedEvent:
	PrintGeneric(fp, ev, "CvoListItemSelectedEvent", obj);
	break;
    case CvoNewMenuItemEvent:
	PrintGeneric(fp, ev, "CvoNewMenuItemEvent", obj);
	break;
    case CvoDelMenuItemEvent:
	PrintGeneric(fp, ev, "CvoDelMenuItemEvent", obj);
	break;
    case CvoMenuEvent:
	PrintGeneric(fp, ev, "CvoMenuEvent", obj);
	break;
    case CvoOpenFileEvent:
	PrintGeneric(fp, ev, "CvoOpenFileEvent", obj);
	break;
    case CvoSaveFileEvent:
	PrintGeneric(fp, ev, "CvoSaveFileEvent", obj);
	break;
    case CvoPageChangedEvent:
	PrintGeneric(fp, ev, "CvoPageChangedEvent", obj);
	break;
    case CvoRadioBoxSelectedEvent:
	PrintGeneric(fp, ev, "CvoRadioBoxSelectedEvent", obj);
	goto Ln;
    case CvoRadioBoxDeselectedEvent:
	PrintGeneric(fp, ev, "CvoRadioBoxDeselectedEvent", obj);
    Ln: {
        Cvo_RadioBoxSelectedEvent *ce = (Cvo_RadioBoxSelectedEvent *)ev;
        fprintf(fp, "    Index: %d\n", ce->index);
      }
        break;
    case CvoScrollBarEvent:
	PrintGeneric(fp, ev, "CvoScrollBarEvent", obj);
      {
        Cvo_ScrollBarEvent *ce = (Cvo_ScrollBarEvent *)ev;
        fprintf(fp, "    Value: %d\n", ce->value);
      }
        break;
#if defined(CvoSkylineSelectedEvent)
    case CvoSkylineSelected1Event:
	PrintGeneric(fp, ev, "CvoSkylineSelected1Event", obj);
	goto Lp;
    case CvoSkylineSelected2Event:
	PrintGeneric(fp, ev, "CvoSkylineSelected2Event", obj);
	goto Lp;
    case CvoSkylineSelected3Event:
	PrintGeneric(fp, ev, "CvoSkylineSelected3Event", obj);
	goto Lp;
    case CvoSkylineSelectedEvent:
	PrintGeneric(fp, ev, "CvoSkylineSelectedEvent", obj);
    Lp: {
        Cvo_SkylineSelectedEvent *ce = (Cvo_SkylineSelectedEvent *)ev;
        fprintf(fp, "    Index: %d  Which: %d\n", ce->index, ce->which);
      }
        break;
#endif
    default:
	PrintGeneric(fp, ev, "<Unknown Event>", obj);
        break;
    }
    CVO_VOID_RETURN
}
