//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Radio.cc,v 1.7 1994/09/02 19:38:46 prb Exp $"); }
#include <Cvo/BasicButton.h++>
#include <Cvo/Radio.h++>

Cvo_Radio::~Cvo_Radio()
{
    while (list)
	list->Delete(&list);
}

Cvo_RadioList::Cvo_RadioList(Cvo_RadioList **root,
			     Cvo_Object *t,
			     void *d)
              : Cvo_RootedList((Cvo_RootedList **)root)
{   CVO_ENTER
    toggle = t;
    data = d;
    r1 = r2 = r3 = 0;
    CVO_VOID_RETURN
}

Cvo_RadioList::~Cvo_RadioList()
{
    delete r1;
    delete r2;
    delete r3;
}

Cvo_RadioList*
Cvo_Radio::AddToggle(Cvo_Object *t, void *data)
{   CVO_ENTER
    Cvo_RadioList *rl = list;

    while (rl) {
	if (rl->toggle == t)
	    CVO_RETURN(rl)
	rl = rl->Next();
    }

    Cvo_RadioList* item = new Cvo_RadioList(&list, t, data);
    t->ForceOff();
    item->r1 = t->Register(CvoButtonDownEvent, &_Cvo_RadioEvent, this);
    item->r2 = t->Register(CvoButtonUpEvent, &_Cvo_RadioEvent, this);
    item->r3 = t->Register(CvoDestroyedEvent, &_Cvo_RadioEvent, this);
    if (require1 && !current)
	t->ForceOn();
    CVO_RETURN(item)
}

void
Cvo_Radio::DeleteToggle(Cvo_RadioList* ri)
{   CVO_ENTER

    if (ri && require1 && current == ri->toggle) {
	if (ri->Prev() == ri)
	    current = 0;
	else
	    ri->Prev()->toggle->ForceOn();
    }
	
    ri->Delete(&list);
    CVO_VOID_RETURN
}

void
Cvo_Radio::RequireSelection(BOOL v)
{   CVO_ENTER
    if ((require1 = v) && !current && list)
	list->toggle->ForceOn();
    CVO_VOID_RETURN
}

void
_Cvo_RadioEvent(Cvo_Object *win, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_Radio *r = (Cvo_Radio *)data;

    switch (ev->type) {
    case CvoDestroyedEvent: {
	Cvo_RadioList *list = r->list;

    	while (list && list->toggle != win) {
	    list = list->Next();
	}
    	if (list)
	    r->DeleteToggle(list);
	break;
      }
    case CvoButtonDownEvent: {
	Cvo_Object *cur = r->current; 
	if (cur == win)
	    CVO_VOID_RETURN
	r->current = win;
	if (cur)
	    cur->ForceOff();
	break;
      }
    case CvoButtonUpEvent :
	if (win == r->current && r->require1)
	    r->current->ForceOn();
	else if (win == r->current)
	    r->current = 0;
	break;
    }
    CVO_VOID_RETURN
}
