//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: SelfLayout.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>

int
Cvo_LayoutWindow::SelfComputeLayoutSize(int force)
{   CVO_ENTER
    Cvo_FrameSize mymin, mydes;

    ComputeUserSizes(mymin, mydes);

    if (layout.vaspect && layout.haspect) {
	if (CARD(mymin.width * layout.vaspect)
	  > CARD(mymin.height * layout.haspect)) {
	    mymin.height = CARD16(mymin.width * layout.vaspect
				/ CARD32(layout.haspect));
	} else {
	    mymin.width = CARD16(mymin.height * layout.haspect 
				/ CARD32(layout.vaspect));
	}
	if (CARD(mydes.width * layout.vaspect)
	  > CARD(mydes.height * layout.haspect)) {
	    mydes.height = CARD16(mydes.width * layout.vaspect
				/ CARD32(layout.haspect));
	} else {
	    mydes.width = CARD16(mydes.height * layout.haspect
				/ CARD32(layout.vaspect));
	}
	if (CARD(layout.maximum.width * layout.vaspect)
	  > CARD(layout.maximum.height * layout.haspect)) {
	    layout.maximum.width = CARD16(layout.maximum.height * layout.haspect
					/ CARD32(layout.vaspect));
	} else {
	    layout.maximum.height = CARD16(layout.maximum.width * layout.vaspect
					/ CARD32(layout.haspect));
	}
    }

    Cvo_FrameSize min, des;

    min = mymin;
    des = mydes;

    if (des.width < min.width || (force & Cvo_FORCE_MINIMUM_WIDTH))
        des.width = min.width;
    if (des.height < min.height || (force & Cvo_FORCE_MINIMUM_HEIGHT))
        des.height = min.height;

    if (layout.maximum.width && des.width > layout.maximum.width) {
        des.width = layout.maximum.width;
        if (min.width > layout.maximum.width)
            min.width = layout.maximum.width;
    }

    if (layout.maximum.height && des.height > layout.maximum.height) {
        des.height = layout.maximum.height;
        if (min.height > layout.maximum.height)
            min.height = layout.maximum.height;
    }

    int rs = layout.ignoreshadow ? 0 : raise;

    if (layout.vertical) {
        min.width += 2*(borderWidth + horizontalPad)+raise;
        min.height += 2*(borderWidth + verticalPad)+rs;
        des.width += 2*(borderWidth + horizontalPad)+raise;
        des.height += 2*(borderWidth + verticalPad)+rs;
    } else {
        min.width += 2*(borderWidth + horizontalPad)+rs;
        min.height += 2*(borderWidth + verticalPad)+raise;
        des.width += 2*(borderWidth + horizontalPad)+rs;
        des.height += 2*(borderWidth + verticalPad)+raise;
    }

    if (layout.maximum.width)
	layout.maximum.width += 2 * (borderWidth + horizontalPad) + rs;
    if (layout.maximum.height)
	layout.maximum.height += 2 * (borderWidth + verticalPad) + rs;

    layout.minimum = min;
    layout.desired = des;

    if (layout.matchWidth) {
	layout.minimum.width = layout.matchWidth->layout.minimum.width;
	layout.desired.width = layout.matchWidth->layout.desired.width;
	layout.maximum.width = layout.matchWidth->layout.maximum.width;
    }

    if (layout.matchHeight) {
	layout.minimum.height = layout.matchHeight->layout.minimum.height;
	layout.desired.height = layout.matchHeight->layout.desired.height;
	layout.maximum.height = layout.matchHeight->layout.maximum.height;
    }
    CVO_RETURN(CheckLayout())
}
