//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Table.h,v 1.3 1994/08/10 17:59:22 prb Exp $
//
#define	GROUND	000			/* Switch to ground table 	 */
#define	ESCTAB	001			/* Switch to escape table 	 */
#define	BRKTAB	002			/* Switch to right bracket table */
#define QMTAB   003                     /* Switch to question mark table */
#define	KRBTAB	004			/* Switch to left bracket table  */
#define	ENDKRB	007			/* End left bracket command      */
#define	SCSMODE	010			/* Grab one more character       */

#define	PRINT	020			/* PRINT this 			    */
#define	OPTNUM	021			/* option number 		    */
#define	OPTSEP	022			/* option seperator 		    */
#define	CUP	023			/* CUrsor Position 		    */
#define	CUD	024			/* CUrsor Down 			    */
#define	CUU	025			/* CUrsor Up 			    */
#define	CUF	026			/* CUrsor Forward  		    */
#define	CUB	027			/* CUrsor Back 			    */
#define	CLEARD	030			/* Clear Display 		    */
#define	CLEARL	031			/* Clear Lines 			    */
#define	RI	032			/* Reverse Index 		    */
#define	IND	033			/* Index 			    */
#define	CHRARG	034			/* Character argument 		    */
#define	ICH	035			/* Insert blank characters 	    */
#define	DCH	036			/* Delect character 		    */
#define	BELL	037			/* Ring the bell 		    */
#define	SGR	040			/* Character Attributes 	    */
#define	SCS	041			/* Select Character Set 	    */
#define	MSCS	042			/* Select Character Set (MultiByte) */
#define	SVCUR	043			/* Save Cursor 			    */
#define	RSCUR	044			/* Restore Cursor 		    */
#define	ILINE	045			/* Insert Lines 		    */
#define	DLINE	046			/* Delete Lines 		    */
#define	VBELL	047			/* Visual Bell 			    */
#define HTAB    050                     /* Hardware Tab 		    */

/*
 * This tables contains what to do for each character.
 * 0 -> unknown and you should switch back to the GROUND table
 */
static Table[256][5] = {
     /* GROUND	ESCTAB	BRKTAB	QMTAB   KRBTAB	   ASCII */
	PRINT,	0,	0,	0,	ENDKRB,	/* 000 NUL */
	PRINT,	0,	0,	0,	ENDKRB,	/* 001 SOH */
	PRINT,	0,	0,	0,	ENDKRB,	/* 002 STX */
	PRINT,	0,	0,	0,	ENDKRB,	/* 003 ETX */
	PRINT,	0,	0,	0,	ENDKRB,	/* 004 EOT */
	PRINT,	0,	0,	0,	ENDKRB,	/* 005 ENQ */
	PRINT,	0,	0,	0,	ENDKRB,	/* 006 ACK */
	BELL,	VBELL,	0,	0,	ENDKRB,	/* 007 BEL */
	PRINT,	0,	0,	0,	ENDKRB,	/* 010 BS */
	HTAB,	0,	0,	0,	ENDKRB,	/* 011 HT */
	PRINT,	0,	0,	0,	ENDKRB,	/* 012 NL */
	PRINT,	0,	0,	0,	ENDKRB,	/* 013 VT */
	PRINT,	0,	0,	0,	ENDKRB,	/* 014 NP */
	PRINT,	0,	0,	0,	ENDKRB,	/* 015 CR */
	PRINT,	0,	0,	0,	ENDKRB,	/* 016 SO */
	PRINT,	0,	0,	0,	ENDKRB,	/* 017 SI */
	PRINT,	0,	0,	0,	ENDKRB,	/* 020 DLE */
	PRINT,	0,	0,	0,	ENDKRB,	/* 021 DC1 */
	PRINT,	0,	0,	0,	ENDKRB,	/* 022 DC2 */
	PRINT,	0,	0,	0,	ENDKRB,	/* 023 DC3 */
	PRINT,	0,	0,	0,	ENDKRB,	/* 024 DC4 */
	PRINT,	0,	0,	0,	ENDKRB,	/* 025 NAK */
	PRINT,	0,	0,	0,	ENDKRB,	/* 026 SYN */
	PRINT,	0,	0,	0,	ENDKRB,	/* 027 ETB */
	PRINT,	0,	0,	0,	ENDKRB,	/* 030 CAN */
	PRINT,	0,	0,	0,	ENDKRB,	/* 031 EM */
	PRINT,	0,	0,	0,	ENDKRB,	/* 032 SUB */
	ESCTAB,	0,	0,	0,	ENDKRB,	/* 033 ESC */
	PRINT,	0,	0,	0,	ENDKRB,	/* 034 FS */
	PRINT,	0,	0,	0,	ENDKRB,	/* 035 GS */
	PRINT,	0,	0,	0,	ENDKRB,	/* 036 RS */
	PRINT,	0,	0,	0,	ENDKRB,	/* 037 US */
	PRINT,	0,	0,	0,	CHRARG,	/* 040   */
	PRINT,	0,	0,	0,	CHRARG,	/* 041 ! */
	PRINT,	0,	0,	0,	CHRARG,	/* 042 " */
	PRINT,	0,	0,	0,	CHRARG,	/* 043 # */
	PRINT,	MSCS,	0,	0,	CHRARG,	/* 044 $ */
	PRINT,	0,	0,	0,	CHRARG,	/* 045 % */
	PRINT,	0,	0,	0,	CHRARG,	/* 046 & */
	PRINT,	0,	0,	0,	CHRARG,	/* 047 ' */
	PRINT,	SCS,	0,	0,	CHRARG,	/* 050 ( */
	PRINT,	0,	0,	0,	CHRARG,	/* 051 ) */
	PRINT,	0,	0,	0,	CHRARG,	/* 052 * */
	PRINT,	0,	0,	0,	CHRARG,	/* 053 + */
	PRINT,	0,	0, 	0,	CHRARG,	/* 054 , */
	PRINT,	0,	0,	0,	CHRARG,	/* 055 - */
	PRINT,	0,	0,	0,	CHRARG,	/* 056 . */
	PRINT,	0,	0,	0,	CHRARG,	/* 057 / */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 060 0 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 061 1 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 062 2 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 063 3 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 064 4 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 065 5 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 066 6 */
	PRINT,	SVCUR,	OPTNUM,	OPTNUM,	CHRARG,	/* 067 7 */
	PRINT,	RSCUR,	OPTNUM,	OPTNUM,	CHRARG,	/* 070 8 */
	PRINT,	0,	OPTNUM,	OPTNUM,	CHRARG,	/* 071 9 */
	PRINT,	0,	0,	0,	CHRARG,	/* 072 : */
	PRINT,	0,	OPTSEP,	OPTSEP,	CHRARG,	/* 073 ; */
	PRINT,	0,	0,	0,	CHRARG,	/* 074 < */
	PRINT,	0,	0,	0,	CHRARG,	/* 075 = */
	PRINT,	0,	0,	0,	CHRARG,	/* 076 > */
	PRINT,	0,	QMTAB,	0,	CHRARG,	/* 077 ? */
	PRINT,	0,	ICH,	0,	CHRARG,	/* 100 @ */
	PRINT,	0,	CUU,	0,	CHRARG,	/* 101 A */
	PRINT,	0,	CUD,	0,	CHRARG,	/* 102 B */
	PRINT,	0,	CUF,	0,	CHRARG,	/* 103 C */
	PRINT,	0,	CUB,	0,	CHRARG,	/* 104 D */
	PRINT,	0,	0,	0,	CHRARG,	/* 105 E */
	PRINT,	0,	0,	0,	CHRARG,	/* 106 F */
	PRINT,	0,	0,	0,	CHRARG,	/* 107 G */
	PRINT,	0,	CUP,	0,	CHRARG,	/* 110 H */
	PRINT,	0,	0,	0,	CHRARG,	/* 111 I */
	PRINT,	0,	CLEARD,	0,	CHRARG,	/* 112 J */
	PRINT,	0,	CLEARL,	0,	CHRARG,	/* 113 K */
	PRINT,	0,	ILINE,	0,	CHRARG,	/* 114 L */
	PRINT,	RI,	DLINE,	0,	CHRARG,	/* 115 M */
	PRINT,	0,	0,	0,	CHRARG,	/* 116 N */
	PRINT,	0,	0,	0,	CHRARG,	/* 117 O */
	PRINT,	0,	DCH,	0,	CHRARG,	/* 120 P */
	PRINT,	0,	0,	0,	CHRARG,	/* 121 Q */
	PRINT,	0,	0,	0,	CHRARG,	/* 122 R */
	PRINT,	0,	0,	0,	CHRARG,	/* 123 S */
	PRINT,	0,	0,	0,	CHRARG,	/* 124 T */
	PRINT,	0,	0,	0,	CHRARG,	/* 125 U */
	PRINT,	0,	0,	0,	CHRARG,	/* 126 V */
	PRINT,	0,	0,	0,	CHRARG,	/* 127 W */
	PRINT,	0,	0,	0,	CHRARG,	/* 130 X */
	PRINT,	0,	0,	0,	CHRARG,	/* 131 Y */
	PRINT,	0,	0,	0,	CHRARG,	/* 132 Z */
	PRINT,	BRKTAB,	0,	0,	CHRARG,	/* 133 [ */
	PRINT,	0,	0,	0,	CHRARG,	/* 134 \ */
	PRINT,	KRBTAB,	0,	0,	CHRARG,	/* 135 ] */
	PRINT,	0,	0,	0,	CHRARG,	/* 136 ^ */
	PRINT,	0,	0,	0,	CHRARG,	/* 137 _ */
	PRINT,	0,	0,	0,	CHRARG,	/* 140 ` */
	PRINT,	0,	0,	0,	CHRARG,	/* 141 a */
	PRINT,	0,	0,	0,	CHRARG,	/* 142 b */
	PRINT,	0,	0,	0,	CHRARG,	/* 143 c */
	PRINT,	0,	0,	0,	CHRARG,	/* 144 d */
	PRINT,	0,	0,	0,	CHRARG,	/* 145 e */
	PRINT,	0,	0,	0,	CHRARG,	/* 146 f */
	PRINT,	0,	0,	0,	CHRARG,	/* 147 g */
	PRINT,	0,	0,	0,	CHRARG,	/* 150 h */
	PRINT,	0,	0,	0,	CHRARG,	/* 151 i */
	PRINT,	0,	0,	0,	CHRARG,	/* 152 j */
	PRINT,	0,	0,	0,	CHRARG,	/* 153 k */
	PRINT,	0,	0,	0,	CHRARG,	/* 154 l */
	PRINT,	0,	SGR,	0,	CHRARG,	/* 155 m */
	PRINT,	0,	0,	0,	CHRARG,	/* 156 n */
	PRINT,	0,	0,	0,	CHRARG,	/* 157 o */
	PRINT,	0,	0,	0,	CHRARG,	/* 160 p */
	PRINT,	0,	0,	0,	CHRARG,	/* 161 q */
	PRINT,	0,	0,	0,	CHRARG,	/* 162 r */
	PRINT,	0,	0,	0,	CHRARG,	/* 163 s */
	PRINT,	0,	0,	0,	CHRARG,	/* 164 t */
	PRINT,	0,	0,	0,	CHRARG,	/* 165 u */
	PRINT,	0,	0,	0,	CHRARG,	/* 166 v */
	PRINT,	0,	0,	0,	CHRARG,	/* 167 w */
	PRINT,	0,	0,	0,	CHRARG,	/* 170 x */
	PRINT,	0,	0,	0,	CHRARG,	/* 171 y */
	PRINT,	0,	0,	0,	CHRARG,	/* 172 z */
	PRINT,	0,	0,	0,	CHRARG,	/* 173 { */
	PRINT,	0,	0,	0,	CHRARG,	/* 174 | */
	PRINT,	0,	0,	0,	CHRARG,	/* 175 } */
	PRINT,	0,	0,	0,	CHRARG,	/* 176 ~ */
	PRINT,	0,	0,	0,	ENDKRB,	/* 177 */
	PRINT,	0,	0,	0,	0,	/* 200 */
	PRINT,	0,	0,	0,	0,	/* 201 */
	PRINT,	0,	0,	0,	0,	/* 202 */
	PRINT,	0,	0,	0,	0,	/* 203 */
	PRINT,	0,	0,	0,	0,	/* 204 */
	PRINT,	0,	0,	0,	0,	/* 205 */
	PRINT,	0,	0,	0,	0,	/* 206 */
	PRINT,	0,	0,	0,	0,	/* 207 */
	PRINT,	0,	0,	0,	0,	/* 210 */
	PRINT,	0,	0,	0,	0,	/* 211 */
	PRINT,	0,	0,	0,	0,	/* 212 */
	PRINT,	0,	0,	0,	0,	/* 213 */
	PRINT,	0,	0,	0,	0,	/* 214 */
	PRINT,	0,	0,	0,	0,	/* 215 */
	PRINT,	0,	0,	0,	0,	/* 216 */
	PRINT,	0,	0,	0,	0,	/* 217 */
	PRINT,	0,	0,	0,	0,	/* 220 */
	PRINT,	0,	0,	0,	0,	/* 221 */
	PRINT,	0,	0,	0,	0,	/* 222 */
	PRINT,	0,	0,	0,	0,	/* 223 */
	PRINT,	0,	0,	0,	0,	/* 224 */
	PRINT,	0,	0,	0,	0,	/* 225 */
	PRINT,	0,	0,	0,	0,	/* 226 */
	PRINT,	0,	0,	0,	0,	/* 227 */
	PRINT,	0,	0,	0,	0,	/* 230 */
	PRINT,	0,	0,	0,	0,	/* 231 */
	PRINT,	0,	0,	0,	0,	/* 232 */
	PRINT,	0,	0,	0,	0,	/* 233 */
	PRINT,	0,	0,	0,	0,	/* 234 */
	PRINT,	0,	0,	0,	0,	/* 235 */
	PRINT,	0,	0,	0,	0,	/* 236 */
	PRINT,	0,	0,	0,	0,	/* 237 */
	PRINT,	0,	0,	0,	0,	/* 240 */
	PRINT,	0,	0,	0,	0,	/* 241 */
	PRINT,	0,	0,	0,	0,	/* 242 */
	PRINT,	0,	0,	0,	0,	/* 243 */
	PRINT,	0,	0,	0,	0,	/* 244 */
	PRINT,	0,	0,	0,	0,	/* 245 */
	PRINT,	0,	0,	0,	0,	/* 246 */
	PRINT,	0,	0,	0,	0,	/* 247 */
	PRINT,	0,	0,	0,	0,	/* 250 */
	PRINT,	0,	0,	0,	0,	/* 251 */
	PRINT,	0,	0,	0,	0,	/* 252 */
	PRINT,	0,	0,	0,	0,	/* 253 */
	PRINT,	0,	0,	0,	0,	/* 254 */
	PRINT,	0,	0,	0,	0,	/* 255 */
	PRINT,	0,	0,	0,	0,	/* 256 */
	PRINT,	0,	0,	0,	0,	/* 257 */
	PRINT,	0,	0,	0,	0,	/* 260 */
	PRINT,	0,	0,	0,	0,	/* 261 */
	PRINT,	0,	0,	0,	0,	/* 262 */
	PRINT,	0,	0,	0,	0,	/* 263 */
	PRINT,	0,	0,	0,	0,	/* 264 */
	PRINT,	0,	0,	0,	0,	/* 265 */
	PRINT,	0,	0,	0,	0,	/* 266 */
	PRINT,	0,	0,	0,	0,	/* 267 */
	PRINT,	0,	0,	0,	0,	/* 270 */
	PRINT,	0,	0,	0,	0,	/* 271 */
	PRINT,	0,	0,	0,	0,	/* 272 */
	PRINT,	0,	0,	0,	0,	/* 273 */
	PRINT,	0,	0,	0,	0,	/* 274 */
	PRINT,	0,	0,	0,	0,	/* 275 */
	PRINT,	0,	0,	0,	0,	/* 276 */
	PRINT,	0,	0,	0,	0,	/* 277 */
	PRINT,	0,	0,	0,	0,	/* 300 */
	PRINT,	0,	0,	0,	0,	/* 301 */
	PRINT,	0,	0,	0,	0,	/* 302 */
	PRINT,	0,	0,	0,	0,	/* 303 */
	PRINT,	0,	0,	0,	0,	/* 304 */
	PRINT,	0,	0,	0,	0,	/* 305 */
	PRINT,	0,	0,	0,	0,	/* 306 */
	PRINT,	0,	0,	0,	0,	/* 307 */
	PRINT,	0,	0,	0,	0,	/* 310 */
	PRINT,	0,	0,	0,	0,	/* 311 */
	PRINT,	0,	0,	0,	0,	/* 312 */
	PRINT,	0,	0,	0,	0,	/* 313 */
	PRINT,	0,	0,	0,	0,	/* 314 */
	PRINT,	0,	0,	0,	0,	/* 315 */
	PRINT,	0,	0,	0,	0,	/* 316 */
	PRINT,	0,	0,	0,	0,	/* 317 */
	PRINT,	0,	0,	0,	0,	/* 320 */
	PRINT,	0,	0,	0,	0,	/* 321 */
	PRINT,	0,	0,	0,	0,	/* 322 */
	PRINT,	0,	0,	0,	0,	/* 323 */
	PRINT,	0,	0,	0,	0,	/* 324 */
	PRINT,	0,	0,	0,	0,	/* 325 */
	PRINT,	0,	0,	0,	0,	/* 326 */
	PRINT,	0,	0,	0,	0,	/* 327 */
	PRINT,	0,	0,	0,	0,	/* 330 */
	PRINT,	0,	0,	0,	0,	/* 331 */
	PRINT,	0,	0,	0,	0,	/* 332 */
	PRINT,	0,	0,	0,	0,	/* 333 */
	PRINT,	0,	0,	0,	0,	/* 334 */
	PRINT,	0,	0,	0,	0,	/* 335 */
	PRINT,	0,	0,	0,	0,	/* 336 */
	PRINT,	0,	0,	0,	0,	/* 337 */
	PRINT,	0,	0,	0,	0,	/* 340 */
	PRINT,	0,	0,	0,	0,	/* 341 */
	PRINT,	0,	0,	0,	0,	/* 342 */
	PRINT,	0,	0,	0,	0,	/* 343 */
	PRINT,	0,	0,	0,	0,	/* 344 */
	PRINT,	0,	0,	0,	0,	/* 345 */
	PRINT,	0,	0,	0,	0,	/* 346 */
	PRINT,	0,	0,	0,	0,	/* 347 */
	PRINT,	0,	0,	0,	0,	/* 350 */
	PRINT,	0,	0,	0,	0,	/* 351 */
	PRINT,	0,	0,	0,	0,	/* 352 */
	PRINT,	0,	0,	0,	0,	/* 353 */
	PRINT,	0,	0,	0,	0,	/* 354 */
	PRINT,	0,	0,	0,	0,	/* 355 */
	PRINT,	0,	0,	0,	0,	/* 356 */
	PRINT,	0,	0,	0,	0,	/* 357 */
	PRINT,	0,	0,	0,	0,	/* 360 */
	PRINT,	0,	0,	0,	0,	/* 361 */
	PRINT,	0,	0,	0,	0,	/* 362 */
	PRINT,	0,	0,	0,	0,	/* 363 */
	PRINT,	0,	0,	0,	0,	/* 364 */
	PRINT,	0,	0,	0,	0,	/* 365 */
	PRINT,	0,	0,	0,	0,	/* 366 */
	PRINT,	0,	0,	0,	0,	/* 367 */
	PRINT,	0,	0,	0,	0,	/* 370 */
	PRINT,	0,	0,	0,	0,	/* 371 */
	PRINT,	0,	0,	0,	0,	/* 372 */
	PRINT,	0,	0,	0,	0,	/* 373 */
	PRINT,	0,	0,	0,	0,	/* 374 */
	PRINT,	0,	0,	0,	0,	/* 375 */
	PRINT,	0,	0,	0,	0,	/* 376 */
	PRINT,	0,	0,	0,	0,	/* 377 */
};
