//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Text.cc,v 1.4 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Text.h++>
#include <sys/time.h>
#include <unistd.h>

#include "Table.h"

static Cvo_Default defaults[] = {
    "*CvoText*Sunken:True",
    "*CvoText*Pad:2",
    "*CvoText.Cursor:xterm",
    "*CvoText*FontFamily:Courier",
    "*CvoText*TabStop:8",
};

CONSTRUCTORS(Cvo_Text, Cvo_CRT, "CvoText")

void
Cvo_Text::_Init()
{   CVO_ENTER
    type = CvoT_Text;
    rawtext = 0;
    table = 0;
    mbtmp_index = 0;
    save_cursor_x = 0;
    save_cursor_y = 0;
    my_cursor_x = 0;
    my_cursor_y = 0;
    CVO_VOID_RETURN
}

void
Cvo_Text::Putc(char c)
{   CVO_ENTER
    wchar_t wc;

    mbtmp[mbtmp_index++] = c;
    mbtmp[mbtmp_index] = 0;
    int n = mbtowc(&wc, mbtmp, mbtmp_index);
    if (n <= 0)
	CVO_VOID_RETURN
    if(mbtmp_index -= n) {
	for (int x = 0; x < mbtmp_index; ++x)
	    mbtmp[x] = mbtmp[n+x];
    }
    Putc(wc);
    CVO_VOID_RETURN
}

void
Cvo_Text::Putc(wchar_t c)
{   CVO_ENTER
    int cc;

    //
    // Handle the SCS modes which require 1 character AFTER
    // the escape sequence....
    //
    if (table == SCSMODE) {
//	_XT_doscs(options[0], c);
	table = 0;
	CVO_VOID_RETURN
    }

    switch((c > 255 || table > 0x0f) ? (cc = PRINT) : (cc = Table[c][table])) {
    case SCS:
    case MSCS:
	options[0] = cc;
	table = SCSMODE;
	break;
    case BRKTAB:
	options[options_index = 0] = 0;
	table = BRKTAB;
	break;
    case KRBTAB:
	krbptr = krbstr;
	table = KRBTAB;
	break;
    case ESCTAB:
	table = ESCTAB;
	break;
    case ENDKRB:
	if (krbptr > krbstr) {
	    *krbptr = 0;
// XXX -    _XT_dokrbcmd(win);
	}
	table = 0;
	break;
    case CHRARG:
	if (krbptr < (krbstr + (CvoT_MAXSTR - 1)))
	    *krbptr++ = c;
	break;
    case OPTNUM:
	if (options_index == 0)
	    options_index = 1;
	options[options_index-1] *= 10;
	options[options_index-1] += int(c - '0');
	break;
    case OPTSEP:
	if (options_index < CvoT_MAXOPTS)
	    options[options_index++] = 0;
	break;
    case SGR:
	if (options_index < 1) {
	    options[0] = 0;
	    options_index = 1;
	}
	for (cc = 0; cc < options_index; ++cc) {
	    switch(options[cc]) {
	    case 0:
	    default:
		    SetState(TextAttribute());
		break;
	    case 2:	// Gray
		break;
	    case 4:	// Underline
		break;
	    case 5:	// Boldface
		break;
	    case 7:
		SetState(TextAttribute()->Reverse());
		break;
	    }
	}
	table = 0;
	break;
    case SVCUR:
	save_cursor_x = my_cursor_x;
	save_cursor_y = my_cursor_y;
	table = 0;
	break;
    case RSCUR:
	MoveCursor(save_cursor_y, save_cursor_x);
	table = 0;
	break;
    case DLINE:
	HideCursor();
	if (options_index < 1)
	    DeleteLine(my_cursor_y);
	else
	    DeleteLine(my_cursor_y, options[0]);
	MoveCursor(my_cursor_y, my_cursor_x);
	ShowCursor();
	table = 0;
	break;
    case ILINE:
	HideCursor();
	if (options_index < 1)
	    InsertLine(my_cursor_y);
	else
	    InsertLine(my_cursor_y, options[0]);
	MoveCursor(my_cursor_y, my_cursor_x);
	ShowCursor();
	table = 0;
	break;
    case DCH:
	if (options_index < 1)
	    DeleteAt(my_cursor_y, my_cursor_x);
	else
	    DeleteAt(my_cursor_y, my_cursor_x, options[0]);
	table = 0;
	break;
    case ICH:
	if (options_index < 1)
	    InsertAt(my_cursor_y, my_cursor_x);
	else
	    InsertAt(my_cursor_y, my_cursor_x, options[0]);
	table = 0;
	break;
    case CUU:
	if (options_index < 1)
	    MoveCursor(int(my_cursor_y) - 1, my_cursor_x);
	else {
	    MoveCursor(int(my_cursor_y) - options[0], my_cursor_x);
	}
	table = 0;
	break;
    case CUD:
	if (options_index < 1)
	    MoveCursor(my_cursor_y + 1, my_cursor_x);
	else {
	    MoveCursor(my_cursor_y + options[0], my_cursor_x);
	}
	table = 0;
	break;
    case CUF:
	if (options_index < 1)
	    MoveCursor(my_cursor_y, my_cursor_x + 1);
	else {
	    MoveCursor(my_cursor_y, my_cursor_x + options[0]);
	}
	table = 0;
	break;
    case CUB:
	if (options_index < 1)
	    MoveCursor(my_cursor_y, int(my_cursor_x) - 1);
	else {
	    MoveCursor(my_cursor_y, int(my_cursor_x) - options[0]);
	}
	table = 0;
	break;
    case CUP:
	if (options_index < 1)
	    options[0] = 1;
	if (options_index < 2)
	    options[1] = 1;
	MoveCursor(options[0]-1, options[1]-1);
	table = 0;
	break;
    case CLEARD:
	if (options_index < 1)
	    options[0] = 0;
	switch(options[0]) {
	default:
	case 0:	// Clear to end of display
	    DeleteAt(my_cursor_y, my_cursor_x, -1);
	    for (cc = my_cursor_y+1; cc < rows; ++cc)
		DeleteAt(cc, 0, -1);
	    break;
	case 1:	// Clear to begining of display
	    for (cc = 0; cc < int(my_cursor_y); ++cc)
		DeleteAt(cc, 0, -1);
	    DeleteAt(my_cursor_y, 0, my_cursor_x);
	    break;
	case 2: // Clear Display
	    MoveCursor(0, 0);
	    ClearWindow();
	    break;
	}
	table = 0;
	SetState(TextAttribute());
	break;
    case CLEARL:
	if (options_index < 1)
	    options[0] = 0;
	switch(options[0]) {
	default:
	case 0: // Clear to end of line
	    DeleteAt(my_cursor_y, my_cursor_x, -1);
	    break;
	case 1: // Clear to start of line
	    DeleteAt(my_cursor_y, 0, my_cursor_x);
	    break;
	case 2: // Clear line
	    MoveCursor(my_cursor_y, 0);
	    DeleteAt(my_cursor_y, 0, -1);
	    break;
	}
	table = 0;
	break;
    case IND:
	HideCursor();
	DeleteLine(0);
	MoveCursor(my_cursor_y, 0);
	ShowCursor();
	table = 0;
	break;
    case RI:
	HideCursor();
	InsertLine(0);
	MoveCursor(my_cursor_y, 0);
	ShowCursor();
	table = 0;
	break;
    case VBELL:
	table = 0;
	VisualBell();
	break;
    case BELL:
	XBell(Dpy(), 0);
	XFlush(Dpy());
	break;
    case PRINT:
	switch(c) {
	case '\b':
	    if (my_cursor_x > 0)
		MoveCursor(my_cursor_y, int(my_cursor_x) - 1);
	    break;
	case '\r':
	    if (rawtext) {
		MoveCursor(my_cursor_y, 0);
		break;
	    }
	    // FALL THRU //
	case '\n':
	    HideCursor();
	    if (my_cursor_y == rows - 1) {
		DeleteLine(0);
		MoveCursor(my_cursor_y, my_cursor_x);
	    } else {
		MoveCursor(my_cursor_y+1, my_cursor_x);
	    }
	    if (!rawtext)
		MoveCursor(my_cursor_y, 0);
	    ShowCursor();
	    break;
	default:
	    if (int(my_cursor_x) >= NCols()) {
		HideCursor();
		if (my_cursor_y == rows - 1) {
		    DeleteLine(0);
		    MoveCursor(my_cursor_y, 0);
		} else {
		    MoveCursor(my_cursor_y+1, 0);
		}
		ShowCursor();
	    }
	    ReplaceAt(my_cursor_y, my_cursor_x, &c, 1);
	    MoveCursor(my_cursor_y, my_cursor_x + 1);
	    // XXX -- look for line wrap.
	    break;
	}
	break;
    case HTAB:
	MoveCursor(my_cursor_y, (my_cursor_x/tabstop + 1) * tabstop );
	table = 0;
	break;
    case QMTAB:
	table = QMTAB;
	break;
    default:
	table = 0;
    }
    CVO_VOID_RETURN
}

void
Cvo_Text::Puts(char *s)
{   CVO_ENTER
    tbuf.Set(s);
    Write(tbuf.wcValue(), tbuf.wcLength());
    CVO_VOID_RETURN
}

void
Cvo_Text::Write(char *s, int cnt)
{   CVO_ENTER
    tbuf.Set(s, cnt);
    Write(tbuf.wcValue(), tbuf.wcLength());
    CVO_VOID_RETURN
}

// static
// _XT_doscs(XIO *win, int m, int c)
// {
// 	XTEXT *tx = win->t_text;
// 	int x;
// 
// 	if (m == MSCS)
// 		c |= TX_MCBS;
// 
// 	for (x = 0; x < TX_FONTS && c != tx->tx_scs[x]; ++x)
// 		;
// 
// 	if (x >= TX_FONTS || !tx->tx_gcs[x])
// 		x = 0;
// 
// 	tx->tx_state &= ~(TX_FONTMASK|TX_MCBS);
// 	if (tx->tx_scs[x] & TX_MCBS)
// 		tx->tx_state |= TX_MCBS;
// 	tx->tx_state |= x;
// 	tx->tx_lastc = -1;
// }

void
Cvo_Text::VisualBell()
{   CVO_ENTER
    struct timeval tv;

    SetFunction(GXxor);
    FillRectangle(0, 0, Width(), Height());
    XFlush(Dpy());
    tv.tv_sec = 0;
    tv.tv_usec = 1000 * 50;
    select(0, 0, 0, 0, &tv);
    FillRectangle(0, 0, Width(), Height());
    XFlush(Dpy());
    SetFunction(GXcopy);
    CVO_VOID_RETURN
}

// void _XT_dokrbcmd(XIO *win)
// {
// 	XTEXT *tx = win->t_text;
// 	char *str = tx->tx_krbstr;
// 	char *p = str;
// 
// 	while (*p && *p != ';')
// 		++p;
// 	if (!*p)
// 		CVO_VOID_RETURN
// 	*p++ = '\0';
// 	if (str[0] == '0' && str[1] == '\0') {
// 		XIO_IconName(win, p);
// 		XIO_Title(win, p);
// 	} else if (str[0] == '1' && str[1] == '\0') {
// 		XIO_IconName(win, p);
// 	} else if (str[0] == '2' && str[1] == '\0') {
// 		XIO_Title(win, p);
// 	}
// }
