//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: TextLine.cc,v 1.6 1994/09/08 21:59:54 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Text.h++>
#include <ctype.h>
#if defined(I18N) && !defined(_RUNE_MAGIC_1)
#include <wctype.h>
#endif

#if     !defined(iswspace)
#define iswspace(c) isspace(c)
#define iswpunct(c) ispunct(c)
#define iswprint(c) isprint(c)
#endif


#define	_WIN	win			// used to be win->pm

Cvo_TextLine::Cvo_TextLine(Cvo_CRT *_win, int _width)
{   CVO_ENTER
    win = _win;
    text = new wchar_t[_width];
    state = new Cvo_TextAttribute *[_width];
    currentstate = win->TextAttribute();
    ascent = 0;
    descent = 0;
    maxlen = _width;
    lastglyph = 0;
    ly = 0;
    lx = 0;
    lw = 0;
    rx = 0;
    ry = 0;
    rw = 0;
    rh = 0;
    rr = 0;
    myrow = 0;
    raised = False;
    wasraised = False;
    wasdirty = False;
    dirty = False;
    hascursor = False;
    cursorx = 0;
    fixedwidth = False;
    tmpflatten = False;
    CVO_VOID_RETURN
}

Cvo_TextLine::~Cvo_TextLine()
{   CVO_ENTER
    delete [] text;
    delete [] state;
    CVO_DONE
}

int
Cvo_TextLine::PixelIndex(int where)
{   CVO_ENTER

    if (where == 0)
	CVO_RETURN(0)

    if (!win->tabsize)
	win->InitTabs();

    wchar_t *t = text;
    Cvo_TextAttribute **s = state;
    int len = lastglyph;
    int overrun = 0;
    int nx = 0;

    while (len > 0) {
        Cvo_TextAttribute *attr = *s;
        wchar_t *b = t;

	if (*b == '\t') {
	    --len;
            ++t;
            ++s;
        } else {
	    while (*t != '\t' && len && *s == attr) {
		--len;
		++t;
		++s;
	    }
        }

        int oldx = nx;

        if (*b == '\t') {
	    nx = (nx + int(win->tabsize)) / int(win->tabsize);
	    nx *= win->tabsize;

	    if (nx > where) {
		CVO_RETURN(b - text)
	    }
	    if (nx == where) {
		CVO_RETURN(b - text + 1)
	    }
	} else {
	    while (t > b && (nx += attr->StringWidth(b, t - b)) >= where) {
		nx = oldx;
		--t;
		overrun = 1;
	    }
	    if (overrun) {
		CVO_RETURN((t+1) - text)
	    }
	}
    }
    CVO_RETURN(lastglyph+1)
}

int
Cvo_TextLine::PixelLength()
{   CVO_ENTER
    wchar_t *t = text;
    Cvo_TextAttribute **s = state;
    int len = lastglyph;
    int overrun = 0;
    int nx = 0;

    if (!win->tabsize)
	win->InitTabs();
    while (len > 0) {
        Cvo_TextAttribute *attr = *s;
        wchar_t *b = t;

	if (*b == '\t') {
	    --len;
            ++t;
            ++s;
        } else {
	    while (*t != '\t' && len && *s == attr) {
		--len;
		++t;
		++s;
	    }
        }

        if (*b == '\t') {
	    nx = (nx + int(win->tabsize)) / int(win->tabsize);
	    nx *= win->tabsize;
	} else {
	    nx += attr->StringWidth(b, t - b);
	}
    }
    CVO_RETURN(nx)
}

int
Cvo_TextLine::Draw(int x, int wid)
{   CVO_ENTER

    if (!win->Object()) {
	wasdirty = dirty = 0;
	CVO_RETURN(0)
    }

    if (x != lx || wid != lw) {
	lx = x;
	lw = wid;
	dirty = 1;
    }

    int cx = hascursor ? cursorx : -1;
#if 0
    if (cx >= lastglyph)
	Insert(cx, 1);
#endif
// if (cx > lastglyph) Insert(cx-1, 1);

    wasdirty = dirty;
    wchar_t *t = text;
    Cvo_TextAttribute **s = state;
    int len = lastglyph;
    int overrun = 0;

    int nx = 0;

    if (!dirty)
	CVO_RETURN(0)

    dirty = 0;

    int ep = win->extrapad >> 1;
    if (ep > 0) {
	_WIN->ClearArea(0, ly - ep, _WIN->Width(), ep);
	_WIN->ClearArea(0, ly + LineHeight(), _WIN->Width(), ep);
    }
    if (x) {
	_WIN->ClearArea(0, ly - ep, x, LineHeight() + (ep << 1));
    }

    int org = PixelIndex(win->origin);

    cx -= org;
    t += org;
    s += org;
    len -= org;

    int taboffset = int(win->tabsize) - win->origin % int(win->tabsize);

#if !defined(X11R4)
    //
    // Note that the actual glyph might be written to the left of
    // the X origin, so we must shift the X origin over by that amount
    //

    if (len > 0) { 
	XRectangle ink;
	state[0]->Extents(t, len, ink);
	if (ink.x < 0)
	    nx -= ink.x;
    }
#endif
	

    wchar_t *start = t;
    int ms = (len > 0) ? (*s)->MWidth() : 1;

    while (!overrun && len > 0) {
        Cvo_TextAttribute *attr = *s;
	Cvo_Color obg;
        Cvo_TextAttribute *oattr = *s;
        wchar_t *b = t;
	Cvo_Color cursor;

	if (raised && win->Sunken())
	    obg = attr->SetBackground(win->Background());

	//
	// XXX - This is not an elegant cursor...  It needs to be fixed.
	//

  	int cw = (fixedwidth && cx > 0) ? (attr->StringWidth(b, 1)+ms-1)/ms : 1;

	if (cx >= 0 && cx < cw) {
	    cursor = attr->Foreground();
#if 0
	    if (win->infocus)
		attr = attr->Reverse();
#endif
	}

  	attr = win->InHighlight(myrow, t - start, attr);

	if ((cx >= 0 && cx < cw) || *b == '\t') {
	    cx -= cw;
	    --len;
            ++t;
            ++s;
        } else {
	    Cvo_TextAttribute *nattr = attr;
	    while (len && *t != '\t' && (cx < 0 || cx >= cw) && nattr == attr) {
		cx -= cw;
		--len;
		++t;
		++s;
		if (len) {
  		    cw = (fixedwidth && cx > 0)
  				? ((*s)->StringWidth(t, 1)+ms-1)/ms : 1;

  		    nattr = win->InHighlight(myrow, t - start, *s);
		}
	    }
        }


        int oldx = nx;

        if (*b == '\t') {
	    if (nx < taboffset) {
		nx = taboffset;
	    } else {
		nx = (nx - taboffset + int(win->tabsize)) / int(win->tabsize);
		nx *= win->tabsize;
		nx += taboffset;
	    }

	    if (nx > wid) {
		nx = wid;
		overrun = 1;
	    }
	} else {
	    while (t > b && (nx += attr->StringWidth(b, t - b)) > wid) {
		nx = oldx;
		--t;
		--s;
		++len;
		overrun = 1;
	    }
	}

	if (t == b)
	    break;

	if (*b != '\t') {
	    int my = ly + ascent - attr->Font()->Ascent();
	    if (ascent != attr->Font()->Ascent() ||
		descent != attr->Font()->Descent()) {
		if (attr->Background() != win->CurrentBackground()) {
		    _WIN->SetForeground(attr->Background());
		    _WIN->FillRectangle(oldx + x, ly, nx-oldx, LineHeight());
		} else {
		    _WIN->ClearArea(oldx + x, ly, nx-oldx, LineHeight());
		}
	    }
	    attr->SetUnderlineAt(LineHeight() - (my - ly));
	    attr->Image(oldx + x, my, b, t - b);
	} else {
	    if (attr->Background() != win->CurrentBackground()) {
		_WIN->SetForeground(attr->Background());
		_WIN->FillRectangle(oldx + x, ly, nx-oldx, LineHeight());
	    } else {
		_WIN->ClearArea(oldx + x, ly, nx-oldx, LineHeight());
	    }
	    if (attr->IsUnderline()) {
		_WIN->SetForeground(attr->Foreground());
		_WIN->DrawLine(oldx + x, ly + LineHeight() - 1,
					nx, ly + LineHeight() - 1);
	    }
	}

#if 0
	if (cursor.Full() && attr->Background() != cursor) { // }
#else
	if (cursor.Full()) {
#endif
	    _WIN->SetForeground(cursor);
	    _WIN->DrawLine(oldx + x, ly, oldx + x, ly + LineHeight() - 2);
	}

	if (obg.Full())
	    oattr->SetBackground(obg);
    }

    //
    // Go in and check to see if the highlight should extend the the end
    // of this line.  If so, and we did not draw all the way there, fill
    // the rest in the the highlight's background color.
    //
    Cvo_TextAttribute *attr = lastglyph ? state[lastglyph-1] : currentstate;
    Cvo_TextAttribute *nattr;

    int _WIDTH = _WIN->Width() + _WIN->HorizontalPad() - _WIN->Chamfer();

    if (_WIN->HorizontalPad() > _WIN->Chamfer())
	--_WIDTH;

    if (nx < _WIDTH &&
	(nattr = win->InHighlight(myrow, Cvo_HL_MAX_COLUMN-1, attr)) != attr) {

	if (nattr->Background() != win->CurrentBackground()) {
	    _WIN->SetForeground(nattr->Background());
	    _WIN->FillRectangle(nx, ly - 1, _WIDTH - nx, LineHeight());
	} else
	    _WIN->ClearArea(nx, ly - 1, _WIDTH - nx, LineHeight());
    } else if (raised && win->Sunken()) {
	if (win->Monochrome())
		_WIN->ClearArea(x + nx, ly - 1, wid - nx, LineHeight());
	else {
		_WIN->SetForeground(win->Background());
		_WIN->FillRectangle(x + nx, ly-1, wid - nx, LineHeight());
	}
    } else {
	if (x + nx < _WIDTH)
	    _WIN->ClearArea(x + nx, ly-1, _WIDTH - (x + nx), LineHeight());
    }

    if (!overrun && cx >= 0) {
	if (cx > 0)
	    nx += currentstate->MWidth() * cx;
	_WIN->SetForeground(_WIN->CurrentForeground());
	_WIN->DrawLine(nx, ly - 1, nx, ly + LineHeight() - 2);
    }
	

    //
    // If we are rasied, draw the chamfer
    //
    if (raised) {
	_WIN->SetBackground(_WIN->CurrentBackground());
	rr = ep;
	rx = lx; ry = 0; rw = lw; rh = LineHeight();
	if (rr) {
	    _WIN->DrawRaisedChamfer(rr, rx, ry + ly, rw, rh);
	    wasraised = 1;
	}
    } else if (wasraised) {
	if (rr)
	    _WIN->ClearChamfer(rr, rx, ry + ly, rw, rh);
	wasraised = 0;
    }
    CVO_RETURN(overrun)
}

int
Cvo_TextLine::Extra(int wid, wchar_t **pstr, Cvo_TextAttribute ***pstate)
{   CVO_ENTER
    wchar_t *t = text;
    Cvo_TextAttribute **s = state;
    int len = lastglyph;
    int overrun = 0;

    if (!win->tabsize)
	win->InitTabs();

    int nx = 0;

    dirty = 0;

    int org = PixelIndex(win->origin);

    t += org;
    s += org;
    len -= org;

    int taboffset = int(win->tabsize) - win->origin % int(win->tabsize);

    while (!overrun && len > 0) {
        Cvo_TextAttribute *attr = *s;
        wchar_t *b = t;

	if (*b == '\t') {
	    --len;
            ++t;
            ++s;
        } else {
	    while (*t != '\t' && len && *s == attr) {
		--len;
		++t;
		++s;
	    }
        }

        int oldx = nx;

        if (*b == '\t') {
	    if (nx < taboffset)
		nx = taboffset;
	    else {
		nx = (nx - taboffset + int(win->tabsize)) / int(win->tabsize);
		nx *= win->tabsize;
		nx += taboffset;
	    }

	    if (nx > wid) {
		nx = wid;
		overrun = 1;
	    }
	} else {
	    while (t > b && (nx += attr->StringWidth(b, t - b)) > wid) {
		nx = oldx;
		--t;
		--s;
		++len;
		overrun = 1;
	    }
	}

	if (t == b)
	    break;

    }
    if (!overrun || !len) {
	CVO_RETURN(0)
    }

    if (pstr) {
        *pstr = new wchar_t[len+1];
        _memwcpy(*pstr, t, len);
        (*pstr)[len] = 0;
    }
    if (pstate) {
        *pstate = new Cvo_TextAttribute *[len];
        for (int j = 0; j < len; ++j)
            (*pstate)[j] = s[j];
    }

    CVO_RETURN(len)
}

void
Cvo_TextLine::Insert(int x, wchar_t *str, int len)
{   CVO_ENTER

    if (x > 1000)
	abort();
    if (len == -1) {
	if (!str)
	    len = 1;
	else {
	    len = 0;
	    wchar_t *s = str;
	    while (*s++)
		++len;
	}
    }
    if (len <= 0) {
	CVO_VOID_RETURN
    }

    Cvo_CRT_Highlight *hl = win->highlights;

    while (hl) {
	hl->InsertAt(myrow, x, len);
        hl = hl->Next();
    }

    dirty = 1;

    int max = (lastglyph > x ? lastglyph : x) + len;

    if (max > maxlen) {
	maxlen = (max + 16) & ~7;

	wchar_t *newtext = new wchar_t[maxlen];
	Cvo_TextAttribute **newstate = new Cvo_TextAttribute *[maxlen];
	for (int j = 0; j < lastglyph; ++j) {
	    newtext[j] = text[j];
	    newstate[j] = state[j];
	}
	delete text;
	delete state;
	text = newtext;
	state = newstate;

	for (int i = lastglyph; i < maxlen; ++i) {
	    text[i] = 0;
	    state[i] = 0;
	}
    }

    //
    // If the new text is appended PAST all the current text, then
    // pad with spaces
    //
    while (lastglyph < x) {
	text[lastglyph] = ' ';
	state[lastglyph++] = currentstate;
    }

    for (int i = lastglyph - 1; i >= x; --i) {
	text[i+len] = text[i];
	state[i+len] = state[i];
    }

    lastglyph += len;
    while (len-- > 0) {
	text[x] = str ? *str++ : ' ';
    	if (!iswprint(text[x]))
	    text[x] = ' ';
	state[x++] = currentstate;
    }
    CVO_VOID_RETURN
}

void
Cvo_TextLine::BeginWord(int &x)
{
    if (x <= 0 || x >= lastglyph)
	return;

    if (iswspace(text[x])) {
	while (x > 0 && iswspace(text[x-1]))
	    --x;
    } else if (iswpunct(text[x])) {
	while (x > 0 && iswpunct(text[x-1]))
	    --x;
    } else {
	while (x > 0 && !iswpunct(text[x-1]) && !iswspace(text[x-1]))
	    --x;
    }
}

void
Cvo_TextLine::EndWord(int &x)
{
    if (x < 0 || x >= lastglyph)
	return;

    if (iswspace(text[x])) {
	while (x + 1 < lastglyph && iswspace(text[x+1]))
	    ++x;
    } else if (iswpunct(text[x])) {
	while (x + 1 < lastglyph && iswpunct(text[x+1]))
	    ++x;
    } else {
	while (x + 1 < lastglyph && !iswpunct(text[x+1])
				 && !iswspace(text[x+1]))
	    ++x;
    }
    if (x < lastglyph)
	++x;
}

void
Cvo_TextLine::Replace(int x, wchar_t *str, int len)
{   CVO_ENTER
    if (len == -1) {
	len = 0;
	wchar_t *s = str;
	while (*s++)
	    ++len;
    }
    if (len <= 0) {
	CVO_VOID_RETURN
    }
    Delete(x, len);
    Insert(x, str, len);
    CVO_VOID_RETURN
}

void
Cvo_TextLine::Append(wchar_t *str, int len)
{   CVO_ENTER
    Insert(lastglyph, str, len);
    CVO_VOID_RETURN
}

void
Cvo_TextLine::Append(wchar_t *str, Cvo_TextAttribute **attrs, int len)
{   CVO_ENTER
    int oldlg = lastglyph;
    Insert(lastglyph, str, len);
    while (oldlg < lastglyph) {
	if (*attrs++) {
	    state[oldlg] = attrs[-1];
	    if (state[oldlg]->Font()->Ascent() > ascent)
		ascent = state[oldlg]->Font()->Ascent();
	    if (state[oldlg]->Font()->Descent() > descent)
		descent = state[oldlg]->Font()->Descent();
	    ++oldlg;
	} else {
	    state[oldlg++] = win->TextAttribute();
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_TextLine::Delete(int x, int len)
{   CVO_ENTER
    if (len == -1)
	len = lastglyph;

    if (x < 0) {
	len += x;
	x = 0;
    }

    if (len <= 0 || x >= lastglyph) {
	CVO_VOID_RETURN
    }
    if (x + len > lastglyph)
	len = lastglyph - x;

    Cvo_CRT_Highlight *hl = win->highlights;

    while (hl) {
	hl->DeleteAt(myrow, x, len);
        hl = hl->Next();
    }


    dirty = 1;

    //
    // It is now okay to remove the text
    //
    if (x + len < lastglyph) {
	for (int j = x + len; j < lastglyph; ++j) {
	    state[j-len] = state[j];
	    text[j-len] = text[j];
	}
    }
    for (int j = lastglyph - len; j < lastglyph; ++j) {
	state[j] = 0;
	text[j] = 0;
    }
    lastglyph -= len;
    CVO_VOID_RETURN
}

void
Cvo_TextLine::ResetLineheight()
{   CVO_ENTER
    Cvo_TextAttribute *ta = currentstate;

    ascent = currentstate->Font()->Ascent();
    descent = currentstate->Font()->Descent();
    for (int j = 0; j < lastglyph; ++j) {
	if (state[j] != ta) {
	    ta = state[j];
	    if (ta->Font()->Ascent() > ascent)
		ascent = ta->Font()->Ascent();
	    if (ta->Font()->Descent() > descent)
		descent = ta->Font()->Descent();
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_TextLine::Clear()
{   CVO_ENTER
    dirty = 1;
    raised = 0;
    tmpflatten = 0;
    for (int i = 0; i < lastglyph; ++i) {
	state[i] = 0;
	text[i] = 0;
    }
    lastglyph = 0;
    ascent = 0;
    descent = 0;
    hascursor = 0;
    SetState(win->TextAttribute());
    CVO_VOID_RETURN
}

void
Cvo_TextLine::MakeRaised()
{   CVO_ENTER
    if (raised) {
	CVO_VOID_RETURN
    }
    dirty = 1;
    raised = 1;
    ReDraw();
    CVO_VOID_RETURN
}

void
Cvo_TextLine::MakeFlat()
{   CVO_ENTER
    if (!raised) {
	CVO_VOID_RETURN
    }
    dirty = 1;
    raised = 0;
    ReDraw();
    CVO_VOID_RETURN
}

void
Cvo_TextLine::_ChangeY(int y)
{   CVO_ENTER
    if (!win->Object() || ly == y) {
	CVO_VOID_RETURN
    }
    ly = y;
    CVO_VOID_RETURN
}

void
Cvo_TextLine::ReDraw()	
{   CVO_ENTER
    win->Flush();
    CVO_VOID_RETURN
}

int
Cvo_TextLine::GetText(wchar_t **wp, int s, int e)
{   CVO_ENTER
    if (e < 0 || e > lastglyph)
	e = lastglyph;
    if (s < 0)
	s = 0;
    if (s >= e) {
	CVO_RETURN(0)
    }
    *wp = text + s;
    CVO_RETURN(e-s)
}
