//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ToolTalk.cc,v 1.5 1994/09/16 19:25:46 prb Exp $"); }
#include <stdio.h>
#include <Cvo/Application.h++>
#include <desktop/tt_c.h>

// 
// Initialize our ToolTalk environment.
//
static int
create_help_event(Cvo_Application *app, Tt_message msg)
{   CVO_ENTER
    if (app == NULL) // nothing to send the message to.
	CVO_RETURN(0)

    int argc = tt_message_args_count(msg);

    Cvo_ToolTalkHelpEvent hev;

    hev.command_name = tt_message_file(msg);
    hev.tag_name = NULL;
    hev.client_procid = NULL;
    if (argc > 2) {
	//
	//	new version
	//
	hev.client_procid = tt_message_arg_val(msg, 1);
	hev.command_name = tt_message_arg_val(msg, 2);
	if (argc > 3)
	    hev.tag_name = tt_message_arg_val(msg, 3);
	char *me = tt_message_arg_val(msg, 0);
	if (me == NULL || *me == '\0') {
	    app->ToolTalkRefCnt()++;
	    Tt_message start_m = tt_pnotice_create(TT_SESSION,
						   "CRAY_help_starting");
	    tt_message_arg_add(start_m,TT_IN, "string",hev.client_procid);
	    tt_message_arg_add(start_m,TT_IN, "string",app->ToolTalkProcID());
	    tt_status_message(tt_message_send(start_m));
#ifdef	notdef
	    fprintf(stderr,"sending \"CRAY_help_starting\": \"%s\" \"%s\"\n",
		    hev.client_procid,app->ToolTalkProcID());
#endif	/*notdef*/
	}
    }
    else {
        if (argc) {
	    hev.command_name = tt_message_arg_val(msg, 0);
	    if (argc > 1)
	        hev.tag_name = tt_message_arg_val(msg, 1);
        }
    }
    app->SendEvent(CvoToolTalkHelpEvent, &hev);
    CVO_RETURN(1)
}

static int
create_close_event(Cvo_Application *app, Tt_message)
{   CVO_ENTER
    if (app == NULL) // nothing to send the message to.
	CVO_RETURN(0)

    Cvo_ToolTalkCloseEvent cev;

    cev.refcnt = app->ToolTalkRefCnt();
    app->SendEvent(CvoToolTalkCloseEvent, &cev);
    CVO_RETURN(1)
}

//
// Handle any incoming ToolTalk messages.
//

static void
receive_tt_message(EvIOEvent *, void *vapp)
{   CVO_ENTER
    Tt_message msg_in;
    int opstatus = 0;
    int quit = 0;
    Cvo_Application *app = (Cvo_Application *)vapp;

    if ((msg_in = tt_message_receive()) == NULL) 
	CVO_VOID_RETURN

    if (tt_pointer_error(msg_in) == TT_ERR_NOMP) {
	Cvo_AnyEvent ev;
	//
	// Insert code here to bring down ToolTalk and destroy msg_in
	//
	app->SendEvent(CvoToolTalkDownEvent,  &ev);
	CVO_VOID_RETURN
    }
    if (!strcmp(tt_message_op(msg_in), "CRAY_help_file")) {
        opstatus = create_help_event(app,msg_in);
    }
    else if (!strcmp(tt_message_op(msg_in), "CRAY_help_section")) {
        opstatus = create_help_event(app,msg_in);
    }
    else if (!strcmp(tt_message_op(msg_in), "CRAY_help_close")) {
        opstatus = create_close_event(app,msg_in);
    }
    if (opstatus == 0)
	tt_message_fail(msg_in);
    else
	tt_message_reply(msg_in);

    tt_message_destroy(msg_in);

    CVO_VOID_RETURN
}

int
Cvo_Application::InitializeToolTalk()
{   CVO_ENTER

    DisplayList()->tt_procid = tt_open();

    int mark = tt_mark();
    int ttfd = tt_fd();

    if (tt_int_error(ttfd) != TT_OK) {
	tt_release(mark);
        CVO_RETURN(0)
    }

    if (tt_pointer_error(ToolTalkProcID()) != TT_OK) {
	tt_release(mark);
	CVO_RETURN(0)
    }

    /*
     * Create and register a pattern so ToolTalk knows we are interested
     * in "CRAY_help" messages within the session we join.
     */

    Tt_pattern	pat = tt_pattern_create();

    tt_pattern_category_set(pat, TT_HANDLE);
    tt_pattern_scope_add(pat, TT_SESSION);
    tt_pattern_op_add(pat, "CRAY_help_file");
    tt_pattern_op_add(pat, "CRAY_help_section");
    tt_pattern_op_add(pat, "CRAY_help_close");
    tt_pattern_register(pat);

    new EvInputEvent(tt_fd(), receive_tt_message, this);

    tt_session_join(tt_default_session());

    //
    // Note that without tt_mark() and tt_release(), the above
    // combination would leak storage -- tt_default_session() returns
    // a copy owned by the application, but since we don't assign the
    // pointer to a variable we could not free it explicitly.
    //
    tt_release(mark);

    CVO_RETURN(1)
}
