//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: TreeViewPort.cc,v 1.6 1994/09/30 19:06:55 prb Exp $"); }
#include <Cvo/TreeViewPort.h++>
#include <memory.h>

CONSTRUCTORS(Cvo_TreeViewPort, Cvo_WindowViewPort, "CvoTreeViewPort")
CONSTRUCTORS_1ARG_PASS(Cvo_TreeViewPortPanner, Cvo_WindowViewPortPanner,
                       "CvoTreeViewPortPanner", Cvo_TreeViewPort*)

static Cvo_Default defs[] = {
    "*CvoTreeViewPort.BorderWidth: 0",
    "*CvoTreeViewPortPanner.BorderWidth: 0",
    "*CvoWindowViewPortClipFrame.CvoTree.Chamfer: 0",
    "*CvoWindowViewPortClipFrame.CvoTree.Pad: 0",
    "*CvoWindowViewPortClipFrame.CvoTree.LayoutPad: 0",
    "*CvoWindowViewPortClipFrame.CvoTree.BorderWidth: 0",
};

void
Cvo_TreeViewPort::_Init()
{   CVO_ENTER
    ResetFrame(new Cvo_Tree("viewPortFrame", ClipFrame()));
    CVO_VOID_RETURN
}

void
Cvo_TreeViewPortPanner::_Init(Cvo_TreeViewPort *_tvp)
{   CVO_ENTER
    tvp = _tvp;
    pixmap = NULL;
    maxlines = 64;
    lines = new XSegment[maxlines];
    nlines = 0;
    tvp->Tree()->Register(CvoTreeRedrawEventType,
	         Cvo_TreeViewPortPannerRedrawHandler, this)->AddDependent(this);
    Register(CvoWindowViewPortPannerEvent,
		 Cvo_TreeViewPortPannerRedrawHandler, this);
    pictColor = Cvo_Color(Panner(), "Black");	// XXX - resource!
    CVO_VOID_RETURN
}

Cvo_TreeViewPortPanner::~Cvo_TreeViewPortPanner()
{   CVO_ENTER
    delete pixmap;
}

void
Cvo_TreeViewPortPannerRedrawHandler(Cvo_Object*, XEvent*, void* d)
{   CVO_ENTER
    Cvo_TreeViewPortPanner* tvpp = (Cvo_TreeViewPortPanner*) d;
    Cvo_WindowViewPortWindow *wvpw =
	(Cvo_WindowViewPortWindow *)tvpp->VPort()->Main();
    Cvo_Window *frm = tvpp->VPort()->Frame();

    Cvo_TreeViewPortPannerDraw(tvpp,
		       	       tvpp->Panner()->Width(),
			       tvpp->Panner()->Height(),
		       	       frm->Width(), frm->Height(),
		               wvpw->Width(), wvpw->Height());

}

void
Cvo_TreeViewPortPannerDraw(Cvo_TreeViewPortPanner* tvpp, int tvpp_w, int tvpp_h,
		   int wvpf_w, int wvpf_h, int wvpw_w, int wvpw_h)
{
    int x_ratio, y_ratio;
    int x_scale, y_scale;
    
    if (!tvpp->Object()) { return;}

    if (tvpp_w <= -1 || tvpp_h <= -1) {  return;}

    if (wvpf_h > wvpw_h) {
	y_ratio = (MAGN * wvpw_h)/tvpp_h;
	y_scale = (MAGN * wvpf_h * y_ratio) / (wvpw_h * MAGN);
    } else {
	if (wvpf_h > tvpp_h) {
	    y_scale = (MAGN * wvpf_h) / tvpp_h;
	} else {
	    y_scale = MAGN;
	}
    }
    
    if (wvpf_w > wvpw_w) {
	x_ratio = (MAGN * wvpw_w)/tvpp_w;
	x_scale = (MAGN * wvpf_w * x_ratio) / (wvpw_w * MAGN);
    } else {
	if (wvpf_w > tvpp_w) {
	    x_scale = (MAGN * wvpf_w)/tvpp_w;
	} else {
	    x_scale = MAGN;
	}
    }

    if (tvpp->pixmap == NULL) { 
	tvpp->pixmap = new Cvo_Pixmap(tvpp->Panner(),
			 tvpp_w, tvpp_h);
    } else {
	tvpp->pixmap->Resize(tvpp_w, tvpp_h);
	tvpp->pixmap->ClearWindow();
    }
    
    tvpp->nlines = 0;
    tvpp->Pixmap()->SetForeground(tvpp->pictColor);
    tvpp->tvp->Tree()->FillPixmap(tvpp, x_scale, y_scale);

    XDrawSegments(tvpp->Pixmap()->Dpy(), tvpp->Pixmap()->Object(),
		  tvpp->Pixmap()->Gc(), tvpp->lines, tvpp->nlines);
    
    tvpp->MakeDirty();
    tvpp->ReLayout(Cvo_FORCE_DESIRED);
    CVO_VOID_RETURN
}

void
Cvo_TreeViewPortPanner::Load_Pixmap()
{   CVO_ENTER
    if (pixmap != NULL) {
	pixmap->CopyAreaTo(Panner(), 0, 0,
			   Panner()->Width(), Panner()->Height(),
			   0, 0);
    }
    CVO_VOID_RETURN
}

void
Cvo_TreeViewPortPanner::_AddLine(int x1, int y1, int x2, int y2)
{   CVO_ENTER
    if (nlines == maxlines) {
	maxlines += 64;
	XSegment *nseg = new XSegment[maxlines];
	memcpy(nseg, lines, sizeof(XSegment) * nlines);
	delete [] lines;
	lines = nseg;
    }
    lines[nlines].x1 = x1;
    lines[nlines].y1 = y1;
    lines[nlines].x2 = x2;
    lines[nlines++].y2 = y2;

    CVO_VOID_RETURN
}
