//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ViewPort.cc,v 1.3 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/ViewPort.h++>

CONSTRUCTORS(Cvo_ViewPort, Cvo_Frame, "CvoViewPort")

void
Cvo_ViewPort::_Init()
{   CVO_ENTER
    type = CvoT_ViewPort;

    VerticalChildren();
    
    upper = new Cvo_Frame("upper_part", this);
    upper->ExpandFrame();

    main = 0;
    vertical = 0;
    horizontal = 0;
    lower = 0;
    CVO_VOID_RETURN
}

void
Cvo_ViewPort::AddMain(Cvo_Window *_main)
{   CVO_ENTER
    main = _main;
    if (main->Parent() != upper)
	main->Reparent(upper);
    main->ExpandFrame();
    if (horizontal) {
	horizontal->MatchWidth(main);
    }
    CVO_VOID_RETURN
}

void
Cvo_ViewPort::AddVertical()
{   CVO_ENTER
    if (vertical)
	    CVO_VOID_RETURN
    vertical = new Cvo_ScrollBar("vertical", upper, Cvo_VERTICAL);
    vertical->SetMinPixelSize(10, 10);
    vertical->SetMaxPixelSize(10, 0);
    vertical->LayOpposite();
    if (upper->Win()) {
	vertical->Create();
	vertical->Map();
    }

    if (Win()) {
	Cvo_Window *w = this;
	while (w->Parent() && w->Parent()->ToWindow())
	    w = w->Parent()->ToWindow();
	w->ReLayout(1);
    }
    CVO_VOID_RETURN
}

void
Cvo_ViewPort::AddHorizontal()
{   CVO_ENTER
    if (horizontal)
	    CVO_VOID_RETURN

    horizontal = new Cvo_ScrollBar("horizontal", this, Cvo_HORIZONTAL);
    horizontal->SetMinPixelSize(10, 10);
    horizontal->SetMaxPixelSize(0, 10);
    horizontal->SetGravity(Cvo_WEST);

    if (main)
	horizontal->MatchWidth(main);

    if (Win()) {
	horizontal->Create();
	horizontal->Map();

	Cvo_Window *w = this;
	while (w->Parent() && w->Parent()->ToWindow())
	    w = w->Parent()->ToWindow();
	w->ReLayout(1);
    }
    CVO_VOID_RETURN
}
