//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Window.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <memory.h>
#if	!defined(X11R4)
#include <X11/Xlocale.h>
#endif
#include <stdio.h>

CONSTRUCTORS(Cvo_Window, Cvo_LayoutWindow, "CvoWindow")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Window)

Cvo_Window::~Cvo_Window()
{   CVO_ENTER
    while (textAttributes)
	delete textAttributes;
    CVO_DONE
}

void
Cvo_Window::_Init()
{   CVO_ENTER
    _cvo_debug(CvoDebug_New, "_Init(%s, %s)\n", Name(), Class());

    if (Parent() && Parent()->Inputonly())
	Cvo_Failure(CvoE_FATAL, CvoE_BADPARENT,
		    "InputOutput Window %s's parent is InputOnly\n",
		    FullName());

    type = CvoT_Window;
    cvo_level = _CVO_STANDARD_WINDOW;

    shadow = 0;
    gc = 0;
    iconPixmap = 0;
    iconMask = 0;

    chamfer = GetResourceInt(_Qchamfer, _QChamfer, Color() ? 2 : 0);
    if (chamfer < 0) {
	chamfer = -chamfer;
	sunken = 1;
    }
    if (GetResourceTruth(_Qsunken, _QSunken))
	sunken = 1;
    if (GetResourceTruth(_Qetched, _QEtched))
	etched = 1;
    raise = GetResourceInt(_Qraise, _QRaise, 0);
    borderWidth = GetResourceInt(_QborderWidth, _QBorderWidth,
				  chamfer ? 0 : 1);

    if (!frame && monochrome)
	reverse = GetResourceTruth(_QreverseVideo, _QReverseVideo, False);

    horizontalPad += chamfer;
    verticalPad += chamfer;

    if (chamfer && (moat = GetResourceInt(_Qmoat, _QMoat, 0))) {
	moatEdge = GetResourceInt(_QmoatEdge, _QMoatEdge, 0);
	moatChamfer = GetResourceInt(_QmoatChamfer, _QMoatChamfer, chamfer>>1);
	if (!moatChamfer)
	    moatChamfer = 1;
	horizontalPad += moat + moatEdge + moatChamfer;
	verticalPad += moat + moatEdge + moatChamfer;
    } else {
	moat = 0;
	moatEdge = 0;
	moatChamfer = 0;
    }

    char *xrp;

    if (background.Empty()) {
        xrp = GetResource(_Qbackground, _QBackground,
                          monochrome ? "white" : "gray");
        background = Cvo_Color(this, xrp, CvoC_BACKGROUND);
    }

    if (foreground.Empty() || border.Empty())
        xrp = GetResource(_Qforeground, _QForeground, "black");

    if (foreground.Empty())
        foreground = Cvo_Color(this, xrp);

    if (border.Empty()) {
	xrp = GetResource(_QborderColor, _QForeground, xrp);
	border = Cvo_Color(this, xrp, CvoC_BACKGROUND);
    }

    //
    // It is okay to load the font now, because it only really needs
    // the display.  You cannot draw yet because the GC has not been
    // (and cannot be) created yet.
    //
    textAttributes = 0;
    if (DisplayList()->Fonts())
	new Cvo_TextAttribute(&textAttributes, this, DisplayList()->Font());
    else
	new Cvo_TextAttribute(&textAttributes, this, Cvo_Font(this));

    Register(CvoResizeEvent, &Cvo_Window::HandleResizeEvent);
    CVO_VOID_RETURN
}

void
Cvo_Window::MakeFrame()
{   CVO_ENTER
    frame = 1;
    chamfer = 0;
    moat = 0;
    moatChamfer = 0;
    moatEdge = 0;
    verticalPad = 0;
    horizontalPad = 0;
    raise = 0;
    layout.horizontalPad = 0;
    layout.verticalPad = 0;
    haveoutline = False;
    drawoutline = False;
    CVO_VOID_RETURN
}

void
Cvo_Window::HandleResizeEvent(XEvent *ev, void *)
{   CVO_ENTER
    Cvo_ResizeEvent *re = (Cvo_ResizeEvent *)ev;

    if (locksize) {
	SetMinPixelSize(re->new_width, re->new_height);
	SetMaxPixelSize(re->new_width, re->new_height);
    }
    if (re->tag != Cvo_LAYOUTTAG && (re->old_width != re->new_width ||
	 			     re->old_height != re->new_height)) {
	ReLayout();
    }
    CVO_VOID_RETURN
}

void
Cvo_Window::LoadFont()
{   CVO_ENTER
    // XXX - is it wrong to assume there is only one thus far?
    delete textAttributes;
    textAttributes = 0;
    new Cvo_TextAttribute(&textAttributes, this, Cvo_Font(this));
    CVO_VOID_RETURN
}

void
Cvo_Window::Erase()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Paint, "Cvo_Erase(%s, %s)\n", Name(), Class());
    if (!Object())
	CVO_VOID_RETURN
    Cvo_Lock lock;

    int ms = moat + moatChamfer + moatEdge + chamfer;

    XClearArea(Dpy(), Object(), ms, ms,
	       XWidth() - 2 * ms,
	       XHeight() - 2 * ms, False);
    CVO_VOID_RETURN
}

void
Cvo_Window::Redraw()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Paint, "Cvo_Redraw(%s, %s)\n", Name(), Class());
    if (!Object())
	CVO_VOID_RETURN
    Cvo_Lock lock;

    int ms = moat + moatChamfer + moatEdge;
    if (!flattened)
	ms += chamfer;

    XClearArea(Dpy(), Object(), ms, ms,
	       XWidth() - 2 * ms,
	       XHeight() - 2 * ms, True);

    CVO_VOID_RETURN
}

void
Cvo_Window::SelectBackground()
{   CVO_ENTER
    Cvo_Lock lock;

    if (!Object())
	CVO_VOID_RETURN

    SetForeground(Background());

    int ms = moat + moatChamfer + moatEdge;
    if (ms) {
	XFillRectangle(Dpy(), Object(), gc, 0, 0, XWidth(), ms);
	XFillRectangle(Dpy(), Object(), gc, 0, XHeight() - ms, XWidth(), ms);
	XFillRectangle(Dpy(), Object(), gc, 0, 0, ms, XHeight());
	XFillRectangle(Dpy(), Object(), gc, XWidth() - ms, 0, ms, XHeight());
    }

    if (background->Select()->UsePixmap()) {
	Cvo_Window *wp = parent ? parent->ToWindow() : 0;

	if (wp && wp->CurrentBackground() == background->Select())
	    XSetWindowBackgroundPixmap(Dpy(), Object(), ParentRelative);
	else
	    XSetWindowBackgroundPixmap(Dpy(), Object(),
				       background->Select()->GetPixmap());
    } else
	XSetWindowBackground(Dpy(), Object(), background->Select()->Pixel());

    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_Window::NormalBackground()
{   CVO_ENTER
    Cvo_Lock lock;

    if (!Object())
	CVO_VOID_RETURN

    if (background->UsePixmap()) {
        Cvo_Window *wp = parent ? parent->ToWindow() : 0;

        if (wp && wp->CurrentBackground() == background)
            XSetWindowBackgroundPixmap(Dpy(), Object(), ParentRelative);
        else
	    XSetWindowBackgroundPixmap(Dpy(), Object(),
				       background->GetPixmap());
    } else
	XSetWindowBackground(Dpy(), Object(), background->Pixel());

    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_Window::PreExposure(XExposeEvent *)
{   CVO_ENTER
    exposed = 1;
    CVO_VOID_RETURN
}

void
Cvo_Window::Exposure(XExposeEvent *)
{   CVO_ENTER
    // This is a virtual function so it can't really be inlined
    CVO_VOID_RETURN
}

void
Cvo_Window::PostExposure(XExposeEvent *)
{   CVO_ENTER
    if (!frame && chamfer && !flattened)
	_drawChamfer();
    CVO_VOID_RETURN
}

Cvo_TextAttribute *
Cvo_Window::NewTextAttribute(char *res)
{   CVO_ENTER
    CVO_RETURN(NewTextAttribute(XrmStringToQuark(res)))
}

Cvo_TextAttribute *
Cvo_Window::NewTextAttribute(XrmQuark res)
{   CVO_ENTER
    Cvo_Font font;
    Cvo_Color col;
    char *xrp;

    Cvo_TextAttribute *attr = NewTextAttribute();
    if (!attr)
	CVO_RETURN(attr)

    font = Cvo_Font(this, res);
    if (font.Full())
	attr->SetFont(font);
    if (xrp = GetResource(_Qforeground, _QForeground, 0, _QForeground, res)) {
	col = Cvo_Color(this, xrp);
	if (col.Full())
	    attr->SetForeground(Sensitive() ? col : col->Grayed());
    }

    if (xrp = GetResource(_Qbackground, _QBackground, 0, _QBackground, res)) {
	col = Cvo_Color(this, xrp, CvoC_BACKGROUND);
	if (col.Full())
	    attr->SetBackground(Sunken() && !DontSink() ? col->Select() : col);
    }

    if (xrp = GetResource(_Qunderline, _QUnderline, 0, _QUnderline, res)) {
	if (xrp[0]) {
	    xrp[0] |= 040;
	    if (xrp[1])
		xrp[1] |= 040;
	}
	if (xrp[0] == 't' ||                 // True
            xrp[0] == 'y' ||                 // Yes
            xrp[0] == 'a' ||                 // Affermative
           (xrp[0] && xrp[1] == 'n'))        // oN
		attr->Underline(True);
    }

    if (xrp = GetResource(_Qenbolden, _QEnbolden, 0, _QEnbolden, res)) {
	if (xrp[0]) {
	    xrp[0] |= 040;
	    if (xrp[1])
		xrp[1] |= 040;
	}
	if (xrp[0] == 't' ||                 // True
            xrp[0] == 'y' ||                 // Yes
            xrp[0] == 'a' ||                 // Affermative
           (xrp[0] && xrp[1] == 'n'))        // oN
		attr->Enbolden(True);
    }
    CVO_RETURN(attr)
}

//
// The functions are supposed to be inlined, but the compiler won't do it
//
int Cvo_Window::StringWidth(char *str, int len)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringWidth(str, len))
}
int Cvo_Window::StringWidth(wchar_t *str, int len)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringWidth(str, len))
}

int Cvo_Window::StringHeight(char * s, int i)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringHeight(s, i))
}
int Cvo_Window::StringHeight(wchar_t * s, int i)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringHeight(s, i))
}

int
Cvo_Window::StringsExtents(char *s, int n, XRectangle &log)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringsExtents(s, n, log))
}

int
Cvo_Window::StringsExtents(wchar_t *s, int n, XRectangle &log)
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->StringsExtents(s, n, log))
}
