//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: XImage.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/XImage.h++>

Cvo_XImage *Cvo_XImage::root = 0;

Cvo_XImage::Cvo_XImage()
{   CVO_ENTER
    Cvo_Lock lock;

    if (next = root)
	    next->prev = this;
    prev = 0;
    root = this;
    refcnt = 0;
    im = 0;
    basewin = 0;
    CVO_VOID_RETURN
}

Cvo_XImage *
Cvo_LoadXImage(Cvo_BasicObject *win, int fmt, int depth)
{   CVO_ENTER
    Cvo_XImage *cxi = Cvo_XImage::root;

    Cvo_Lock lock;

    win = win->RootObject();

    while (cxi) {
	    if (win == cxi->basewin && cxi->im->format == fmt
				    && cxi->im->depth == depth) {
		    ++cxi->refcnt;
		    CVO_RETURN(cxi)
	    }
	    cxi = cxi->next;
    }
    cxi = new Cvo_XImage;
    cxi->refcnt = 1;
    cxi->basewin = win;
    cxi->im = XCreateImage(win->Dpy(), 0, depth == 1 ? 1 : win->Depth(),
					  fmt, 0, 0, 1, 1,
					  depth == 1 ? 8 : depth, 0);
    if (!cxi->im) {
	printf("Failed to create Image of depth %d\n", depth);
	abort();
    }
    cxi->im->bitmap_bit_order = LSBFirst;
    cxi->im->byte_order = LSBFirst;
    CVO_RETURN(cxi)
}

Cvo_XImage::~Cvo_XImage()
{   CVO_ENTER
	Cvo_Lock lock;

	if (this == root)
		root = this->next;
	if (next)
		next->prev = prev;
	if (prev)
		prev->next = next;
	im->data = 0;
	im->obdata = 0;

	XDestroyImage(im);
    CVO_DONE
}

void
Cvo_XImage::Release()
{   CVO_ENTER
	Cvo_Lock lock;
	if (--refcnt == 0)
		delete this;
    CVO_VOID_RETURN
}
