/* $Id: main.C,v 1.2 1997/11/07 14:19:19 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * Copyright (c) 1997, Peter G. Williams
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/ComboBox.h>
#include <Xarm/Label.h>
#include <Xarm/MessageB.h>
#include <Xarm/Callback.h>
#include <Xarm/XarmArg.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);

   void onItemSelected(Widget, XtPointer, XtPointer);

#if XmVERSION >= 2
   DropDownList *myCombo;
#else
   ComboBox *myCombo;
#endif
  
 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *title = "ComboBox example";

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(), proto, (p_msg)onExit);

   title(::title);

   // install window(s) into the application window 

#if XmVERSION >= 2 || HAS_CDE == yes

#if 0
   DropDownComboBox *foo = new DropDownComboBox(widget());
   ComboBox *foo = new ComboBox(widget());
   DropDownList *foo = new DropDownList(widget());
#endif

#if XmVERSION >= 2
   myCombo = new DropDownList(widget());
#else
   myCombo = new ComboBox(widget());
#endif
   ListClass *list = myCombo->listObject();

   list->add("foo1");
   list->add("foo2");
   list->add("foo3");
   list->add("foo4");
   list->add("foo5");
   list->add("foo6");
   list->add("foo7");
   list->add("foo8");
   list->add("foo9");
   list->visibleItemCount(5);

   myCombo->update(); /* update combobox widget with changes to its children */

   ::addCallback(this, onItemSelected, myCombo->widget(), XarmNselectionCallback);

#if 0
   /* lets look at what we have for children */
   Widget *wl = foo->children();
   int no = foo->numChildren();
   
   for(int i=0; i < no; i++)
   {  
      printf("%d of %d: %s\n",i,no,XtName(wl[i]));
      if (strcmp("ListSW",XtName(wl[i]))==0)
      {
         Widget *wl2;
         int no2;
         XtVaGetValues(wl[i],XmNchildren,&wl2,XmNnumChildren,&no2,NULL);
         
         for(int j=0; j<no2; j++) printf("%s\n",XtName(wl2[j]));
      }
   }
#endif
#else
   new Label(widget(),"No ComboBox Support in this version of Motif");
#endif
}

void Application::onItemSelected(Widget, XtPointer, XtPointer)
{
    cout << "Current selection is: " << myCombo->selectedItem() << endl;
}

void
Application::exit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   quit();
}

void 
Application::onExit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");
   addCallback(diag->widget(), XmNokCallback,(p_msg)exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

