/* $Id: xtab.C,v 1.1.1.1 1997/03/19 13:32:19 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <Xarm/Label.h>
#include <Xarm/PushB.h>
#include <Xarm/MessageB.h>
#include <Xarm/Page.h>
#include "xtab.h"

/* Declaration(s) */

#if !defined(VERSION)
#define VERSION 1
#endif
#if !defined(PATCHLEVEL)
#define PATCHLEVEL 0
#endif
#if !defined(SUBLEVEL)
#define SUBLEVEL 0
#endif

#if !defined(XTAB_VERSION)
#define makestring(str) #str
#define xmakestring(str) makestring(str)
#define XTAB_VERSION xmakestring(VERSION) "." xmakestring(PATCHLEVEL) "." xmakestring(SUBLEVEL)
#endif
#if !defined(XTAB_MODULE_NAME)
#define XTAB_MODULE_NAME "xtab"
#endif
#if !defined(XTAB_COPYRIGHT)
#define XTAB_COPYRIGHT "Copyright (c) 1996 by Peter G. Williams "
#endif

/* Important Note:
 *
 *    For languages other then English modify all the labelString
 * resources here or in the resource file in the main app-defaults 
 * directory.  We can support foreign languages that easily.
 */

/* fallback resources, 
 *
 * The initial app-defaults file should be similar to this.
 *
 */
_XtString fallbacks[] = 
{
   "! " XTAB_MODULE_NAME " resources",
   "! Version " XTAB_VERSION,
   "! " XTAB_COPYRIGHT, 
   "! This resource file was generated by " XTAB_MODULE_NAME ".",
   "! ",
   "*Background: grey",
   "*Foreground: black",
   "*HighlightColor: black",
   "*fontList: -*-helvetica-medium-r-*--12-120-*",
   "*" ".dialogTitle: Tab Example",
   NULL
};

// extra command line options
static XrmOptionDescRec options [] =
{
   { "-g", "*generateResourceFile",  XrmoptionSepArg, NULL },
   { "--generate-resource=", "*generateResourceFile",  XrmoptionSepArg, NULL },
   { "--help",  "*showUsage",  XrmoptionNoArg, "True" }, 
   { "-h",     "*showUsage",  XrmoptionNoArg, "True" },
   { "--version",     "*showVersion",  XrmoptionNoArg, "True" },
   { "-v",     "*showVersion",  XrmoptionNoArg, "True" },
};

#define XtNgenerateResourceFile "generateResourceFile"
#define XtCgenerateResourceFile "GenerateResourceFile"
#define XtNshowUsage "showUsage"
#define XtCshowUsage "ShowUsage"
#define XtNshowVersion "showVersion"
#define XtCshowVersion "ShowVersion"

static XtResource resources[] = 
{
  {
     XtNgenerateResourceFile, 
     XtCgenerateResourceFile,
     XtRString, 
     sizeof(char *), 
     XtOffsetOf(Application, resource_file),
     XtRString, 
     (XtPointer) NULL
  },

  {
     XtNshowUsage, 
     XtCshowUsage,
     XtRBoolean, 
     sizeof(Boolean), 
     XtOffsetOf(Application, show_usage),
     XtRImmediate, 
     (XtPointer) False
  },

  {
     XtNshowVersion, 
     XtCshowVersion,
     XtRBoolean, 
     sizeof(Boolean), 
     XtOffsetOf(Application, show_version),
     XtRImmediate, 
     (XtPointer) False
  },

};

// =========================================================================
// functions
int
main (int argc, char **argv)
{
   // initialize application 
   Application app(Application::basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

// ======================================================================= 
// Application member functions 

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, options, XtNumber(options), argc_in_out, argv_in_out, 
              fallbacks)
{
   // check to see if any args are left over
   if(argc_in_out > 1)
   {
      syntax(argc_in_out, argv_in_out);
   }

   // process application resources
   process_resources();

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),
                         proto,
                         (p_msg)onExit); 

   // set title
   title(app_class);

   // create 
   p_tabdlg = new TabDialog(this->widget());

   addCallback(p_tabdlg->widget(),
               XmNokCallback,
               (p_msg)onExit); 
   addCallback(p_tabdlg->widget(),
               XmNcancelCallback,
               (p_msg)onExit); 

   p_tabdlg->manage();
}

void
Application::version()
{
   /* 
    * I should use iostreams but I don't have a working version.
    * Hmm, maybe a xmostreams class is needed.  Sure sounds ugly or maybe not.
    */
   printf("%s version %s\n", (argv())[0], XTAB_VERSION);
   quit();
}

void
Application::usage()
{
   printf("Usage: %s [OPTION]\n", (argv())[0]);
   printf("  -g FILE  --generate-resource=FILE  Create resource file as FILE.\n");
   printf("  -h  --help  Print this message.\n");
   printf("  -v  --version  Output version info.\n");
   quit();
}

void
Application::process_resources()
{
   get_resources();

   // checked to see if the user wants the version info
   if(show_version == TRUE)
   {
      version();
   }
   // checked to see if the user wants a usage message
   if(show_usage == TRUE)
   {
      usage();
   }
   // checked to see if the user gave us a file name
   if(resource_file != NULL)
   {
      generate_resource_file(resource_file);
   }
}

void
Application::get_resources()
{
   XtGetApplicationResources(widget(), 
                             this, 
                             resources,
                             XtNumber(resources),
                             NULL,
                             0);
}

void
Application::generate_resource_file(char *fname)
{
   // I should use iostreams instead
   FILE *fp = fopen(fname,"w");
   if(fp != NULL)
   {
      // dump contents of fallbacks to the resource file
      for (int i=0; fallbacks[i] != NULL; i++)
      {
         fprintf(fp, "%s\n",fallbacks[i]);
      } 
      fclose(fp);
   }
   quit();
}

void
Application::syntax(int opt_no, char **cmd_opts)
{
   for (int i=1; i< opt_no; i++) 
   {
      fprintf(stderr,"Invalid option: %s\n", cmd_opts[i]);
   }
   quit();
}

char *
Application::basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

void 
Application::onExit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   quit();
}

// ======================================================================= 
// TabDialog member functions 

void
TabDialog::onInit()
{
   PropertyPage *p_page;

   p_page = new BackgroundPage(widget());
   addPage(p_page->widget());

   p_page = new ScreenSaverPage(widget());
   addPage(p_page->widget());
   
   width(400);
   height(300);
}

TabDialog::TabDialog(_XtString name, Widget parent):
           PropertySheet(name, parent) 
{ 
   onInit(); 
}

TabDialog::TabDialog(Widget parent, 
                     ArgList arglist, 
                     Cardinal cnt, 
                     _XtString name):
                     PropertySheet(parent, arglist, cnt, name)
{
   onInit();
}

// ======================================================================= 
// BackgroundPage member functions 
BackgroundPage::BackgroundPage(_XtString name, Widget parent):
           PropertyPage(name, parent) 
{ 
   onInit(); 
}

BackgroundPage::BackgroundPage(Widget parent,
                     ArgList arglist, 
                     Cardinal cnt, 
                     _XtString name):
                     PropertyPage(parent, arglist, cnt, name)
{
   onInit();
}

void
BackgroundPage::onInit()
{
   // set tab header
   dialogTitle("Background");

   frame = new Frame(widget());
   frame->x(5); 
   frame->y(5); 
   frame->width(370);
   frame->height(150);

   /* get a reference to the root window */
   root = new Root(widget());
   
   Pixmap pmap = root->backgroundPixmap();
   frame->backgroundPixmap(pmap);
   
   frame->manage();

   browse = new PushButton(widget(),"Browse...");
   browse->x(5);
   browse->y(180);

   // setup the file selection dialog for the browse button
   p_fsdlg = new FileSelectionDialog(this->widget());
   p_fsdlg->cancelLabelString("Close");
   // look for only Pixmaps
   p_fsdlg->pattern("*.xpm");

   addCallback(widget(), XmNokCallback, (p_msg) onOk);
   addCallback(widget(), XmNapplyCallback, (p_msg) onApply);
   addCallback(browse->widget(), XmNactivateCallback, (p_msg) onBrowse);
   addCallback(p_fsdlg->widget(), XmNokCallback, (p_msg) onFileSelect);
   addCallback(p_fsdlg->widget(), XmNcancelCallback, (p_msg) onFileClose);
}

void 
BackgroundPage::onOk(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   /* set root window with this pixmap */
   Pixmap pmap = frame->backgroundPixmap();
   root->backgroundPixmap(pmap);
}

void 
BackgroundPage::onApply(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   /* set root window with this pixmap */
   Pixmap pmap = frame->backgroundPixmap();
   root->backgroundPixmap(pmap);
}

void 
BackgroundPage::onBrowse(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   p_fsdlg->manage();
}

void 
BackgroundPage::onFileSelect(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   char *str = p_fsdlg->textString();

   if(str == NULL)
   {
      return;
   }

   Pixmap pmap = getPixmap(str);

   /* set background pixmap */
   frame->backgroundPixmap(pmap);

   XtFree(str);
}

void 
BackgroundPage::onFileClose(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   /* hide dialog */
   p_fsdlg->unmanage();
}

// ======================================================================= 
// ScreenSaverPage member functions
ScreenSaverPage::ScreenSaverPage(_XtString name, Widget parent):
           PropertyPage(name, parent)
{
   onInit();
}

ScreenSaverPage::ScreenSaverPage(Widget parent,
                                 ArgList arglist, 
                                 Cardinal cnt, 
                                 _XtString name):
                                 PropertyPage(parent, arglist, cnt, name)
{
   onInit();
}

void
ScreenSaverPage::onInit()
{
   // set tab header
   dialogTitle("Screen Saver");

   Label *p_label = new Label(widget(), "Place Holder");
   
   p_label->x(5);
   p_label->y(5);
}

