/* $Id: xtab.h,v 1.1.1.1 1997/03/19 13:32:19 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(_XTAB_H_)
#define _XTAB_H_

#include <Xarm/AppContext.h>
#include <Xarm/Property.h>
#include <Xarm/Page.h>
#include <Xarm/Frame.h>
#include <Xarm/PushB.h>
#include <Xarm/FileSB.h>
#include <Xarm/RootW.h>

class BackgroundPage : public PropertyPage
{
 private:
   void onInit();
   void onOk(Widget,XtPointer,XtPointer);
   void onApply(Widget,XtPointer,XtPointer);
   void onBrowse(Widget,XtPointer,XtPointer);
   void onFileSelect(Widget,XtPointer,XtPointer);
   void onFileClose(Widget,XtPointer,XtPointer);

   Frame *frame;
   Root *root;
   PushButton *browse;
   FileSelectionDialog *p_fsdlg;

 public:
   BackgroundPage(Widget parent, 
                  ArgList arglist = NULL, 
                  Cardinal cnt = 0,
                  _XtString name = NULL);  
   BackgroundPage(_XtString name, Widget parent);
};

class ScreenSaverPage : public PropertyPage
{
 private:
   void onInit();
 public:
   ScreenSaverPage(Widget parent, 
                   ArgList arglist = NULL, 
                   Cardinal cnt = 0,
                   _XtString name = NULL);  
   ScreenSaverPage(_XtString name, Widget parent);
};

class TabDialog: public PropertySheet
{
 private:
   void onInit();
 public:
   TabDialog(Widget parent,
             ArgList arglist = NULL, 
             Cardinal cnt = 0,
             _XtString name = NULL);  
   TabDialog(_XtString name, Widget parent);
};

class Application: public AppContext
{
 private:
   // internal callback handlers 
   void onExit(Widget,XtPointer,XtPointer);

   // private objects
   TabDialog *p_tabdlg;

 public:
   // application resources
   char *resource_file;
   Boolean show_usage;
   Boolean show_version;

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);

   static char *basename(char *);
   void get_resources();
   void process_resources();
   void syntax(int opt_no, char **opts);
   void generate_resource_file(char *);
   void usage();
   void version();
}; 

#endif 

