/* $Id: AppContext.h,v 1.1.1.1 1997/03/19 13:32:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_APPCONTEXT_H_)
#define _XARM_APPCONTEXT_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ApplicationS.h>

/*
*  Author's note:  Although it is not stated (to my knowledge), the
*  AppContext inherits from the toplevelShellWidget sort of.  
*/
class AppContextClass : public ApplicationShellClass {
 private:
   XtAppContext app_context;

   /*
    * Installs extra functionality hooks
    * File names for Pixmaps types can be specified in resource files
    * This is called right after AppInit routine.
    */
 protected:
   void registerConverters();

   void appContext(XtAppContext ac) { app_context = ac; }
   AppContextClass() {}
 public:
   void addActions(XtActionList actions, Cardinal no);
   void addConverter(_XtString from_type, 
                     _XtString to_type, 
                     XtConverter converter,
                     XtConvertArgList convert_args, 
                     Cardinal no_args);
   XtInputId addInput(int source,XtPointer condition, XtInputCallbackProc proc,
                      XtPointer client_data);
   XtIntervalId addTimeOut(unsigned long interval, XtTimerCallbackProc proc, 
                           XtPointer client_data);
   XtWorkProcId addWorkProc(XtWorkProc proc, XtPointer client_data);
   Boolean dispatchEvent(XEvent *event);
   void error(_XtString msg);
   void errorMsg(_XtString name, 
                 _XtString type, 
                 _XtString _class, 
                 _XtString _default,
                 _XtString *params, 
                 Cardinal *no);
   XrmDatabase *getErrorDatabase();
   void getErrorDatabaseText(char *name, char *type, char *_class,
                             char *_default, char *buffer_return, int nbytes, 
                             XrmDatabase database);
   unsigned long getSelectionTimeout();
   void mainLoop();
   void nextEvent(XEvent * event_return);
   void processEvent(XtInputMask mask); 
   Boolean peekEvent(XEvent * event_return);
   XtInputMask pending();
   
   void removeInput(XtInputId id);
   void removeTimeOut(XtIntervalId timer);
   void removeWorkProc(XtWorkProcId id);
   void setErrorHandler(XtErrorHandler handler);
   void setErrorMsgHandler(XtErrorMsgHandler handler);
   void setSelectionTimeout(unsigned long timeout);
   void setWarningHandler(XtErrorHandler handler);
   void setWarningMsgHandler(XtErrorMsgHandler handler);
   void warning(_XtString msg);
   void warningMsg(_XtString name, 
                   _XtString type, 
                   _XtString _class, 
                   _XtString _default,
                   _XtString *params, Cardinal *no);
   
   /* extras */
   XtAppContext appContext() { return app_context; }
   operator XtAppContext(); // auto cast self to XtApp 
   void quit();
};

class AppContext : public AppContextClass {
 public:
   AppContext(char *app_class,
              XrmOptionDescList options, 
              Cardinal no, 
              int &argc_in_out, 
              char **argv_in_out, 
              _XtString *fallbacks = NULL);

};


#endif
