/* $Id: ConRes.h,v 1.1.1.1 1997/03/19 13:32:20 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_CONRES_H_)
#define _XARM_CONRES_H_

#include <Xarm/Base.h>

class FormConstraintResources : public WObjectClass { 
 protected:
   FormConstraintResources() {}
 public:
   /* constraint resources */
   void bottomAttachment(unsigned char);
   unsigned char bottomAttachment();
   void bottomOffset(int);
   int bottomOffset();
   void bottomPosition(int);
   int bottomPosition();
   void bottomWidget(Widget);
   Widget bottomWidget();
   void leftAttachment(unsigned char);
   unsigned char leftAttachment();
   void leftOffset(int);
   int leftOffset();
   void leftPosition(int);
   int leftPosition();
   void leftWidget(Widget);
   Widget leftWidget();
   void resizable(Boolean); 
   Boolean resizable(); 
   void rightAttachment(unsigned char);
   unsigned char rightAttachment();
   void rightOffset(int);
   int rightOffset();
   void rightPosition(int);
   int rightPosition();
   void rightWidget(Widget);
   Widget rightWidget();
   void topAttachment(unsigned char);
   unsigned char topAttachment();
   void topOffset(int);
   int topOffset();
   void topPosition(int);
   int topPosition();
   void topWidget(Widget);
   Widget topWidget(); 

};

class FrameConstraintResources : public FormConstraintResources { 
 protected:
   FrameConstraintResources() {}
 public:
   /* constraint resources */
   void childType(unsigned char);
   unsigned char childType();
   void childHorizontalAlignment(unsigned char);
   unsigned char childHorizontalAlignment();
   void childHorizontalSpacing(unsigned char);
   unsigned char childHorizontalSpacing();
   void childVerticalAlignment(unsigned char);
   unsigned char childVerticalAlignment();
};

class PanedWindowConstraintResources : public FrameConstraintResources {
 protected:
   PanedWindowConstraintResources() {}
 public:
   /* constraints */
   void allowResize(Boolean);
   Boolean allowResize();
   void paneMaximum(Dimension);
   Dimension paneMaximum();
   void paneMinimum(Dimension);
   Dimension paneMinimum();
   void positionIndex(short);
   short positionIndex();
   void skipAdjust(Boolean);
   Boolean skipAdjust();
};

class RowColumnConstraintResources : public PanedWindowConstraintResources {
 protected:
   RowColumnConstraintResources() {}
 public:
   /* constraint resources */
   void positionIndex(short s);
   short positionIndex();
};

class ConstraintResources : public RowColumnConstraintResources {
 protected:
   ConstraintResources() {}
};

#endif
