/* $Id: DrawnB.h,v 1.2 1997/04/07 15:33:18 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_DRAWNB_H_)
#define _XARM_DRAWNB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class DrawnButtonClass : public LabelClass {
 protected:
   DrawnButtonClass() {}
   virtual WidgetClass classPointer() { return xmDrawnButtonWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmDrawnButton"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void exposeCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void resizeCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* resources */
   void multiClick(unsigned char c);
   unsigned char multiClick();
   void pushButtonEnabled(Boolean b);
   Boolean pushButtonEnabled();
   void shadowType(unsigned char c);
   unsigned char shadowType();
};
   
class DrawnButton : public DrawnButtonClass {
 public:
   DrawnButton(Widget w_parent,
               ArgList arglist = NULL,
               Cardinal cnt = 0,
               _XtString name = NULL);
   DrawnButton(_XtString name, Widget w_parent);
   DrawnButton(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
