/* $Id: FileSB.h,v 1.2 1997/04/07 15:33:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_FILESB_H_)
#define _XARM_FILESB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class FileSelectionBoxClass : public SelectionBoxClass {
 protected:
   FileSelectionBoxClass() {}
   virtual WidgetClass classPointer() { return xmFileSelectionBoxWidgetClass; } 
   virtual _XtString className() { return (_XtString) "XmFileSelectionBox"; }
 public:
   /* convenience routines */
   virtual Widget getChild(unsigned char);
   void doSearch(char *str); 

   /* resources */
   void directory(char *);
   char *directory();
   void directoryValid(Boolean);
   Boolean directoryValid();
   void dirListItems(XmStringTable);
   XmStringTable dirListItems();
   void dirListItemCount(int);
   int dirListItemCount();
   void dirListLabelString(char *);
   char *dirListLabelString();
   void dirMask(char *);
   char *dirMask();
   void dirSearchProc(XmSearchProc);
   XmSearchProc dirSearchProc();
   void dirSpec(char *);
   char *dirSpec();
   void fileListItems(XmStringTable);
   XmStringTable fileListItems();
   void fileListItemCount(int);
   int fileListItemCount();
   void fileListLabelString(char *);
   char *fileListLabelString();
   void fileSearchProc(XmSearchProc);
   XmSearchProc fileSearchProc();
   void fileTypeMask(unsigned char);
   unsigned char fileTypeMask();
   void filterLabelString(char *);
   char *filterLabelString();
   void listUpdated(Boolean);
   Boolean listUpdated();
   void noMatchString(char *);
   char *noMatchString();
   void pattern(char *);
   char * pattern();
   void qualifySearchDataProc(XmQualifyProc);
   XmQualifyProc qualifySearchDataProc();
   
 
};

class FileSelectionBox : public FileSelectionBoxClass {
 public:
   FileSelectionBox(Widget w_parent, 
                    ArgList arglist = NULL, 
                    Cardinal cnt = 0,
                    _XtString name = NULL);
   FileSelectionBox(_XtString name, Widget w_parent);
   FileSelectionBox(Widget w_parent, XarmArg &args, _XtString name);
};

class FileSelectionDialog : public FileSelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent, 
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   FileSelectionDialog(Widget w_parent, 
                       ArgList arglist = NULL, 
                       Cardinal cnt = 0,
                       _XtString name = NULL);
   FileSelectionDialog(_XtString name, Widget w_parent);
   FileSelectionDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
