/* $Id: Form.h,v 1.2 1997/04/07 15:33:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_FORM_H_)
#define _XARM_FORM_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class FormClass : public BulletinBoardClass {
 protected:
   FormClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmFormWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmForm"; } 
 public:
   /* resources */
   void fractionBase(int);
   int fractionBase();
   void horizontalSpacing(Dimension);
   Dimension horizontalSpacing();
   void rubberPositioning(Boolean);
   Boolean rubberPositioning();
   void verticalSpacing(Dimension);
   Dimension verticalSpacing();
};

class Form : public FormClass {
 public:
   Form(Widget w_parent,
        ArgList arglist = NULL,
        Cardinal cnt = 0,
        _XtString name = NULL);
   Form(_XtString name, Widget w_parent);
   Form(Widget w_parent, XarmArg &args, _XtString name);
};

class FormDialog : public FormClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent, 
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   FormDialog(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   FormDialog(_XtString name, Widget w_parent);
   FormDialog(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
