/* $Id: Label.h,v 1.2 1997/04/07 15:33:19 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_LABEL_H_)
#define _XARM_LABEL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class LabelClass : public PrimitiveClass {
 protected:
   LabelClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmLabelWidgetClass; }
   /* class name */
   virtual _XtString className() { return (_XtString) "XmLabel"; }
 public:
   /* resources */
   void accelerator(_XtString str);
   _XtString accelerator();
   void acceleratorText(char *str);
   char *acceleratorText();
   void alignment(unsigned char);
   unsigned char alignment();
   void fontList(XmFontList);
   XmFontList fontList();
   void labelInsensitivePixmap(Pixmap);
   Pixmap labelInsensitivePixmap();
   void labelPixmap(Pixmap);
   Pixmap labelPixmap();
   void labelString(char *str);
   char *labelString();
   void labelType(unsigned char);
   unsigned char labelType();
   void marginBottom(Dimension);
   Dimension marginBottom();
   void marginHeight(Dimension);
   Dimension marginHeight();
   void marginLeft(Dimension);
   Dimension marginLeft();
   void marginRight(Dimension);
   Dimension marginRight();
   void marginTop(Dimension);
   Dimension marginTop();
   void marginWidth(Dimension);
   Dimension marginWidth();
   void mnemonic(KeySym);
   KeySym mnemonic();
   void mnemonicCharSet(_XtString);
   _XtString mnemonicCharSet();
   void recomputeSize(Boolean); 
   Boolean recomputeSize();
   void stringDirection(XmStringDirection);
   XmStringDirection stringDirection();
};

class Label : public LabelClass {
 public:
   Label(Widget w_parent, char *str, _XtString name = NULL);
   Label(Widget w_parent, 
         ArgList arglist = NULL, 
         Cardinal cnt = 0, 
         _XtString name = NULL);
   Label(_XtString name, Widget w_parent); 
   Label(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
