/* $Id: ScrollBar.h,v 1.3 1997/04/15 12:44:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SCROLLBAR_H_)
#define _XARM_SCROLLBAR_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class ScrollBarClass : public PrimitiveClass {
 protected:
   ScrollBarClass() {}
   virtual WidgetClass classPointer() { return xmScrollBarWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmScrollBar"; }
 public:
   /* Callbacks */
   void decrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void dragCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void incrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void pageDecrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void pageIncrementCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void toBottomCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void toTopCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);  

   /* Resources */
   void increment(int);
   int increment();
   void initialDelay(int);
   int initialDelay();
   void maximum(int);
   int maximum();
   void minimum(int);
   int minimum();
   void orientation(unsigned char);
   unsigned char orientation();
   void processingDirection(unsigned char);   
   unsigned char processingDirection();   
   void repeatDelay(int);
   int repeatDelay();
   void showArrows(Boolean);
   Boolean showArrows(); 
   void sliderSize(int);
   int sliderSize();
   void troughColor(Pixel);
   Pixel troughColor();
   void value(int);
   int value();
};

class ScrollBar : public ScrollBarClass {
 public:
   ScrollBar(Widget w_parent,
             ArgList arglist = NULL,
             Cardinal cnt = 0,
             _XtString name = NULL);
   ScrollBar(_XtString name, Widget w_parent);
   ScrollBar(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
