/* $Id: Shell.h,v 1.3 1997/04/07 15:33:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SHELL_H_)
#define _XARM_SHELL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Composite.h>

class ShellClass : public CompositeClass {
 protected:
   ShellClass() {}
   
   virtual WidgetClass classPointer() { return shellWidgetClass; }
   virtual _XtString className() { return (_XtString) "Shell"; }
 public:
   /* callbacks */
   void popdownCallback(XtCallbackProc fp, XtPointer data = NULL);
   void popupCallback(XtCallbackProc fp, XtPointer data = NULL);

   /* convenience routines */
   void activateProtocol(Atom property, Atom protocol);
   void activateWMProtocol(Atom protocol);

   /* resources */
   Boolean allowShellResize();
   void createPopupChildProc(XtCreatePopupChildProc);
   XtCreatePopupChildProc createPopupChildProc();
   void geometry(_XtString);
   _XtString geometry();
   void overrideRedirect(Boolean);
   Boolean overrideRedirect();
   void saveUnder(Boolean);
   Boolean saveUnder();
   void visual(Visual *);
   Visual *visual();
};


class WMShellClass : public ShellClass {
 protected:
   WMShellClass() {}

   virtual WidgetClass classPointer() { return wmShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "WMShell"; }
 public:
   /* resources */
   void baseHeight(int);
   int baseHeight();
   void baseWidth(int);
   int baseWidth();
   void heightInc(int);
   int heightInc();
   void iconMask(Pixmap);
   Pixmap iconMask();
   void iconPixmap(Pixmap);
   Pixmap iconPixmap();
   void iconWindow(Window);
   Window iconWindow();
   void iconX(int);
   int iconX();
   void iconY(int);
   int iconY();
   void initialState(int);
   int initialState();
   void input(Boolean);
   Boolean input();
   void maxAspectX(int);
   int maxAspectX();
   void maxAspectY(int);
   int maxAspectY();
   void maxHeight(int);
   int maxHeight();
   void maxWidth(int);
   int maxWidth();
   void minAspectX(int);
   int minAspectX();
   void minAspectY(int);
   int minAspectY();
   void minHeight(int);
   int minHeight();
   void minWidth(int);
   int minWidth();
   void title(_XtString);
   _XtString title();
   void titleEncoding(Atom);
   Atom titleEncoding();
   void transient(Boolean);
   Boolean transient();
   void waitForWm(Boolean);
   Boolean waitForWm();
   void widthInc(int);
   int widthInc();
   void windowGroup(Window);
   Window windowGroup();
   void winGravity(int);
   int winGravity();
   void wmTimeout(int);
   int wmTimeout();
};

#include <Xarm/VendorS.h>

class TransientShellClass : public VendorShellClass {
 protected:
   TransientShellClass() {}

   virtual WidgetClass classPointer() { return transientShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "TransientShell"; }
 public:
   /* resources */
   void transientFor(Widget);
   Widget transientFor();
};

class TopLevelShellClass : public VendorShellClass {
 protected:
   TopLevelShellClass() {}

   virtual WidgetClass classPointer() { return topLevelShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "TopLevelShell"; }
 public:
   /* resources */
   void iconic(Boolean);
   Boolean iconic();
   void iconName(_XtString);
   _XtString iconName();
   void iconNameEncoding(Atom);
   Atom iconNameEncoding();

   /* extra */
   void realize();
   void unrealize(); 
};

class TopLevelShell : public TopLevelShellClass {
 public:
   TopLevelShell(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   TopLevelShell(_XtString name, Widget w_parent);
   TopLevelShell(Widget w_parent, XarmArg &args, _XtString name);
};

class PopupShell : public TopLevelShellClass {
  protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PopupShell(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   PopupShell(_XtString name, Widget w_parent);
   PopupShell(Widget w_parent, XarmArg &args, _XtString name);
   void popup();
   void popdown();
};

class OverrideShellClass : public ShellClass {
 protected:
   OverrideShellClass() {}

   virtual WidgetClass classPointer() { return overrideShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "OverrideShell"; }
};

#endif
