/* $Id: ToggleBG.h,v 1.2 1997/04/07 15:33:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TOGGLEBG_H_)
#define _XARM_TOGGLEBG_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>

class ToggleButtonGadgetClass : public LabelGadgetClass {
 protected:
   ToggleButtonGadgetClass() {}
   virtual WidgetClass classPointer() { return xmToggleButtonGadgetClass; }
   virtual _XtString className() { return (_XtString) "XmToggleButtonGadget"; }
 public:
   /* callbacks */
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* convenience functions */
   Boolean getState();
   void setState(Boolean state, Boolean notify = FALSE);

   /* resources */
   void fillOnSelect(Boolean);
   Boolean fillOnSelect();
   void indicatorOn(Boolean);
   Boolean indicatorOn();
   void indicatorSize(Dimension);
   Dimension indicatorSize();
   void indicatorType(unsigned char);
   unsigned char indicatorType();
   void selectColor(Pixel);
   Pixel selectColor();
   void selectInsensitivePixmap(Pixmap);
   Pixmap selectInsensitivePixmap();
   void set(Boolean);
   Boolean set();
   void spacing(Dimension);
   Dimension spacing();
   void visibleWhenOff(Boolean);
   Boolean visibleWhenOff();
};

class ToggleButtonGadget : public ToggleButtonGadgetClass {
 public:
   ToggleButtonGadget(Widget w_parent,
                      char *text,
                      KeySym mn = 0,
                      _XtString acc = NULL, 
                      char *acc_text = NULL,
                      _XtString name = NULL);
   ToggleButtonGadget(Widget w_parent,
                      ArgList arglist = NULL,
                      Cardinal cnt = 0,
                      _XtString name = NULL);
   ToggleButtonGadget(_XtString name, Widget w_parent);
   ToggleButtonGadget(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
