/* $Id: PageP.h,v 1.1.1.1 1997/03/19 13:32:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XM_PROPERTY_PAGEP_H_)
#define _XM_PROPERTY_PAGEP_H_

#include <Xm/XmP.h>
#include <Xmext/Page.h>
#include <Xm/BulletinBP.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* ======================================================================== */
/* PropertyPage Widget */
/* Define the page instance part */
typedef struct {
   XtCallbackList kill_active_callback;
   XtCallbackList set_active_callback;
   XtCallbackList cancel_callback;
   XtCallbackList apply_callback;
   XtCallbackList ok_callback;
} XmPropertyPagePart;

/* Define the full instance record */
typedef struct _XmPropertyPageRec {
   /* inherit from the following */
   CorePart core;
   CompositePart composite;
   ConstraintPart constraint;
   XmManagerPart manager;
   XmBulletinBoardPart bulletin_board;
   /* self */
   XmPropertyPagePart property_page;
} XmPropertyPageRec;
   
/* Define class part structure */
typedef struct {
   XtPointer extension;
} XmPropertyPageClassPart;

/* Define the full class record */
typedef struct _XmPropertyPageClassRec {
   CoreClassPart core_class;
   CompositeClassPart composite_class;
   ConstraintClassPart constraint_class;
   XmManagerClassPart manager_class;
   XmBulletinBoardClassPart bulletin_board_class;
   XmPropertyPageClassPart property_page_class;
} XmPropertyPageClassRec;

extern XmPropertyPageClassRec xmPropertyPageClassRec;

#define PP_KillActiveCallback(w) \
        (((XmPropertyPageWidget) (w))->property_page.kill_active_callback)

#define PP_SetActiveCallback(w) \
        (((XmPropertyPageWidget) (w))->property_page.set_active_callback)

#define PP_CancelCallback(w) \
        (((XmPropertyPageWidget) (w))->property_page.cancel_callback)

#define PP_ApplyCallback(w) \
        (((XmPropertyPageWidget) (w))->property_page.apply_callback)

#define PP_OkCallback(w) \
        (((XmPropertyPageWidget) (w))->property_page.ok_callback)

#if defined(__cplusplus)
};
#endif

#endif
