/* $Id: PropertyP.h,v 1.1.1.1 1997/03/19 13:32:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XM_PROPERTYP_H_)
#define _XM_PROPERTYP_H_

#include <Xm/XmP.h>
#include <Xmext/Property.h>
#include <Xm/BulletinBP.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* ======================================================================== */
/* PropertySheet Widget */
/* Define the sheet instance part */
typedef struct {
   /* public */
   int active_pos;

   XmString apply_label_string;
   XtCallbackList apply_callback;
   Widget apply_button;

   XmString cancel_label_string;
   XtCallbackList cancel_callback;

   XmString ok_label_string;
   XtCallbackList ok_callback;
   Widget ok_button;

   XmString help_label_string; /* help button is optional */
   Widget help_button;         

   int page_count;
   WidgetList pages;
   WidgetList tabs;

   /* private */
   Widget separator;     
   Widget tab_holder;     
} XmPropertySheetPart;

/* Define the full instance record */
typedef struct _XmPropertySheetRec {
   /* inherit from the following */
   CorePart core;
   CompositePart composite;
   ConstraintPart constraint;
   XmManagerPart manager;
   XmBulletinBoardPart bulletin_board;
   /* self */
   XmPropertySheetPart property_sheet;
} XmPropertySheetRec;
   
/* Define class part structure */
typedef struct {
   XtPointer extension;
} XmPropertySheetClassPart;

/* Define the full class record */
typedef struct _XmPropertySheetClassRec {
   CoreClassPart core_class;
   CompositeClassPart composite_class;
   ConstraintClassPart constraint_class;
   XmManagerClassPart manager_class;
   XmBulletinBoardClassPart bulletin_board_class;
   XmPropertySheetClassPart property_sheet_class;
} XmPropertySheetClassRec;

extern XmPropertySheetClassRec xmPropertySheetClassRec;

#define PS_ApplyButton(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.apply_button)

#define PS_OkButton(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.ok_button)

#define PS_CancelButton(w) \
        (((XmPropertySheetWidget) (w))->bulletin_board.cancel_button)

#define PS_DefaultButton(w) \
        (((XmPropertySheetWidget) (w))->bulletin_board.default_button)

#define PS_HelpButton(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.help_button)

#define PS_ActivePos(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.active_pos)

#define PS_ActivePage(w) \
        (PS_ActivePos(w) <= 0 ? NULL : \
        (((XmPropertySheetWidget) (w))->property_sheet.pages[PS_ActivePos(w)-1]))

#define PS_ActiveTab(w) \
        (PS_ActivePos(w) <= 0 ? NULL : \
        (((XmPropertySheetWidget) (w))->property_sheet.tabs[PS_ActivePos(w)-1]))

#define PS_PageCount(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.page_count)

#define PS_Pages(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.pages)

#define PS_Tabs(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.tabs)

#define PS_CancelCallback(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.cancel_callback)

#define PS_ApplyCallback(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.apply_callback)

#define PS_OkCallback(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.ok_callback)

#define PS_HelpCallback(w) \
        (((XmPropertySheetWidget) (w))->manager.help_callback)

#define PS_TabHolder(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.tab_holder)

#define PS_Separator(w) \
        (((XmPropertySheetWidget) (w))->property_sheet.separator)

#if defined(__cplusplus)
};
#endif

#endif
