/* $Id: Callback.C,v 1.2 1997/03/23 13:53:38 glgay Exp $ */
/*
 Copyright (C) 1996 Gerald L. Gay
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

/* Include(s): */
#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <Xm/XmAll.h>
#include <Xarm/Callback.h>
#include <stl.h>


/* internal handlers */
static void    callbackHandler(Widget, XtPointer, XtPointer);
static void    deleteHandler(Widget, XtPointer, XtPointer);
static Boolean workHandler(XtPointer);
static void    timerHandler(XtPointer, XtIntervalId *);
static void    inputHandler(XtPointer, int *, XtInputId *);
static void    eventHandler(Widget, XtPointer, XEvent *, Boolean *);

/* fake object */
class FakeObj;

typedef void (FakeObj::*p_msg)(Widget, XtPointer, XtPointer);
typedef Boolean (FakeObj::*p_wrk)(XtPointer);
typedef void (FakeObj::*p_timer)(XtPointer, XtIntervalId *);
typedef void (FakeObj::*p_input)(XtPointer, int *, XtInputId *);
typedef void (FakeObj::*p_event)(Widget, XtPointer, XEvent *, Boolean *);

typedef CallbackInfo<FakeObj> FakeCallbackInfo;
typedef ProtocolInfo<FakeObj> FakeProtoInfo;
typedef WorkInfo<FakeObj>     FakeWorkInfo;
typedef TimerInfo<FakeObj>    FakeTimerInfo;
typedef InputInfo<FakeObj>    FakeInputInfo;
typedef EventInfo<FakeObj>    FakeEventInfo;

/* internal list */
typedef vector<FakeCallbackInfo *> cbVec;
typedef vector<FakeProtoInfo *>    protoVec;
typedef vector<FakeWorkInfo *>     workVec;
typedef vector<FakeTimerInfo *>    timerVec;
typedef vector<FakeInputInfo *>    inputVec;
typedef vector<FakeEventInfo *>    eventVec;

static cbVec    _internal_XTC_vec;
static protoVec _internal_PRO_vec;
static workVec  _internal_WRK_vec;
static timerVec _internal_TIM_vec;
static inputVec _internal_INP_vec;
static eventVec _internal_EVT_vec;

static bool inWorkHandler = false;

void callbackHandler(Widget w, XtPointer udata, XtPointer cdata)
{
   if (udata == NULL) return;

   FakeCallbackInfo *ci = (FakeCallbackInfo *)udata;

   FakeObj *obj = ci->_target;
   p_msg mf     = ci->_callback;    

   (obj->*(mf))(w, ci->_closure, cdata);
}

Boolean workHandler(XtPointer data)
{
    if (data == NULL) return(True);

    FakeWorkInfo *fwi = (FakeWorkInfo *)data;
    FakeObj *obj      = fwi->_target;
    p_wrk mf          = fwi->_callback;

    /* Call the work proc, if it returns true, it */
    /* will be removed by Xt, so make sure we     */
    /* remove it from our list also.              */

    Boolean result = (obj->*(mf))(fwi->_closure);

    if (result == True) {
        inWorkHandler = true;
	removeWorkProc(fwi->_id);
	inWorkHandler = false;
    }

    return(result);
}

void timerHandler(XtPointer data, XtIntervalId *tid)
{
    if (data == NULL) return;

    FakeTimerInfo *fti = (FakeTimerInfo *)data;
    FakeObj *obj       = fti->_target;
    p_timer mf         = fti->_callback;

    (obj->*(mf))(fti->_closure, tid);

    removeTimeOut(fti->_id);

}

void inputHandler(XtPointer data, int *something, XtInputId *iid)
{
    if (data == NULL) return;

    FakeInputInfo *fii = (FakeInputInfo *)data;
    FakeObj *obj       = fii->_target;
    p_input mf         = fii->_callback;

    (obj->*(mf))(fii->_closure, something, iid);

}

void eventHandler(Widget w, XtPointer data, XEvent *xev, Boolean *pb)
{
   if (data == NULL) return;

   FakeEventInfo *pei = (FakeEventInfo *)data;

   FakeObj *obj = pei->_target;
   p_event mf   = pei->_callback;    

   (obj->*(mf))(w, pei->_closure, xev, pb);
}

void deleteHandler(Widget , XtPointer udata, XtPointer )
{
   if (udata == NULL) return;

   FakeCallbackInfo *ci = (FakeCallbackInfo *) udata;
   FakeProtoInfo    *pi = (FakeProtoInfo *)    udata;
   FakeEventInfo    *ei = (FakeEventInfo *)    udata;

   cbVec::iterator cit = find(_internal_XTC_vec.begin(),
			     _internal_XTC_vec.end(),
			     ci );

   if ( cit != _internal_XTC_vec.end() ) {
       _internal_XTC_vec.erase(cit);
       delete ci;

   } else {

       protoVec::iterator pit = find(_internal_PRO_vec.begin(),
				     _internal_PRO_vec.end(),
				     pi);

       if ( pit != _internal_PRO_vec.end() ) {
	   _internal_PRO_vec.erase(pit);
	   delete pi;

       } else {

	   eventVec::iterator eit = find(_internal_EVT_vec.begin(),
					 _internal_EVT_vec.end(),
					 ei);

	   if (eit != _internal_EVT_vec.end()) {
	       _internal_EVT_vec.erase(eit);
	       delete ei;
	   }
       }
   }
}

/************************************************************
 * The only complicated part about removing all callbacks   *
 * is due to the fact that we are using a vector to store   *
 * the calbackInfo pointers.  Once you call erase() on a    *
 * vector element, all iterators that point *after* it are  *
 * invalidated.  You must therefore walk backward through   *
 * the vector and be very careful about referencing the     *
 * iterator after the erase() call.                         *
 ************************************************************/

void removeAllCallbacks(Widget w, _XtString cb_type)
{
    if (_internal_XTC_vec.size() == 0) return;

    cbVec::iterator it = _internal_XTC_vec.end() - 1;

    while (it != _internal_XTC_vec.begin()) {
        if ( ((*it)->_widget == w) && ((*it)->_type == cb_type) ) {
	    delete *it;
	    _internal_XTC_vec.erase(it--);
	} else {
	    --it;
	}
    }

    /* it now points at the first node, check it */

    if ( ((*it)->_widget == w) && ((*it)->_type == cb_type) ) {
        delete *it;
	_internal_XTC_vec.erase(it);
    }

    XtRemoveAllCallbacks(w, cb_type);

}

void unregisterCallback(void *info)
{
   if (info == NULL) return;

   FakeCallbackInfo *ci = (FakeCallbackInfo *) info;
   FakeCallbackInfo *rci = NULL;
   cbVec::iterator it;

   for (it = _internal_XTC_vec.begin();
	it != _internal_XTC_vec.end();
	++it ) {

       if (memcmp(*it, ci, sizeof(FakeCallbackInfo)) == 0) {
	   rci = *it;
	   break;
       }
   }

   if (rci == NULL) return;

   XtRemoveCallback(rci->_widget,
		    rci->_type,
		    (XtCallbackProc) callbackHandler,
		    (XtPointer) rci);

   XtRemoveCallback(rci->_widget,
		    XmNdestroyCallback,
		    (XtCallbackProc) deleteHandler,
		    (XtPointer) rci );

   _internal_XTC_vec.erase(it);
   delete rci;

}

void registerCallback(void *info)
{
   if (info == NULL) return;

   FakeCallbackInfo *ci = (FakeCallbackInfo *) info;

   /* install handler */
   XtAddCallback(ci->_widget,
                 ci->_type,
                 (XtCallbackProc)callbackHandler,
                 (XtPointer)info);

   XtAddCallback(ci->_widget,
                 XmNdestroyCallback,
                 (XtCallbackProc)deleteHandler,
                 (XtPointer)info);

   _internal_XTC_vec.push_back(ci);
}

void registerProtoCallback(void *info)
{
   if (info == NULL) return;

   FakeProtoInfo *pi = (FakeProtoInfo *) info;

   /* install handler */
   XmAddProtocolCallback(pi->_widget,
                         pi->_property,
			 pi->_protocol,
                         (XtCallbackProc)callbackHandler,
                         (XtPointer)info);

   XtAddCallback(pi->_widget,
                 XmNdestroyCallback,
                 (XtCallbackProc)deleteHandler,
                 (XtPointer)info);

   _internal_PRO_vec.push_back(pi);
}

void unregisterProtoCallback(void *info)
{
   if (info == NULL) return;

   FakeProtoInfo *pi = (FakeProtoInfo *) info;

   XmRemoveProtocolCallback(pi->_widget,
			    pi->_property,
			    pi->_protocol,
			    (XtCallbackProc)callbackHandler,
			    (XtPointer)info);

   XtRemoveCallback(pi->_widget,
		    XmNdestroyCallback,
		    (XtCallbackProc) deleteHandler,
		    (XtPointer) pi );

   for (protoVec::iterator it = _internal_PRO_vec.begin();
	                   it != _internal_PRO_vec.end();
	                   ++it ) {

       if (memcmp(*it, pi, sizeof(FakeProtoInfo)) == 0) {
	   _internal_PRO_vec.erase(it);
	   delete pi;
	   return;
       }
   }
}

XtWorkProcId registerWorkProc(void *data, XtAppContext ac)
{
    FakeWorkInfo *fwi = (FakeWorkInfo *)data;

    _internal_WRK_vec.push_back(fwi);

    fwi->_id = XtAppAddWorkProc(ac, (XtWorkProc)workHandler, fwi);

    return (fwi->_id);
}

void removeWorkProc(XtWorkProcId wpID)
{

    for (workVec::iterator it =  _internal_WRK_vec.begin();
	                   it != _internal_WRK_vec.end();
	                 ++it ) {

      if ((*it)->_id == wpID) {
	  FakeWorkInfo *fwi = *it;
	  _internal_WRK_vec.erase(it);
	  delete fwi;

	  /* Don't bother removing if we're about to return */
	  /* true from the handler.                         */

	  if (!inWorkHandler)
	      XtRemoveWorkProc(wpID);

	  return;
      }
    }
}

XtIntervalId registerTimeOut(void *data, XtAppContext ac, unsigned long interval)
{
    FakeTimerInfo *fti = (FakeTimerInfo *)data;

    _internal_TIM_vec.push_back(fti);

    fti->_id = XtAppAddTimeOut(ac, interval, (XtTimerCallbackProc)timerHandler, fti);

    return (fti->_id);
}

void removeTimeOut(XtIntervalId tID)
{

    XtRemoveTimeOut(tID);

    for (timerVec::iterator it =  _internal_TIM_vec.begin();
	                    it != _internal_TIM_vec.end();
	                  ++it ) {

      if ((*it)->_id == tID) {
	  FakeTimerInfo *fti = *it;
	  _internal_TIM_vec.erase(it);
	  delete fti;

	  return;
      }
    }
}

XtInputId registerInput(void *data, XtAppContext ac, int source, XtPointer condition)
{
    FakeInputInfo *fii = (FakeInputInfo *)data;

    _internal_INP_vec.push_back(fii);

    fii->_id = XtAppAddInput(ac, source, condition, (XtInputCallbackProc)inputHandler, fii);

    return (fii->_id);
}

void removeInput(XtInputId iID)
{

    XtRemoveInput(iID);

    for (inputVec::iterator it =  _internal_INP_vec.begin();
	                    it != _internal_INP_vec.end();
	                  ++it ) {

      if ((*it)->_id == iID) {
	  FakeInputInfo *fii = *it;
	  _internal_INP_vec.erase(it);
	  delete fii;

	  return;
      }
    }
}

void registerEventHandler(void *info)
{
   if (info == NULL) return;

   FakeEventInfo *ei = (FakeEventInfo *) info;

   /* install handler */

   XtAddEventHandler(ei->_widget,
		     ei->_em,
		     ei->_nonmaskable,
		     (XtEventHandler)eventHandler,
		     (XtPointer)ei);

   XtAddCallback(ei->_widget,
                 XmNdestroyCallback,
                 (XtCallbackProc)deleteHandler,
                 (XtPointer)info);

   _internal_EVT_vec.push_back(ei);
}

void unregisterEventHandler(void *info)
{
   if (info == NULL) return;

   FakeEventInfo *ei = (FakeEventInfo *) info;
   FakeEventInfo *rei = NULL;
   eventVec::iterator it;

   for (it = _internal_EVT_vec.begin();
	it != _internal_EVT_vec.end();
	++it ) {

       if (memcmp(*it, ei, sizeof(FakeEventInfo)) == 0) {
	   rei = *it;
	   break;
       }
   }

   if (rei == NULL) return;

   XtRemoveEventHandler(rei->_widget,
			rei->_em,
			rei->_nonmaskable,
			(XtEventHandler)eventHandler,
			rei);

   XtRemoveCallback(rei->_widget,
		    XmNdestroyCallback,
		    (XtCallbackProc) deleteHandler,
		    (XtPointer) rei );

}

/* */
