/* $Id: CascadeB.C,v 1.2 1997/04/08 15:20:53 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/CascadeB.h>

/* CascadeButtonClass member functions */
void
CascadeButtonClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
CascadeButtonClass::cascadingCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcascadingCallback,fp,udata);
}

void
CascadeButtonClass::cascadePixmap(Pixmap id)
{
   XtVaSetValues(widget(),XmNcascadePixmap,id, NULL);
}

Pixmap
CascadeButtonClass::cascadePixmap()
{
   Pixmap id;
   XtVaSetValues(widget(),XmNcascadePixmap, &id, NULL);
   return id;
}

void
CascadeButtonClass::mappingDelay(int delay)
{
   XtVaSetValues(widget(),XmNmappingDelay,delay, NULL);
}   

int
CascadeButtonClass::mappingDelay()
{
   int delay;
   XtVaSetValues(widget(),XmNmappingDelay, &delay, NULL);
   return delay;
}   

void
CascadeButtonClass::subMenuId(Widget sub)
{
   if(sub)
   {
      XtVaSetValues(widget(),XmNsubMenuId,sub, NULL);
   }
}

Widget
CascadeButtonClass::subMenuId()
{
   Widget w;
   XtVaSetValues(widget(),XmNsubMenuId,&w, NULL);
   return w;
}

/* constructors */

CascadeButton::CascadeButton(Widget w_parent,char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   labelString(str);
   manage();
}

CascadeButton::CascadeButton(Widget w_parent, ArgList arglist, Cardinal cnt, 
                             _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

CascadeButton::CascadeButton(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
   manage();
}


CascadeButton::CascadeButton(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}


/* */
