/* $Id: CascadeBG.C,v 1.2 1997/04/08 15:20:54 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Xarm/CascadeBG.h>

/* CascadeButtonGadgetClass member functions */
void
CascadeButtonGadgetClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
CascadeButtonGadgetClass::cascadingCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNcascadingCallback,fp,udata);
}

void
CascadeButtonGadgetClass::cascadePixmap(Pixmap id)
{
   XtVaSetValues(widget(),XmNcascadePixmap,id, NULL);
}

Pixmap
CascadeButtonGadgetClass::cascadePixmap()
{
   Pixmap id;
   XtVaSetValues(widget(),XmNcascadePixmap, &id, NULL);
   return id;
}

void
CascadeButtonGadgetClass::mappingDelay(int delay)
{
   XtVaSetValues(widget(),XmNmappingDelay,delay, NULL);
}   

int
CascadeButtonGadgetClass::mappingDelay()
{
   int delay;
   XtVaSetValues(widget(),XmNmappingDelay, &delay, NULL);
   return delay;
}   

void
CascadeButtonGadgetClass::subMenuId(Widget sub)
{
   if(sub)
   {
      XtVaSetValues(widget(),XmNsubMenuId,sub, NULL);
   }
}

Widget
CascadeButtonGadgetClass::subMenuId()
{
   Widget w;
   XtVaSetValues(widget(),XmNsubMenuId,&w, NULL);
   return w;
}

/* constructors */
CascadeButtonGadget::CascadeButtonGadget(Widget w_parent, char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   labelString(str);
   manage();
}

CascadeButtonGadget::CascadeButtonGadget(Widget w_parent, 
                                         ArgList arglist, 
                                         Cardinal cnt,
                                         _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

CascadeButtonGadget::CascadeButtonGadget(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
   manage();
}


CascadeButtonGadget::CascadeButtonGadget(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}
/* */
