/* $Id: Core.C,v 1.1.1.1 1997/03/19 13:32:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/Core.h>

   /* resources */
void 
CoreClass::accelerators(XtAccelerators acc)
{
   XtVaSetValues(widget(),XmNaccelerators, acc, NULL);
}

XtAccelerators 
CoreClass::accelerators()
{
   XtAccelerators acc;
   XtVaGetValues(widget(),XmNaccelerators, &acc, NULL);
   return acc;
}

void 
CoreClass::background(Pixel p)
{
   XtVaSetValues(widget(),XmNbackground, p, NULL);
}

Pixel 
CoreClass::background()
{
   Pixel p;
   XtVaGetValues(widget(),XmNbackground, &p, NULL);
   return p;
}

void
CoreClass::backgroundPixmap(char *fname)
{
   Pixmap pmap;

   pmap = getPixmap(fname);

   if(pmap != XmUNSPECIFIED_PIXMAP)
   {
      backgroundPixmap(pmap);
   }
}

void 
CoreClass::backgroundPixmap(Pixmap p)
{
   XtVaSetValues(widget(),XmNbackgroundPixmap, p, NULL);
}

Pixmap 
CoreClass::backgroundPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNbackgroundPixmap, &p, NULL);
   return p;
}

void 
CoreClass::borderColor(Pixel p)
{
   XtVaSetValues(widget(),XmNborderColor, p, NULL);
}

Pixel 
CoreClass::borderColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNborderColor, &p, NULL);
   return p;
}

void 
CoreClass::borderPixmap(Pixmap p)
{
   XtVaSetValues(widget(),XmNborderPixmap, p, NULL);
}

Pixmap 
CoreClass::borderPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNborderPixmap, &p, NULL);
   return p;
}

Colormap 
CoreClass::colormap()
{
   Colormap c;
   XtVaGetValues(widget(),XmNcolormap, &c, NULL);
   return c;
}

int 
CoreClass::depth()
{
   int d;
   XtVaGetValues(widget(),XmNdepth, &d, NULL);
   return d;
}

Boolean 
CoreClass::mappedWhenManaged()
{
   Boolean b;
   XtVaGetValues(widget(),XmNmappedWhenManaged, &b, NULL);
   return b;
}

void 
CoreClass::mappedWhenManaged(Boolean b)
{
   XtVaSetValues(widget(),XmNmappedWhenManaged, b, NULL);
}

Screen *
CoreClass::screen()
{
   Screen *s;
   XtVaGetValues(widget(),XmNscreen, &s, NULL);
   return s;
}

XtTranslations 
CoreClass::translations()
{
   XtTranslations t;
   XtVaGetValues(widget(),XmNtranslations, &t, NULL);
   return t;
}

void 
CoreClass::translations(XtTranslations t)
{
   XtVaSetValues(widget(),XmNtranslations, t, NULL);
}

