/* $Id: DrawnB.C,v 1.3 1997/04/08 15:53:46 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/DrawnB.h>

/* DrawnButtonClass member functions */
/* Callbacks */
void 
DrawnButtonClass::activateCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNactivateCallback,funcp,data);
}

void 
DrawnButtonClass::armCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNarmCallback,funcp,data);
}

void 
DrawnButtonClass::disarmCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void 
DrawnButtonClass::exposeCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNexposeCallback,funcp,data);
}

void 
DrawnButtonClass::resizeCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNresizeCallback,funcp,data);
}

/* Resources */
void 
DrawnButtonClass::multiClick(unsigned char c)
{
   XtVaSetValues(widget(),XmNmultiClick,c,NULL);
}

unsigned char 
DrawnButtonClass::multiClick()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNmultiClick, &c,NULL);
   return c;
}

void 
DrawnButtonClass::pushButtonEnabled(Boolean b)
{
   XtVaSetValues(widget(),XmNpushButtonEnabled,b,NULL);
}

Boolean 
DrawnButtonClass::pushButtonEnabled()
{
   Boolean b;
   XtVaGetValues(widget(),XmNpushButtonEnabled, &b,NULL);
   return b;
}
void 
DrawnButtonClass::shadowType(unsigned char c)
{
   XtVaSetValues(widget(),XmNshadowType,c,NULL);
}

unsigned char 
DrawnButtonClass::shadowType()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNshadowType,&c,NULL);
   return c;
}

/* constructor */
DrawnButton::DrawnButton(Widget w_parent,
                         ArgList arglist,
                         Cardinal cnt,
                         _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

DrawnButton::DrawnButton(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
   manage();
}

DrawnButton::DrawnButton(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   manage();
}

/* */
