/* $Id: Frame.C,v 1.2 1997/04/08 15:20:55 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Frame.h>

/* FrameClass member functions */
/* resources */
void
FrameClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(),XmNmarginWidth,d, NULL);
}

Dimension
FrameClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginWidth, &d, NULL);
   return d;
}

void
FrameClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(),XmNmarginHeight,d, NULL);
}

Dimension
FrameClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(),XmNmarginHeight, &d, NULL);
   return d;
}

void
FrameClass::shadowType(unsigned char s)
{
   XtVaSetValues(widget(),XmNshadowType,s, NULL);
}

unsigned char
FrameClass::shadowType()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNshadowType, &c, NULL);
   return c;
}

Frame::Frame(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

Frame::Frame(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
}

Frame::Frame(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent, NULL, 0);
   widget(wid);
}


