/* $Id: Label.C,v 1.2 1997/04/08 15:20:55 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Label.h>
/* LabelClass Members */

void
LabelClass::accelerator(_XtString acc)
{
   XtVaSetValues(widget(),XmNaccelerator,acc,NULL);
}

_XtString
LabelClass::accelerator()
{
   _XtString acc;
   XtVaGetValues(widget(),XmNaccelerator, &acc,NULL);
   return acc;
}

void
LabelClass::acceleratorText(char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNacceleratorText, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelClass::acceleratorText()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNacceleratorText, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelClass::alignment(unsigned char setting)
{
   XtVaSetValues(widget(), XmNalignment, setting, NULL);
}

unsigned char
LabelClass::alignment()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNalignment, &c, NULL);
   return c;
}

void
LabelClass::fontList(XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
LabelClass::fontList()
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
LabelClass::labelInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelInsensitivePixmap, p, NULL);
}

Pixmap
LabelClass::labelInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelInsensitivePixmap, &p, NULL);
   return p;
}

void
LabelClass::labelPixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNlabelPixmap, p, NULL);
}

Pixmap
LabelClass::labelPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNlabelPixmap, &p, NULL);
   return p;
}

void
LabelClass::labelString(char *s)
{
   XmString xmstr = cvtStringToXmString(s);
   XtVaSetValues(widget(), XmNlabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
LabelClass::labelString()
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void
LabelClass::labelType(unsigned char c)
{
   XtVaSetValues(widget(), XmNlabelType, c, NULL);
}

unsigned char
LabelClass::labelType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlabelType, &c, NULL);
   return c;
}

void
LabelClass::marginBottom(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginBottom, d, NULL);
}

Dimension
LabelClass::marginBottom()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginBottom, &d, NULL);
   return d;
}

void
LabelClass::marginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginHeight, d, NULL);
}

Dimension
LabelClass::marginHeight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginHeight, &d, NULL);
   return d;
}

void
LabelClass::marginLeft(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginLeft, d, NULL);
}

Dimension
LabelClass::marginLeft()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginLeft, &d, NULL);
   return d;
}

void
LabelClass::marginRight(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginRight, d, NULL);
}

Dimension
LabelClass::marginRight()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginRight, &d, NULL);
   return d;
}

void
LabelClass::marginTop(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginTop, d, NULL);
}

Dimension
LabelClass::marginTop()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginTop, &d, NULL);
   return d;
}

void
LabelClass::marginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNmarginWidth, d, NULL);
}

Dimension
LabelClass::marginWidth()
{
   Dimension d;
   XtVaGetValues(widget(), XmNmarginWidth, &d, NULL);
   return d;
}

void 
LabelClass::mnemonic(KeySym ch) 
{
   XtVaSetValues(widget(),XmNmnemonic,ch,NULL);
}

KeySym
LabelClass::mnemonic() 
{
   KeySym ch;
   XtVaGetValues(widget(),XmNmnemonic,&ch,NULL);
   return ch;
}

void 
LabelClass::mnemonicCharSet(_XtString str)
{
   XtVaSetValues(widget(),XmNmnemonicCharSet,str,NULL);
}

_XtString
LabelClass::mnemonicCharSet()
{
   _XtString str;
   XtVaGetValues(widget(),XmNmnemonicCharSet,&str,NULL);
   return str;
}

void 
LabelClass::recomputeSize(Boolean expr)
{
   XtVaSetValues(widget(),XmNrecomputeSize,expr,NULL);
}

Boolean
LabelClass::recomputeSize()
{
   Boolean b;
   XtVaGetValues(widget(),XmNrecomputeSize, &b,NULL);
   return b;
}

void
LabelClass::stringDirection(XmStringDirection dir)
{
   XtVaSetValues(widget(), XmNstringDirection, dir, NULL);
}

XmStringDirection
LabelClass::stringDirection()
{
   XmStringDirection dir;
   XtVaGetValues(widget(), XmNstringDirection, &dir, NULL);
   return dir;
}

/* Label constructors */
Label::Label(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
   manage();
}

Label::Label(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   widget(wid);
   manage();
}

Label::Label(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);

   widget(wid);
   manage();
}

Label::Label(Widget w_parent, char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);

   widget(wid);
   labelString(str);
   manage();
}

