/* $Id: Manager.C,v 1.1.1.1 1997/03/19 13:32:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Manager.h>
/* ManagerClass members */
/* callbacks */
void
ManagerClass::helpCallback(XtCallbackProc funcp, XtPointer udata)
{
   XtVaSetValues(widget(),XmNhelpCallback,funcp,udata, NULL);
}

/* resources */
void
ManagerClass::bottomShadowColor(Pixel pixel)
{
   XtVaSetValues(widget(),XmNbottomShadowColor,pixel,NULL);
}

Pixel
ManagerClass::bottomShadowColor()
{
   Pixel pixel;
   XtVaGetValues(widget(),XmNbottomShadowColor,&pixel,NULL);
   return pixel;
}

void
ManagerClass::bottomShadowPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNbottomShadowPixmap,pixmap,NULL);
}

Pixmap
ManagerClass::bottomShadowPixmap()
{
   Pixmap pixmap;
   XtVaGetValues(widget(),XmNbottomShadowPixmap,&pixmap,NULL);
   return pixmap;
}

void
ManagerClass::foreground(Pixel pixel)
{
   XtVaSetValues(widget(),XmNforeground,pixel,NULL);
}

Pixel
ManagerClass::foreground()
{
   Pixel p;
   XtVaGetValues(widget(),XmNforeground, &p,NULL);
   return p;
}

void
ManagerClass::highlightColor(Pixel p)
{
   XtVaSetValues(widget(),XmNhighlightColor,p,NULL);
}

Pixel
ManagerClass::highlightColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNhighlightColor,&p,NULL);
   return p;
}

void
ManagerClass::highlightPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNhighlightPixmap,pixmap,NULL);
}

Pixmap
ManagerClass::highlightPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNhighlightPixmap, &p,NULL);
   return p;
}

void
ManagerClass::navigationType(XmNavigationType n)
{
   XtVaSetValues(widget(),XmNnavigationType, n, NULL);
}

XmNavigationType
ManagerClass::navigationType()
{
   XmNavigationType n;
   XtVaGetValues(widget(),XmNnavigationType, &n, NULL);
   return n;
}

void
ManagerClass::shadowThickness(Dimension dim)
{
   XtVaSetValues(widget(),XmNshadowThickness, dim, NULL);
}

Dimension
ManagerClass::shadowThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNshadowThickness, &d, NULL);
   return d;
}

XmStringDirection
ManagerClass::stringDirection()
{
   XmStringDirection s;
   XtVaGetValues(widget(),XmNstringDirection, &s, NULL);
   return s;
}

void
ManagerClass::topShadowColor(Pixel pixel)
{
   XtVaSetValues(widget(),XmNtopShadowColor, pixel, NULL);
}

Pixel
ManagerClass::topShadowColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNtopShadowColor, &p, NULL);
   return p;
}

void
ManagerClass::topShadowPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNtopShadowPixmap, pixmap, NULL);
}

Pixmap
ManagerClass::topShadowPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNtopShadowPixmap, &p, NULL);
   return p;
}

void
ManagerClass::unitType(unsigned char unit)
{
   XtVaSetValues(widget(),XmNunitType, unit, NULL);
}

unsigned char
ManagerClass::unitType()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNunitType, &c, NULL);
   return c;
}

void
ManagerClass::userData(XtPointer udata)
{
   XtVaSetValues(widget(),XmNuserData, udata, NULL);
}

XtPointer
ManagerClass::userData()
{
   XtPointer udata;
   XtVaGetValues(widget(),XmNuserData, &udata, NULL);
   return udata;
}

