/* $Id: Primitive.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Xarm/Primitive.h>

/* callbacks */
void 
PrimitiveClass::helpCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNhelpCallback, funcp, data);
}

/* resources */
void
PrimitiveClass::bottomShadowColor(Pixel pixel)
{
   XtVaSetValues(widget(),XmNbottomShadowColor,pixel,NULL);
}

Pixel
PrimitiveClass::bottomShadowColor()
{
   Pixel pixel;
   XtVaGetValues(widget(),XmNbottomShadowColor,&pixel,NULL);
   return pixel;
}

void
PrimitiveClass::bottomShadowPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNbottomShadowPixmap,pixmap,NULL);
}

Pixmap
PrimitiveClass::bottomShadowPixmap()
{
   Pixmap pixmap;
   XtVaGetValues(widget(),XmNbottomShadowPixmap,&pixmap,NULL);
   return pixmap;
}

void
PrimitiveClass::foreground(Pixel pixel)
{
   XtVaSetValues(widget(),XmNforeground,pixel,NULL);
}

Pixel
PrimitiveClass::foreground()
{
   Pixel p;
   XtVaGetValues(widget(),XmNforeground, &p,NULL);
   return p;
}

void
PrimitiveClass::highlightColor(Pixel p)
{
   XtVaSetValues(widget(),XmNhighlightColor,p,NULL);
}

Pixel
PrimitiveClass::highlightColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNhighlightColor,&p,NULL);
   return p;
}

void
PrimitiveClass::highlightOnEnter(Boolean b)
{
   XtVaSetValues(widget(),XmNhighlightOnEnter,b,NULL);
}

Boolean
PrimitiveClass::highlightOnEnter()
{
   Boolean b;
   XtVaGetValues(widget(),XmNhighlightOnEnter,&b,NULL);
   return b;
}

void
PrimitiveClass::highlightPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNhighlightPixmap,pixmap,NULL);
}

Pixmap
PrimitiveClass::highlightPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNhighlightPixmap, &p,NULL);
   return p;
}

void
PrimitiveClass::highlightThickness(Dimension d)
{
   XtVaSetValues(widget(),XmNhighlightThickness,d,NULL);
}

Dimension
PrimitiveClass::highlightThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNhighlightThickness, &d,NULL);
   return d;
}

void
PrimitiveClass::navigationType(XmNavigationType n)
{
   XtVaSetValues(widget(),XmNnavigationType, n, NULL);
}

XmNavigationType
PrimitiveClass::navigationType()
{
   XmNavigationType n;
   XtVaGetValues(widget(),XmNnavigationType, &n, NULL);
   return n;
}

void
PrimitiveClass::shadowThickness(Dimension dim)
{
   XtVaSetValues(widget(),XmNshadowThickness, dim, NULL);
}

Dimension
PrimitiveClass::shadowThickness()
{
   Dimension d;
   XtVaGetValues(widget(),XmNshadowThickness, &d, NULL);
   return d;
}

void
PrimitiveClass::topShadowColor(Pixel pixel)
{
   XtVaSetValues(widget(),XmNtopShadowColor, pixel, NULL);
}

Pixel
PrimitiveClass::topShadowColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNtopShadowColor, &p, NULL);
   return p;
}

void
PrimitiveClass::topShadowPixmap(Pixmap pixmap)
{
   XtVaSetValues(widget(),XmNtopShadowPixmap, pixmap, NULL);
}

Pixmap
PrimitiveClass::topShadowPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNtopShadowPixmap, &p, NULL);
   return p;
}

void 
PrimitiveClass::traversalOn(Boolean on) 
{
      XtVaSetValues(widget(),XmNtraversalOn,on, NULL);
}

Boolean 
PrimitiveClass::traversalOn() 
{
   int on = FALSE;
   XtVaGetValues(widget(),XmNtraversalOn,&on, NULL);
   return on;
}

void
PrimitiveClass::unitType(unsigned char unit)
{
   XtVaSetValues(widget(),XmNunitType, unit, NULL);
}

unsigned char
PrimitiveClass::unitType()
{
   unsigned char c;
   XtVaGetValues(widget(),XmNunitType, &c, NULL);
   return c;
}

void 
PrimitiveClass::userData(XtPointer udata) 
{
   XtVaSetValues(widget(),XmNuserData,udata,NULL);
}

XtPointer 
PrimitiveClass::userData() 
{
   XtPointer udata;
   XtVaGetValues(widget(),XmNuserData,&udata,NULL);
   return udata;
}

/* *** */


